/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.version.undo;

import org.apache.wicket.Component;
import org.apache.wicket.util.lang.Classes;
import org.apache.wicket.version.undo.Change;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Add
extends Change {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger((Class)Add.class);
    private final Component component;

    Add(Component component) {
        if (component == null) {
            throw new IllegalArgumentException("argument component must be not null");
        }
        if (component.getParent() == null) {
            throw new IllegalStateException("component " + component + " doesn't have a parent");
        }
        if (log.isDebugEnabled()) {
            log.debug("RECORD ADD: added " + component.getPath() + " (" + Classes.simpleName(component.getClass()) + "@" + component.hashCode() + ") to parent");
        }
        this.component = component;
    }

    public void undo() {
        if (log.isDebugEnabled()) {
            log.debug("UNDO ADD: removing " + this.component.getPath() + " (" + Classes.simpleName(this.component.getClass()) + "@" + this.component.hashCode() + ") from parent");
        }
        if (this.component.getParent() != null) {
            this.component.remove();
        }
    }

    public String toString() {
        return "Add[component: " + this.component.getPath() + "]";
    }
}

