/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.validation.validator;

import java.util.Map;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.validator.AbstractValidator;

public abstract class NumberValidator
extends AbstractValidator {
    private static final long serialVersionUID = 1L;
    public static final NumberValidator POSITIVE = NumberValidator.minimum(Double.MIN_VALUE);
    public static final NumberValidator NEGATIVE = NumberValidator.maximum(-4.9E-324);

    public static NumberValidator range(long minimum, long maximum) {
        return new RangeValidator(minimum, maximum);
    }

    public static NumberValidator minimum(long minimum) {
        return new MinimumValidator(minimum);
    }

    public static NumberValidator maximum(long maximum) {
        return new MaximumValidator(maximum);
    }

    public static NumberValidator range(double minimum, double maximum) {
        return new DoubleRangeValidator(minimum, maximum);
    }

    public static NumberValidator minimum(double minimum) {
        return new DoubleMinimumValidator(minimum);
    }

    public static NumberValidator maximum(double maximum) {
        return new DoubleMaximumValidator(maximum);
    }

    public static class DoubleMaximumValidator
    extends NumberValidator {
        private static final long serialVersionUID = 1L;
        private final double maximum;

        public DoubleMaximumValidator(double maximum) {
            this.maximum = maximum;
        }

        protected Map variablesMap(IValidatable validatable) {
            Map map = super.variablesMap(validatable);
            map.put("maximum", new Double(this.maximum));
            return map;
        }

        protected String resourceKey() {
            return "NumberValidator.maximum";
        }

        protected void onValidate(IValidatable validatable) {
            if (((Number)validatable.getValue()).doubleValue() > this.maximum) {
                this.error(validatable);
            }
        }
    }

    public static class DoubleMinimumValidator
    extends NumberValidator {
        private static final long serialVersionUID = 1L;
        private final double minimum;

        public DoubleMinimumValidator(double minimum) {
            this.minimum = minimum;
        }

        protected Map variablesMap(IValidatable validatable) {
            Map map = super.variablesMap(validatable);
            map.put("minimum", new Double(this.minimum));
            return map;
        }

        protected String resourceKey() {
            return "NumberValidator.minimum";
        }

        protected void onValidate(IValidatable validatable) {
            if (((Number)validatable.getValue()).doubleValue() < this.minimum) {
                this.error(validatable);
            }
        }
    }

    public static class DoubleRangeValidator
    extends NumberValidator {
        private static final long serialVersionUID = 1L;
        private final double minimum;
        private final double maximum;

        public DoubleRangeValidator(double minimum, double maximum) {
            this.minimum = minimum;
            this.maximum = maximum;
        }

        protected Map variablesMap(IValidatable validatable) {
            Map map = super.variablesMap(validatable);
            map.put("minimum", new Double(this.minimum));
            map.put("maximum", new Double(this.maximum));
            return map;
        }

        protected String resourceKey() {
            return "NumberValidator.range";
        }

        protected void onValidate(IValidatable validatable) {
            Number value = (Number)validatable.getValue();
            if (value.doubleValue() < this.minimum || value.doubleValue() > this.maximum) {
                this.error(validatable);
            }
        }
    }

    public static class MaximumValidator
    extends NumberValidator {
        private static final long serialVersionUID = 1L;
        private final long maximum;

        public MaximumValidator(long maximum) {
            this.maximum = maximum;
        }

        protected Map variablesMap(IValidatable validatable) {
            Map map = super.variablesMap(validatable);
            map.put("maximum", new Long(this.maximum));
            return map;
        }

        protected String resourceKey() {
            return "NumberValidator.maximum";
        }

        protected void onValidate(IValidatable validatable) {
            if (((Number)validatable.getValue()).longValue() > this.maximum) {
                this.error(validatable);
            }
        }
    }

    public static class MinimumValidator
    extends NumberValidator {
        private static final long serialVersionUID = 1L;
        private final long minimum;

        public MinimumValidator(long minimum) {
            this.minimum = minimum;
        }

        protected Map variablesMap(IValidatable validatable) {
            Map map = super.variablesMap(validatable);
            map.put("minimum", new Long(this.minimum));
            return map;
        }

        protected String resourceKey() {
            return "NumberValidator.minimum";
        }

        protected void onValidate(IValidatable validatable) {
            if (((Number)validatable.getValue()).longValue() < this.minimum) {
                this.error(validatable);
            }
        }
    }

    public static class RangeValidator
    extends NumberValidator {
        private static final long serialVersionUID = 1L;
        private final long minimum;
        private final long maximum;

        public RangeValidator(long minimum, long maximum) {
            this.minimum = minimum;
            this.maximum = maximum;
        }

        protected Map variablesMap(IValidatable validatable) {
            Map map = super.variablesMap(validatable);
            map.put("minimum", new Long(this.minimum));
            map.put("maximum", new Long(this.maximum));
            return map;
        }

        protected String resourceKey() {
            return "NumberValidator.range";
        }

        protected void onValidate(IValidatable validatable) {
            Number value = (Number)validatable.getValue();
            if (value.longValue() < this.minimum || value.longValue() > this.maximum) {
                this.error(validatable);
            }
        }
    }
}

