/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.validation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.wicket.IClusterable;
import org.apache.wicket.validation.IErrorMessageSource;
import org.apache.wicket.validation.IValidationError;

public class ValidationError
implements IValidationError,
IClusterable {
    private static final long serialVersionUID = 1L;
    private final List keys = new ArrayList(1);
    private Map vars;
    private String message;

    public ValidationError addMessageKey(String key) {
        if (key == null || key.trim().length() == 0) {
            throw new IllegalArgumentException("Argument [[key]] cannot be null or an empty string");
        }
        this.keys.add(key);
        return this;
    }

    public ValidationError setVariable(String name, Object value) {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("Argument [[name]] cannot be null or an empty string");
        }
        if (value == null) {
            throw new IllegalArgumentException("Argument [[value]] cannot be null or an empty string");
        }
        this.getVariables().put(name, value);
        return this;
    }

    public final Map getVariables() {
        if (this.vars == null) {
            this.vars = new HashMap(2);
        }
        return this.vars;
    }

    public final ValidationError setVariables(Map vars) {
        if (vars == null) {
            throw new IllegalArgumentException("Argument [[vars]] cannot be null");
        }
        this.vars = vars;
        return this;
    }

    public final String getErrorMessage(IErrorMessageSource messageSource) {
        String errorMessage = null;
        Iterator iterator = this.keys.iterator();
        while (iterator.hasNext() && (errorMessage = messageSource.getMessage((String)iterator.next())) == null) {
        }
        if (errorMessage == null && this.message != null) {
            errorMessage = this.message;
        }
        if (errorMessage != null) {
            Map p = this.vars == null ? Collections.EMPTY_MAP : this.vars;
            errorMessage = messageSource.substitute(errorMessage, p);
        }
        return errorMessage;
    }

    public final String getMessage() {
        return this.message;
    }

    public final ValidationError setMessage(String message) {
        if (message == null) {
            throw new IllegalArgumentException("Argument [[defaultMessage]] cannot be null");
        }
        this.message = message;
        return this;
    }

    public String toString() {
        Iterator<Object> i;
        StringBuffer tostring = new StringBuffer();
        tostring.append("[").append(this.getClass().getName());
        tostring.append(" message=[").append(this.message);
        tostring.append("], keys=[");
        if (this.keys != null) {
            i = this.keys.iterator();
            while (i.hasNext()) {
                tostring.append(i.next());
                if (!i.hasNext()) continue;
                tostring.append(", ");
            }
        } else {
            tostring.append("null");
        }
        tostring.append("], variables=[");
        if (this.vars != null) {
            i = this.vars.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry e = (Map.Entry)i.next();
                tostring.append("[").append(e.getKey()).append("=").append(e.getValue()).append("]");
                if (!i.hasNext()) continue;
                tostring.append(",");
            }
        } else {
            tostring.append("null");
        }
        tostring.append("]");
        tostring.append("]");
        return tostring.toString();
    }
}

