/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.tester;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.protocol.http.HttpSessionStore;
import org.apache.wicket.protocol.http.MockHttpServletResponse;
import org.apache.wicket.protocol.http.SecondLevelCacheSessionStore;
import org.apache.wicket.protocol.http.UnitTestSettings;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.WebResponse;
import org.apache.wicket.session.ISessionStore;
import org.apache.wicket.util.diff.DiffUtil;
import org.apache.wicket.util.tester.BaseWicketTester;
import org.apache.wicket.util.tester.Result;
import org.apache.wicket.util.tester.WicketTesterHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WicketTester
extends BaseWicketTester {
    private static final Logger log = LoggerFactory.getLogger((Class)WicketTester.class);
    static /* synthetic */ Class class$org$apache$wicket$util$tester$DummyHomePage;

    public WicketTester() {
        this(new DummyWebApplication());
    }

    public WicketTester(final Class homePage) {
        this(new WebApplication(){

            public Class getHomePage() {
                return homePage;
            }

            protected ISessionStore newSessionStore() {
                return new HttpSessionStore(this);
            }

            protected WebResponse newWebResponse(HttpServletResponse servletResponse) {
                return new WebResponse(servletResponse);
            }

            protected void outputDevelopmentModeWarning() {
            }
        });
    }

    public WicketTester(WebApplication application) {
        this(application, null);
    }

    public WicketTester(WebApplication application, String path) {
        super(application, path);
        UnitTestSettings.setSortUrlParameters(true);
    }

    public void assertAjaxLocation() {
        if (null != ((MockHttpServletResponse)this.getWicketResponse().getHttpServletResponse()).getRedirectLocation()) {
            throw new AssertionFailedError("Location header should *not* be present when using Ajax");
        }
        String ajaxLocation = ((MockHttpServletResponse)this.getWicketResponse().getHttpServletResponse()).getHeader("Ajax-Location");
        if (null == ajaxLocation) {
            throw new AssertionFailedError("Ajax-Location header should be present when using Ajax");
        }
        int statusCode = ((MockHttpServletResponse)this.getWicketResponse().getHttpServletResponse()).getStatus();
        if (statusCode != 200) {
            throw new AssertionFailedError("Expected HTTP status code to be 200 (OK)");
        }
    }

    public void assertComponent(String path, Class expectedComponentClass) {
        this.assertResult(this.isComponent(path, expectedComponentClass));
    }

    public void assertComponentOnAjaxResponse(Component component) {
        Result result = this.isComponentOnAjaxResponse(component);
        this.assertResult(result);
    }

    public void assertComponentOnAjaxResponse(String componentPath) {
        this.assertComponentOnAjaxResponse(this.getComponentFromLastRenderedPage(componentPath));
    }

    public void assertContains(String pattern) {
        this.assertResult(this.ifContains(pattern));
    }

    public void assertErrorMessages(String[] expectedErrorMessages) {
        List actualMessages = this.getMessages(400);
        ArrayList<String> msgs = new ArrayList<String>();
        Iterator iterator = actualMessages.iterator();
        while (iterator.hasNext()) {
            msgs.add(iterator.next().toString());
        }
        WicketTesterHelper.assertEquals(Arrays.asList(expectedErrorMessages), msgs);
    }

    public void assertInfoMessages(String[] expectedInfoMessages) {
        List actualMessages = this.getMessages(200);
        WicketTesterHelper.assertEquals(Arrays.asList(expectedInfoMessages), actualMessages);
    }

    public void assertInvisible(String path) {
        this.assertResult(this.isInvisible(path));
    }

    public void assertLabel(String path, String expectedLabelText) {
        Label label = (Label)this.getComponentFromLastRenderedPage(path);
        Assert.assertEquals((String)expectedLabelText, (String)label.getModelObjectAsString());
    }

    public void assertModelValue(String path, Object expectedValue) {
        Component component = this.getComponentFromLastRenderedPage(path);
        Assert.assertEquals((Object)expectedValue, (Object)component.getModelObject());
    }

    public void assertListView(String path, List expectedList) {
        ListView listView = (ListView)this.getComponentFromLastRenderedPage(path);
        WicketTesterHelper.assertEquals(expectedList, listView.getList());
    }

    public void assertNoErrorMessage() {
        List messages = this.getMessages(400);
        Assert.assertTrue((String)("expect no error message, but contains\n" + WicketTesterHelper.asLined(messages)), (boolean)messages.isEmpty());
    }

    public void assertNoInfoMessage() {
        List messages = this.getMessages(200);
        Assert.assertTrue((String)("expect no info message, but contains\n" + WicketTesterHelper.asLined(messages)), (boolean)messages.isEmpty());
    }

    public void assertPageLink(String path, Class expectedPageClass) {
        this.assertResult(this.isPageLink(path, expectedPageClass));
    }

    public void assertRenderedPage(Class expectedRenderedPageClass) {
        this.assertResult(this.isRenderedPage(expectedRenderedPageClass));
    }

    public void assertResultPage(Class clazz, String filename) throws Exception {
        String document = this.getServletResponse().getDocument();
        this.setupRequestAndResponse();
        DiffUtil.validatePage(document, clazz, filename, true);
    }

    public void assertResultPage(String expectedDocument) throws Exception {
        String document = this.getServletResponse().getDocument();
        Assert.assertEquals((String)expectedDocument, (String)document);
    }

    public void assertVisible(String path) {
        this.assertResult(this.isVisible(path));
    }

    private void assertResult(Result result) {
        if (result.wasFailed()) {
            throw new AssertionFailedError(result.getMessage());
        }
    }

    public static class NonPageCachingDummyWebApplication
    extends DummyWebApplication {
        protected ISessionStore newSessionStore() {
            return new SecondLevelCacheSessionStore(this, new SecondLevelCacheSessionStore.IPageStore(this){
                private final /* synthetic */ NonPageCachingDummyWebApplication this$0;
                {
                    this.this$0 = this$0;
                }

                public void destroy() {
                }

                public Page getPage(String sessionId, String pagemap, int id, int versionNumber, int ajaxVersionNumber) {
                    return null;
                }

                public void pageAccessed(String sessionId, Page page) {
                }

                public void removePage(String sessionId, String pagemap, int id) {
                }

                public void storePage(String sessionId, Page page) {
                }

                public void unbind(String sessionId) {
                }

                public boolean containsPage(String sessionId, String pageMapName, int pageId, int pageVersion) {
                    return false;
                }
            });
        }
    }

    public static class DummyWebApplication
    extends WebApplication {
        public Class getHomePage() {
            return class$org$apache$wicket$util$tester$DummyHomePage == null ? (class$org$apache$wicket$util$tester$DummyHomePage = WicketTester.class$("org.apache.wicket.util.tester.DummyHomePage")) : class$org$apache$wicket$util$tester$DummyHomePage;
        }

        protected ISessionStore newSessionStore() {
            return new HttpSessionStore(this);
        }

        protected WebResponse newWebResponse(HttpServletResponse servletResponse) {
            return new WebResponse(servletResponse);
        }

        protected void outputDevelopmentModeWarning() {
        }
    }
}

