/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.resource.locator;

import java.util.Iterator;
import java.util.Locale;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.util.resource.locator.ExtensionResourceNameIterator;
import org.apache.wicket.util.resource.locator.LocaleResourceNameIterator;
import org.apache.wicket.util.resource.locator.StyleAndVariationResourceNameIterator;
import org.apache.wicket.util.string.Strings;

public class ResourceNameIterator
implements Iterator {
    private final Locale locale;
    private final String extensions;
    private final Iterator styleIterator;
    private LocaleResourceNameIterator localeIterator;
    private Iterator extenstionsIterator;
    private Locale currentLocale;

    public ResourceNameIterator(String path, String style, Locale locale, String extensions) {
        this.locale = locale;
        if (extensions == null) {
            this.extensions = Strings.afterLast(path, '.');
            path = Strings.beforeLast(path, '.');
        } else {
            this.extensions = extensions;
        }
        this.styleIterator = new StyleAndVariationResourceNameIterator(path, style, null);
    }

    public final Locale getLocale() {
        return this.currentLocale;
    }

    public boolean hasNext() {
        String newPath;
        if (this.extenstionsIterator != null) {
            if (this.extenstionsIterator.hasNext()) {
                return true;
            }
            this.extenstionsIterator = null;
        }
        if (this.localeIterator != null) {
            while (this.localeIterator.hasNext()) {
                newPath = (String)this.localeIterator.next();
                this.currentLocale = this.localeIterator.getLocale();
                this.extenstionsIterator = new ExtensionResourceNameIterator(newPath, this.extensions);
                if (!this.extenstionsIterator.hasNext()) continue;
                return true;
            }
            this.localeIterator = null;
        }
        while (this.styleIterator.hasNext()) {
            newPath = (String)this.styleIterator.next();
            this.localeIterator = new LocaleResourceNameIterator(newPath, this.locale);
            while (this.localeIterator.hasNext()) {
                newPath = (String)this.localeIterator.next();
                this.currentLocale = this.localeIterator.getLocale();
                this.extenstionsIterator = new ExtensionResourceNameIterator(newPath, this.extensions);
                if (!this.extenstionsIterator.hasNext()) continue;
                return true;
            }
        }
        return false;
    }

    public Object next() {
        if (this.extenstionsIterator != null) {
            return this.extenstionsIterator.next();
        }
        throw new WicketRuntimeException("Illegal call of next(). Iterator not properly initialized");
    }

    public void remove() {
    }
}

