/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.convert;

import java.lang.ref.WeakReference;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.wicket.IConverterLocator;
import org.apache.wicket.util.convert.ConversionException;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.convert.converters.BooleanConverter;
import org.apache.wicket.util.convert.converters.ByteConverter;
import org.apache.wicket.util.convert.converters.CharacterConverter;
import org.apache.wicket.util.convert.converters.DateConverter;
import org.apache.wicket.util.convert.converters.DoubleConverter;
import org.apache.wicket.util.convert.converters.FloatConverter;
import org.apache.wicket.util.convert.converters.IntegerConverter;
import org.apache.wicket.util.convert.converters.LongConverter;
import org.apache.wicket.util.convert.converters.ShortConverter;
import org.apache.wicket.util.convert.converters.SqlDateConverter;
import org.apache.wicket.util.convert.converters.SqlTimeConverter;
import org.apache.wicket.util.convert.converters.SqlTimestampConverter;
import org.apache.wicket.util.lang.Objects;

public class ConverterLocator
implements IConverterLocator {
    private static final long serialVersionUID = 1L;
    private final Map classToConverter = new HashMap();

    public ConverterLocator() {
        this.set(Boolean.TYPE, BooleanConverter.INSTANCE);
        this.set(Boolean.class, BooleanConverter.INSTANCE);
        this.set(Byte.TYPE, ByteConverter.INSTANCE);
        this.set(Byte.class, ByteConverter.INSTANCE);
        this.set(Character.TYPE, CharacterConverter.INSTANCE);
        this.set(Character.class, CharacterConverter.INSTANCE);
        this.set(Double.TYPE, DoubleConverter.INSTANCE);
        this.set(Double.class, DoubleConverter.INSTANCE);
        this.set(Float.TYPE, FloatConverter.INSTANCE);
        this.set(Float.class, FloatConverter.INSTANCE);
        this.set(Integer.TYPE, IntegerConverter.INSTANCE);
        this.set(Integer.class, IntegerConverter.INSTANCE);
        this.set(Long.TYPE, LongConverter.INSTANCE);
        this.set(Long.class, LongConverter.INSTANCE);
        this.set(Short.TYPE, ShortConverter.INSTANCE);
        this.set(Short.class, ShortConverter.INSTANCE);
        this.set(java.util.Date.class, new DateConverter());
        this.set(Date.class, new SqlDateConverter());
        this.set(Time.class, new SqlTimeConverter());
        this.set(Timestamp.class, new SqlTimestampConverter());
    }

    public final IConverter get(Class c) {
        return (IConverter)this.classToConverter.get(c.getName());
    }

    public final IConverter getConverter(Class type) {
        if (type == null) {
            return new DefaultConverter(String.class);
        }
        IConverter converter = this.get(type);
        if (converter == null) {
            return new DefaultConverter(type);
        }
        return converter;
    }

    public final IConverter remove(Class c) {
        return (IConverter)this.classToConverter.remove(c.getName());
    }

    public final IConverter set(Class c, IConverter converter) {
        if (converter == null) {
            throw new IllegalArgumentException("CoverterLocator cannot be null");
        }
        if (c == null) {
            throw new IllegalArgumentException("Class cannot be null");
        }
        return this.classToConverter.put(c.getName(), converter);
    }

    private class DefaultConverter
    implements IConverter {
        private static final long serialVersionUID = 1L;
        private final WeakReference type;

        public DefaultConverter(Class type) {
            this.type = new WeakReference<Class>(type);
        }

        public Object convertToObject(String value, Locale locale) {
            if (value == null) {
                return null;
            }
            if ("".equals(value)) {
                if ((Class)this.type.get() == (class$java$lang$String == null ? (class$java$lang$String = ConverterLocator.class$("java.lang.String")) : class$java$lang$String)) {
                    return "";
                }
                return null;
            }
            try {
                return Objects.convertValue(value, (Class)this.type.get());
            }
            catch (Exception e) {
                throw new ConversionException(e.getMessage(), e).setSourceValue(value);
            }
        }

        public String convertToString(Object value, Locale locale) {
            if (value == null || "".equals(value)) {
                return "";
            }
            return (String)Objects.convertValue(value, class$java$lang$String == null ? (class$java$lang$String = ConverterLocator.class$("java.lang.String")) : class$java$lang$String);
        }
    }
}

