/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.collections;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.wicket.util.collections.MiniMap;

public class MiniMap
implements Map,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Object[] keys;
    private final Object[] values;
    private int size;
    private int lastSearchIndex;

    public MiniMap(int maxEntries) {
        this.keys = new Object[maxEntries];
        this.values = new Object[maxEntries];
    }

    public MiniMap(Map map, int maxEntries) {
        this(maxEntries);
        this.putAll(map);
    }

    public boolean isFull() {
        return this.size == this.keys.length;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean containsKey(Object key) {
        return this.findKey(0, key) != -1;
    }

    public boolean containsValue(Object value) {
        return this.findValue(0, value) != -1;
    }

    public Object get(Object key) {
        int index = this.findKey(key);
        if (index != -1) {
            return this.values[index];
        }
        return null;
    }

    public Object put(Object key, Object value) {
        int index = this.findKey(key);
        if (index != -1) {
            Object oldValue = this.values[index];
            this.values[index] = value;
            return oldValue;
        }
        if (this.size < this.keys.length) {
            int nullIndex = this.nextNullKey(this.lastSearchIndex);
            this.lastSearchIndex = this.nextIndex(nullIndex);
            this.keys[nullIndex] = key;
            this.values[nullIndex] = value;
            ++this.size;
            return null;
        }
        throw new IllegalStateException("Map full");
    }

    public Object remove(Object key) {
        int index = this.findKey(key);
        if (index != -1) {
            Object oldValue = this.values[index];
            this.keys[index] = null;
            this.values[index] = null;
            --this.size;
            return oldValue;
        }
        return null;
    }

    public void putAll(Map map) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry e = iterator.next();
            this.put(e.getKey(), e.getValue());
        }
    }

    public void clear() {
        for (int i = 0; i < this.keys.length; ++i) {
            this.keys[i] = null;
            this.values[i] = null;
        }
        this.size = 0;
    }

    public Set keySet() {
        return new AbstractSet(){

            public Iterator iterator() {
                return new Iterator(this){
                    int i;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        this.i = -1;
                    }

                    public boolean hasNext() {
                        return this.i < MiniMap.access$100(1.access$000(this.this$1)) - 1;
                    }

                    public Object next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        this.i = MiniMap.access$300(1.access$000(this.this$1), MiniMap.access$200(1.access$000(this.this$1), this.i));
                        return MiniMap.access$400(1.access$000(this.this$1))[this.i];
                    }

                    public void remove() {
                        MiniMap.access$400((MiniMap)1.access$000(this.this$1))[this.i] = null;
                        MiniMap.access$500((MiniMap)1.access$000(this.this$1))[this.i] = null;
                        MiniMap.access$110(1.access$000(this.this$1));
                    }
                };
            }

            public int size() {
                return MiniMap.this.size;
            }

            static /* synthetic */ MiniMap access$000(1 x0) {
                return x0.MiniMap.this;
            }
        };
    }

    public Collection values() {
        return new AbstractList(){

            public Object get(int index) {
                if (index > MiniMap.this.size - 1) {
                    throw new IndexOutOfBoundsException();
                }
                int keyIndex = MiniMap.this.nextKey(0);
                for (int i = 0; i < index; ++i) {
                    keyIndex = MiniMap.this.nextKey(keyIndex + 1);
                }
                return MiniMap.this.values[keyIndex];
            }

            public int size() {
                return MiniMap.this.size;
            }
        };
    }

    public Set entrySet() {
        return new AbstractSet(){

            public Iterator iterator() {
                return new Iterator(this){
                    int keyIndex;
                    int index;
                    private final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = this$1;
                        this.keyIndex = -1;
                        this.index = 0;
                    }

                    public boolean hasNext() {
                        return this.index < MiniMap.access$100(4.access$600(this.this$1));
                    }

                    public Object next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        this.keyIndex = MiniMap.access$300(4.access$600(this.this$1), MiniMap.access$200(4.access$600(this.this$1), this.keyIndex));
                        ++this.index;
                        return new Map.Entry(this){
                            private final /* synthetic */ 5 this$2;
                            {
                                this.this$2 = this$2;
                            }

                            public Object getKey() {
                                return MiniMap.access$400(4.access$600(5.access$700(this.this$2)))[this.this$2.keyIndex];
                            }

                            public Object getValue() {
                                return MiniMap.access$500(4.access$600(5.access$700(this.this$2)))[this.this$2.keyIndex];
                            }

                            public Object setValue(Object value) {
                                Object oldValue = MiniMap.access$500(4.access$600(5.access$700(this.this$2)))[this.this$2.keyIndex];
                                MiniMap.access$500((MiniMap)4.access$600(5.access$700(this.this$2)))[this.this$2.keyIndex] = value;
                                return oldValue;
                            }
                        };
                    }

                    public void remove() {
                        MiniMap.access$400((MiniMap)4.access$600(this.this$1))[this.keyIndex] = null;
                        MiniMap.access$500((MiniMap)4.access$600(this.this$1))[this.keyIndex] = null;
                    }

                    static /* synthetic */ 4 access$700(5 x0) {
                        return x0.this$1;
                    }
                };
            }

            public int size() {
                return MiniMap.this.size;
            }

            static /* synthetic */ MiniMap access$600(4 x0) {
                return x0.MiniMap.this;
            }
        };
    }

    private int nextIndex(int index) {
        return (index + 1) % this.keys.length;
    }

    private int nextKey(int start) {
        int i = start;
        do {
            if (this.keys[i] == null) continue;
            return i;
        } while ((i = this.nextIndex(i)) != start);
        return -1;
    }

    private int nextNullKey(int start) {
        int i = start;
        do {
            if (this.keys[i] != null) continue;
            return i;
        } while ((i = this.nextIndex(i)) != start);
        return -1;
    }

    private int findKey(Object key) {
        int index = this.findKey(this.lastSearchIndex, key);
        if (index != -1) {
            this.lastSearchIndex = this.nextIndex(index);
            return index;
        }
        return -1;
    }

    private int findKey(int start, Object key) {
        int i = start;
        do {
            if (!key.equals(this.keys[i])) continue;
            return i;
        } while ((i = this.nextIndex(i)) != start);
        return -1;
    }

    private int findValue(int start, Object value) {
        int i = start;
        do {
            if (!value.equals(this.values[i])) continue;
            return i;
        } while ((i = this.nextIndex(i)) != start);
        return -1;
    }

    static /* synthetic */ int access$200(MiniMap x0, int x1) {
        return x0.nextIndex(x1);
    }

    static /* synthetic */ Object[] access$400(MiniMap x0) {
        return x0.keys;
    }

    static /* synthetic */ int access$110(MiniMap x0) {
        return x0.size--;
    }
}

