/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.target.coding;

import java.lang.ref.WeakReference;
import java.util.Map;
import org.apache.wicket.IRequestTarget;
import org.apache.wicket.PageParameters;
import org.apache.wicket.protocol.http.request.WebRequestCodingStrategy;
import org.apache.wicket.request.RequestParameters;
import org.apache.wicket.request.target.coding.AbstractRequestTargetUrlCodingStrategy;
import org.apache.wicket.request.target.component.BookmarkableListenerInterfaceRequestTarget;
import org.apache.wicket.request.target.component.BookmarkablePageRequestTarget;
import org.apache.wicket.request.target.component.IBookmarkablePageRequestTarget;
import org.apache.wicket.util.string.AppendingStringBuffer;

public class BookmarkablePageRequestTargetUrlCodingStrategy
extends AbstractRequestTargetUrlCodingStrategy {
    protected final WeakReference bookmarkablePageClassRef;
    private final String pageMapName;

    public BookmarkablePageRequestTargetUrlCodingStrategy(String mountPath, Class bookmarkablePageClass, String pageMapName) {
        super(mountPath);
        if (bookmarkablePageClass == null) {
            throw new IllegalArgumentException("Argument bookmarkablePageClass must be not null");
        }
        this.bookmarkablePageClassRef = new WeakReference<Class>(bookmarkablePageClass);
        this.pageMapName = pageMapName;
    }

    public IRequestTarget decode(RequestParameters requestParameters) {
        String parametersFragment = requestParameters.getPath().substring(this.getMountPath().length());
        PageParameters parameters = new PageParameters((Map)this.decodeParameters(parametersFragment, requestParameters.getParameters()));
        String pageMapName = WebRequestCodingStrategy.decodePageMapName((String)parameters.remove("wicket:pageMapName"));
        if (requestParameters.getPageMapName() == null) {
            requestParameters.setPageMapName(pageMapName);
        } else {
            pageMapName = requestParameters.getPageMapName();
        }
        String interfaceParameter = (String)parameters.remove("wicket:interface");
        if (interfaceParameter != null) {
            WebRequestCodingStrategy.addInterfaceParameters(interfaceParameter, requestParameters);
            return new BookmarkableListenerInterfaceRequestTarget(pageMapName, (Class)this.bookmarkablePageClassRef.get(), parameters, requestParameters.getComponentPath(), requestParameters.getInterfaceName(), requestParameters.getVersionNumber());
        }
        return new BookmarkablePageRequestTarget(pageMapName, (Class)this.bookmarkablePageClassRef.get(), parameters);
    }

    public final CharSequence encode(IRequestTarget requestTarget) {
        String pagemap;
        if (!(requestTarget instanceof IBookmarkablePageRequestTarget)) {
            throw new IllegalArgumentException("This encoder can only be used with instances of " + IBookmarkablePageRequestTarget.class.getName());
        }
        AppendingStringBuffer url = new AppendingStringBuffer(40);
        url.append(this.getMountPath());
        IBookmarkablePageRequestTarget target = (IBookmarkablePageRequestTarget)requestTarget;
        PageParameters pageParameters = target.getPageParameters();
        String string = pagemap = this.pageMapName != null ? this.pageMapName : target.getPageMapName();
        if (pagemap != null) {
            if (pageParameters == null) {
                pageParameters = new PageParameters();
            }
            pageParameters.put("wicket:pageMapName", WebRequestCodingStrategy.encodePageMapName(pagemap));
        }
        this.appendParameters(url, pageParameters);
        return url;
    }

    public boolean matches(IRequestTarget requestTarget) {
        if (requestTarget instanceof IBookmarkablePageRequestTarget) {
            IBookmarkablePageRequestTarget target = (IBookmarkablePageRequestTarget)requestTarget;
            if (((Class)this.bookmarkablePageClassRef.get()).equals(target.getPageClass())) {
                if (this.pageMapName == null) {
                    return true;
                }
                return this.pageMapName.equals(target.getPageMapName());
            }
        }
        return false;
    }

    public String toString() {
        return "BookmarkablePageEncoder[page=" + this.bookmarkablePageClassRef.get() + "]";
    }
}

