/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.target.coding;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.wicket.Application;
import org.apache.wicket.protocol.http.UnitTestSettings;
import org.apache.wicket.request.target.coding.IMountableRequestTargetUrlCodingStrategy;
import org.apache.wicket.request.target.coding.IRequestTargetUrlCodingStrategy;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.value.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRequestTargetUrlCodingStrategy
implements IRequestTargetUrlCodingStrategy,
IMountableRequestTargetUrlCodingStrategy {
    private static final Logger log = LoggerFactory.getLogger((Class)AbstractRequestTargetUrlCodingStrategy.class);
    private final String mountPath;

    public AbstractRequestTargetUrlCodingStrategy(String mountPath) {
        if (mountPath == null) {
            throw new IllegalArgumentException("Mount path cannot be null or empty");
        }
        String string = this.mountPath = mountPath.startsWith("/") ? mountPath.substring(1) : mountPath;
        if (this.mountPath.startsWith("resources/") || this.mountPath.equals("resources")) {
            throw new IllegalArgumentException("Mount path cannot be under '/resources'");
        }
    }

    public final String getMountPath() {
        return this.mountPath;
    }

    protected void appendParameters(AppendingStringBuffer url, Map parameters) {
        if (parameters != null && parameters.size() > 0) {
            Iterator entries = UnitTestSettings.getSortUrlParameters() ? new TreeMap(parameters).entrySet().iterator() : parameters.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                Object value = entry.getValue();
                if (value == null) continue;
                if (value instanceof String[]) {
                    String[] values = (String[])value;
                    for (int i = 0; i < values.length; ++i) {
                        this.appendValue(url, entry.getKey().toString(), values[i]);
                    }
                    continue;
                }
                this.appendValue(url, entry.getKey().toString(), value.toString());
            }
        }
    }

    private void appendValue(AppendingStringBuffer url, String key, String value) {
        String escapedValue = this.urlEncode(value);
        if (!Strings.isEmpty(escapedValue)) {
            if (!url.endsWith("/")) {
                url.append("/");
            }
            url.append(key).append("/").append(escapedValue).append("/");
        }
    }

    protected ValueMap decodeParameters(String urlFragment, Map urlParameters) {
        if (urlFragment.startsWith("/")) {
            urlFragment = urlFragment.substring(1);
        }
        if (urlFragment.length() > 0 && urlFragment.endsWith("/")) {
            urlFragment = urlFragment.substring(0, urlFragment.length() - 1);
        }
        if (urlFragment.length() == 0) {
            return new ValueMap(urlParameters != null ? urlParameters : Collections.EMPTY_MAP);
        }
        String[] pairs = urlFragment.split("/");
        if (pairs.length % 2 != 0) {
            throw new IllegalStateException("URL fragment has unmatched key/value pair: " + urlFragment);
        }
        ValueMap parameters = new ValueMap();
        for (int i = 0; i < pairs.length; i += 2) {
            String value = pairs[i + 1];
            value = this.urlDecode(value);
            parameters.add(pairs[i], value);
        }
        if (urlParameters != null) {
            parameters.putAll(urlParameters);
        }
        return parameters;
    }

    protected String urlDecode(String value) {
        try {
            value = URLDecoder.decode(value, Application.get().getRequestCycleSettings().getResponseRequestEncoding());
        }
        catch (UnsupportedEncodingException ex) {
            log.error("error decoding parameter", (Throwable)ex);
        }
        return value;
    }

    protected String urlEncode(String string) {
        try {
            return URLEncoder.encode(string, Application.get().getRequestCycleSettings().getResponseRequestEncoding());
        }
        catch (UnsupportedEncodingException e) {
            log.error(e.getMessage(), (Throwable)e);
            return string;
        }
    }

    public boolean matches(String path) {
        String remainder;
        return path.startsWith(this.mountPath) && ((remainder = path.substring(this.mountPath.length())).length() == 0 || remainder.startsWith("/"));
    }
}

