/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.target.basic;

import org.apache.wicket.IRequestTarget;
import org.apache.wicket.RequestContext;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.Response;
import org.apache.wicket.protocol.http.portlet.PortletRequestContext;

public class RedirectRequestTarget
implements IRequestTarget {
    private final String redirectUrl;

    public RedirectRequestTarget(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    public void detach(RequestCycle requestCycle) {
    }

    public void respond(RequestCycle requestCycle) {
        Response response = requestCycle.getResponse();
        response.reset();
        if (this.redirectUrl.startsWith("/")) {
            RequestContext rc = RequestContext.get();
            Object continueTo = null;
            if (rc.isPortletRequest() && ((PortletRequestContext)rc).isEmbedded()) {
                response.redirect(this.redirectUrl);
            } else {
                response.redirect(RequestCycle.get().getRequest().getRelativePathPrefixToContextRoot() + this.redirectUrl.substring(1));
            }
        } else if (this.redirectUrl.startsWith("http://") || this.redirectUrl.startsWith("https://")) {
            response.redirect(this.redirectUrl);
        } else {
            response.redirect(RequestCycle.get().getRequest().getRelativePathPrefixToWicketHandler() + this.redirectUrl);
        }
    }
}

