/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request;

import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.IRedirectListener;
import org.apache.wicket.IRequestTarget;
import org.apache.wicket.Page;
import org.apache.wicket.PageParameters;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.RequestListenerInterface;
import org.apache.wicket.RestartResponseAtInterceptPageException;
import org.apache.wicket.RestartResponseException;
import org.apache.wicket.Session;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.authorization.AuthorizationException;
import org.apache.wicket.authorization.UnauthorizedActionException;
import org.apache.wicket.markup.MarkupException;
import org.apache.wicket.markup.html.INewBrowserWindowListener;
import org.apache.wicket.markup.html.pages.ExceptionErrorPage;
import org.apache.wicket.protocol.http.PageExpiredException;
import org.apache.wicket.protocol.http.request.WebErrorCodeResponseTarget;
import org.apache.wicket.protocol.http.request.WebExternalResourceRequestTarget;
import org.apache.wicket.request.IRequestCodingStrategy;
import org.apache.wicket.request.IRequestCycleProcessor;
import org.apache.wicket.request.RequestParameters;
import org.apache.wicket.request.target.IEventProcessor;
import org.apache.wicket.request.target.component.BookmarkableListenerInterfaceRequestTarget;
import org.apache.wicket.request.target.component.BookmarkablePageRequestTarget;
import org.apache.wicket.request.target.component.PageRequestTarget;
import org.apache.wicket.request.target.component.listener.RedirectPageRequestTarget;
import org.apache.wicket.request.target.resource.SharedResourceRequestTarget;
import org.apache.wicket.settings.IExceptionSettings;
import org.apache.wicket.util.string.Strings;

public abstract class AbstractRequestCycleProcessor
implements IRequestCycleProcessor {
    private IRequestCodingStrategy requestCodingStrategy;

    public IRequestCodingStrategy getRequestCodingStrategy() {
        if (this.requestCodingStrategy == null) {
            this.requestCodingStrategy = this.newRequestCodingStrategy();
        }
        return this.requestCodingStrategy;
    }

    public void processEvents(RequestCycle requestCycle) {
        IRequestTarget target = requestCycle.getRequestTarget();
        if (target instanceof IEventProcessor) {
            Application.get().logEventTarget(target);
            ((IEventProcessor)((Object)target)).processEvents(requestCycle);
        }
    }

    public void respond(RequestCycle requestCycle) {
        IRequestTarget requestTarget = requestCycle.getRequestTarget();
        if (requestTarget != null) {
            Application.get().logResponseTarget(requestTarget);
            requestTarget.respond(requestCycle);
        }
    }

    public void respond(RuntimeException e, RequestCycle requestCycle) {
        Application application = Application.get();
        IExceptionSettings settings = application.getExceptionSettings();
        Page responsePage = requestCycle.getResponsePage();
        Page override = this.onRuntimeException(responsePage, e);
        if (override != null) {
            throw new RestartResponseException(override);
        }
        if (e instanceof AuthorizationException) {
            Class accessDeniedPageClass = application.getApplicationSettings().getAccessDeniedPage();
            throw new RestartResponseAtInterceptPageException(accessDeniedPageClass);
        }
        if (e instanceof PageExpiredException) {
            Class pageExpiredErrorPageClass = application.getApplicationSettings().getPageExpiredErrorPage();
            boolean mounted = this.isPageMounted(pageExpiredErrorPageClass);
            RequestCycle.get().setRedirect(mounted);
            throw new RestartResponseException(pageExpiredErrorPageClass);
        }
        if (settings.getUnexpectedExceptionDisplay() != IExceptionSettings.SHOW_NO_EXCEPTION_PAGE) {
            Class<?> responseClass;
            requestCycle.setRedirect(false);
            Class internalErrorPageClass = application.getApplicationSettings().getInternalErrorPage();
            Class<?> clazz = responseClass = responsePage != null ? responsePage.getClass() : null;
            if (responseClass != internalErrorPageClass && settings.getUnexpectedExceptionDisplay() == IExceptionSettings.SHOW_INTERNAL_ERROR_PAGE) {
                throw new RestartResponseException(internalErrorPageClass);
            }
            if (responseClass != ExceptionErrorPage.class) {
                throw new RestartResponseException(new ExceptionErrorPage(e, responsePage));
            }
            throw new WicketRuntimeException("Internal Error: Could not render error page " + internalErrorPageClass, e);
        }
    }

    private boolean isPageMounted(Class pageClass) {
        RequestCycle cycle = RequestCycle.get();
        CharSequence path = this.getRequestCodingStrategy().pathForTarget(new BookmarkablePageRequestTarget(pageClass));
        return path != null;
    }

    protected abstract IRequestCodingStrategy newRequestCodingStrategy();

    protected Page onRuntimeException(Page page, RuntimeException e) {
        return RequestCycle.get().onRuntimeException(page, e);
    }

    protected IRequestTarget resolveBookmarkablePage(RequestCycle requestCycle, RequestParameters requestParameters) {
        Class pageClass;
        String bookmarkablePageClass = requestParameters.getBookmarkablePageClass();
        Session session = requestCycle.getSession();
        try {
            pageClass = session.getClassResolver().resolveClass(bookmarkablePageClass);
        }
        catch (ClassNotFoundException e) {
            return new WebErrorCodeResponseTarget(404, "Unable to load Bookmarkable Page");
        }
        try {
            PageParameters params = new PageParameters(requestParameters.getParameters());
            if (requestParameters.getComponentPath() != null && requestParameters.getInterfaceName() != null) {
                String componentPath = requestParameters.getComponentPath();
                Page page = session.getPage(requestParameters.getPageMapName(), componentPath, requestParameters.getVersionNumber());
                if (page != null && page.getClass() == pageClass) {
                    return this.resolveListenerInterfaceTarget(requestCycle, page, componentPath, requestParameters.getInterfaceName(), requestParameters);
                }
                return new BookmarkableListenerInterfaceRequestTarget(requestParameters.getPageMapName(), pageClass, params, requestParameters.getComponentPath(), requestParameters.getInterfaceName(), requestParameters.getVersionNumber());
            }
            return new BookmarkablePageRequestTarget(requestParameters.getPageMapName(), pageClass, params);
        }
        catch (RuntimeException e) {
            throw new WicketRuntimeException("Unable to instantiate Page class: " + bookmarkablePageClass + ". See below for details.", e);
        }
    }

    protected IRequestTarget resolveExternalResource(RequestCycle requestCycle) {
        String url = requestCycle.getRequest().getURL();
        if (url.length() > 0 && url.charAt(0) != '/' || url.length() == 0) {
            url = '/' + url;
        }
        return new WebExternalResourceRequestTarget(url);
    }

    protected IRequestTarget resolveHomePageTarget(RequestCycle requestCycle, RequestParameters requestParameters) {
        Session session = requestCycle.getSession();
        Application application = session.getApplication();
        try {
            Class homePageClass = application.getHomePage();
            PageParameters parameters = new PageParameters(requestParameters.getParameters());
            BookmarkablePageRequestTarget homepageTarget = new BookmarkablePageRequestTarget(homePageClass, parameters);
            IRequestCodingStrategy requestCodingStrategy = requestCycle.getProcessor().getRequestCodingStrategy();
            CharSequence path = requestCodingStrategy.pathForTarget(homepageTarget);
            if (path != null) {
                requestCycle.setRedirect(true);
            }
            return homepageTarget;
        }
        catch (MarkupException e) {
            throw e;
        }
        catch (WicketRuntimeException e) {
            throw new WicketRuntimeException("Could not create home page", e);
        }
    }

    protected IRequestTarget resolveListenerInterfaceTarget(RequestCycle requestCycle, Page page, String componentPath, String interfaceName, RequestParameters requestParameters) {
        if (page == null) {
            throw new IllegalArgumentException("page must not be null");
        }
        if (interfaceName == null) {
            throw new IllegalArgumentException("interfaceName must not be null");
        }
        if (interfaceName.equals(IRedirectListener.INTERFACE.getName())) {
            return new RedirectPageRequestTarget(page);
        }
        if (interfaceName.equals(INewBrowserWindowListener.INTERFACE.getName())) {
            return INewBrowserWindowListener.INTERFACE.newRequestTarget(page, page, INewBrowserWindowListener.INTERFACE, requestParameters);
        }
        RequestListenerInterface listener = RequestListenerInterface.forName(interfaceName);
        if (listener == null) {
            throw new WicketRuntimeException("Attempt to access unknown request listener interface " + interfaceName);
        }
        String pageRelativeComponentPath = Strings.afterFirstPathComponent(componentPath, ':');
        Component component = Strings.isEmpty(pageRelativeComponentPath) ? page : page.get(pageRelativeComponentPath);
        if (component == null) {
            throw new WicketRuntimeException("component " + pageRelativeComponentPath + " not found on page " + page.getClass().getName() + "[id = " + page.getNumericId() + "], listener interface = " + listener);
        }
        if (!component.isEnableAllowed()) {
            throw new UnauthorizedActionException(component, Component.ENABLE);
        }
        return listener.newRequestTarget(page, component, listener, requestParameters);
    }

    protected IRequestTarget resolveRenderedPage(RequestCycle requestCycle, RequestParameters requestParameters) {
        String componentPath = requestParameters.getComponentPath();
        Session session = requestCycle.getSession();
        Page page = session.getPage(requestParameters.getPageMapName(), componentPath, requestParameters.getVersionNumber());
        if (page != null) {
            requestCycle.getRequest().setPage(page);
            String interfaceName = requestParameters.getInterfaceName();
            if (interfaceName != null) {
                return this.resolveListenerInterfaceTarget(requestCycle, page, componentPath, interfaceName, requestParameters);
            }
            return new PageRequestTarget(page);
        }
        return null;
    }

    protected IRequestTarget resolveSharedResource(RequestCycle requestCycle, RequestParameters requestParameters) {
        return new SharedResourceRequestTarget(requestParameters);
    }
}

