/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http.pagestore;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Application;
import org.apache.wicket.Page;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.protocol.http.SecondLevelCacheSessionStore;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.pagestore.AbstractPageStore;
import org.apache.wicket.protocol.http.pagestore.FileChannelPool;
import org.apache.wicket.protocol.http.pagestore.PageWindowManager;
import org.apache.wicket.util.concurrent.ConcurrentHashMap;
import org.apache.wicket.util.lang.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskPageStore
extends AbstractPageStore
implements SecondLevelCacheSessionStore.ISerializationAwarePageStore {
    private final int maxSizePerPageMap;
    private final int maxSizePerSession;
    private final FileChannelPool fileChannelPool;
    private final File fileStoreFolder;
    private final String appName;
    private final Map sessionIdToEntryMap = new ConcurrentHashMap();
    private final Map pagesToSaveAll = new ConcurrentHashMap();
    private final Map pagesToSaveActive = new ConcurrentHashMap();
    private PageSavingThread pageSavingThread = null;
    private int lastRecentlySerializedPagesCacheSize = 50;
    private final List lastRecentlySerializedPagesCache = new ArrayList(this.lastRecentlySerializedPagesCacheSize);
    private static final Logger log = LoggerFactory.getLogger((Class)DiskPageStore.class);

    private File getSessionFolder(String sessionId, boolean create) {
        File storeFolder = new File(this.fileStoreFolder, this.appName + "-filestore");
        File sessionFolder = new File(storeFolder, sessionId);
        if (create && !sessionFolder.exists()) {
            this.mkdirs(sessionFolder);
        }
        return sessionFolder;
    }

    private void mkdirs(File file) {
        for (int j = 0; j < 5; ++j) {
            for (int i = 0; i < 10; ++i) {
                if (!file.mkdirs()) continue;
                return;
            }
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        log.error("Failed to make directory " + file);
    }

    private String getPageMapFileName(String sessionId, String pageMapName, boolean createSessionFolder) {
        File sessionFolder = this.getSessionFolder(sessionId, createSessionFolder);
        return new File(sessionFolder, "pm-" + pageMapName).getAbsolutePath();
    }

    protected int getMaxSizePerPageMap() {
        return this.maxSizePerPageMap;
    }

    protected int getMaxSizePerSession() {
        return this.maxSizePerSession;
    }

    protected File getFileStoreFolder() {
        return this.fileStoreFolder;
    }

    public DiskPageStore(File fileStoreFolder, int maxSizePerPagemap, int maxSizePerSession, int fileChannelPoolCapacity) {
        this.maxSizePerPageMap = maxSizePerPagemap;
        this.maxSizePerSession = maxSizePerSession;
        this.fileChannelPool = new FileChannelPool(fileChannelPoolCapacity);
        this.fileStoreFolder = fileStoreFolder;
        if (maxSizePerSession < this.maxSizePerPageMap) {
            throw new IllegalArgumentException("Provided maximum session size must be bigger than maximum pagemap size");
        }
        this.fileStoreFolder.mkdirs();
        this.appName = Application.get().getApplicationKey();
        this.initPageSavingThread();
    }

    private static File getDefaultFileStoreFolder() {
        File dir = (File)((WebApplication)Application.get()).getServletContext().getAttribute("javax.servlet.context.tempdir");
        if (dir != null) {
            return dir;
        }
        try {
            return File.createTempFile("file-prefix", null).getParentFile();
        }
        catch (IOException e) {
            throw new WicketRuntimeException(e);
        }
    }

    public DiskPageStore(int maxSizePerPagemap, int maxSizePerSession, int fileChannelPoolCapacity) {
        this(DiskPageStore.getDefaultFileStoreFolder(), maxSizePerPagemap, maxSizePerSession, fileChannelPoolCapacity);
    }

    public DiskPageStore() {
        this((int)Bytes.megabytes(10L).bytes(), (int)Bytes.megabytes(100L).bytes(), 50);
    }

    public void destroy() {
        this.fileChannelPool.destroy();
        if (this.pageSavingThread != null) {
            this.pageSavingThread.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SessionEntry getSessionEntry(String sessionId, boolean createIfDoesNotExist) {
        SessionEntry entry = (SessionEntry)this.sessionIdToEntryMap.get(sessionId);
        if (entry == null && createIfDoesNotExist) {
            Map map = this.sessionIdToEntryMap;
            synchronized (map) {
                entry = (SessionEntry)this.sessionIdToEntryMap.get(sessionId);
                if (entry == null) {
                    entry = new SessionEntry();
                    entry.sessionId = sessionId;
                    this.sessionIdToEntryMap.put(sessionId, entry);
                }
            }
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Page getPage(String sessionId, String pagemap, int id, int versionNumber, int ajaxVersionNumber) {
        SessionEntry entry = this.getSessionEntry(sessionId, false);
        if (entry != null) {
            byte[] data;
            if (this.isSynchronous()) {
                data = entry.loadPage(pagemap, id, versionNumber, ajaxVersionNumber);
            } else {
                List pages;
                List list = pages = this.getPagesToSaveList(sessionId);
                synchronized (list) {
                    this.flushPagesToSaveList(sessionId, pages);
                    data = entry.loadPage(pagemap, id, versionNumber, ajaxVersionNumber);
                }
            }
            if (data != null) {
                return this.deserializePage(data, versionNumber);
            }
        }
        return null;
    }

    public void pageAccessed(String sessionId, Page page) {
    }

    private void removePage(SessionEntry entry, String pageMap, int id) {
        if (id != -1) {
            entry.removePage(pageMap, id);
        } else {
            entry.removePageMap(pageMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePage(String sessionId, String pageMap, int id) {
        SessionEntry entry = this.getSessionEntry(sessionId, false);
        if (entry != null) {
            if (this.isSynchronous()) {
                this.removePage(entry, pageMap, id);
            } else {
                List pages;
                List list = pages = this.getPagesToSaveList(sessionId);
                synchronized (list) {
                    this.flushPagesToSaveList(sessionId, pages);
                    this.removePage(entry, pageMap, id);
                }
            }
        }
    }

    protected void storeSerializedPages(String sessionId, List pages) {
        SessionEntry entry = this.getSessionEntry(sessionId, true);
        if (this.isSynchronous()) {
            Iterator i = pages.iterator();
            while (i.hasNext()) {
                AbstractPageStore.SerializedPage serializedPage = (AbstractPageStore.SerializedPage)i.next();
                entry.savePage(serializedPage);
            }
        } else {
            this.schedulePagesSave(sessionId, pages);
        }
    }

    protected void onPagesSerialized(String sessionId, List pages) {
    }

    public void storePage(String sessionId, Page page) {
        List pages = this.serializePage(page);
        this.cacheSerializedPage(sessionId, page, pages);
        this.onPagesSerialized(sessionId, pages);
        this.storeSerializedPages(sessionId, pages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(String sessionId) {
        SessionEntry entry = (SessionEntry)this.sessionIdToEntryMap.get(sessionId);
        if (entry != null) {
            if (this.isSynchronous()) {
                entry.unbind();
            } else {
                List pages;
                List list = pages = this.getPagesToSaveList(sessionId);
                synchronized (list) {
                    this.flushPagesToSaveList(sessionId, pages);
                    entry.unbind();
                }
                this.pagesToSaveAll.remove(sessionId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getPagesToSaveList(String sessionId) {
        ArrayList list = (ArrayList)this.pagesToSaveAll.get(sessionId);
        if (list == null) {
            Map map = this.pagesToSaveAll;
            synchronized (map) {
                list = (List)this.pagesToSaveAll.get(sessionId);
                if (list == null) {
                    list = new ArrayList();
                    this.pagesToSaveAll.put(sessionId, list);
                }
            }
        }
        return list;
    }

    protected void flushPagesToSaveList(String sessionId, List list) {
        if (list != null) {
            Iterator i = list.iterator();
            while (i.hasNext()) {
                AbstractPageStore.SerializedPage page = (AbstractPageStore.SerializedPage)i.next();
                this.getSessionEntry(sessionId, true).savePage(page);
            }
            list.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void schedulePagesSave(String sessionId, List pages) {
        List list;
        List list2 = list = this.getPagesToSaveList(sessionId);
        synchronized (list2) {
            list.addAll(pages);
            if (list.size() > 0 && !this.pagesToSaveActive.containsKey(sessionId)) {
                this.pagesToSaveActive.put(sessionId, list);
            }
        }
    }

    private void initPageSavingThread() {
        if (!this.isSynchronous()) {
            this.pageSavingThread = new PageSavingThread();
            Thread t = new Thread((Runnable)this.pageSavingThread, "PageSavingThread-" + this.appName);
            t.setDaemon(true);
            t.setPriority(10);
            t.start();
        }
    }

    protected int getSavingThreadSleepTime() {
        return 100;
    }

    protected boolean isSynchronous() {
        return false;
    }

    public void setLastRecentlySerializedPagesCacheSize(int lastRecentlySerializedPagesCacheSize) {
        this.lastRecentlySerializedPagesCacheSize = lastRecentlySerializedPagesCacheSize;
    }

    public int getLastRecentlySerializedPagesCacheSize() {
        return this.lastRecentlySerializedPagesCacheSize;
    }

    private SerializedPageWithSession removePageFromLastRecentlySerializedPagesCache(Page page) {
        Iterator i = this.lastRecentlySerializedPagesCache.iterator();
        while (i.hasNext()) {
            SerializedPageWithSession entry = (SerializedPageWithSession)i.next();
            if (entry == null || entry.page.get() != page) continue;
            i.remove();
            return entry;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheSerializedPage(String sessionId, Page page, List pagesList) {
        if (this.getLastRecentlySerializedPagesCacheSize() > 0) {
            SerializedPageWithSession entry = new SerializedPageWithSession(sessionId, page, pagesList);
            List list = this.lastRecentlySerializedPagesCache;
            synchronized (list) {
                this.removePageFromLastRecentlySerializedPagesCache(page);
                this.lastRecentlySerializedPagesCache.add(entry);
                if (this.lastRecentlySerializedPagesCache.size() > this.getLastRecentlySerializedPagesCacheSize()) {
                    this.lastRecentlySerializedPagesCache.remove(0);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable prepareForSerialization(Page page) {
        Serializable result = page;
        if (this.getLastRecentlySerializedPagesCacheSize() > 0) {
            SerializedPageWithSession entry;
            List list = this.lastRecentlySerializedPagesCache;
            synchronized (list) {
                entry = this.removePageFromLastRecentlySerializedPagesCache(page);
            }
            if (entry != null) {
                result = entry;
            }
        }
        return result;
    }

    public Page restoreAfterSerialization(Serializable serializable) {
        if (serializable instanceof Page) {
            return (Page)serializable;
        }
        if (serializable instanceof SerializedPageWithSession) {
            SerializedPageWithSession page = (SerializedPageWithSession)serializable;
            this.storeSerializedPages(page.sessionId, page.pages);
            return this.getPage(page.sessionId, page.pageMapName, page.pageId, page.versionNumber, page.ajaxVersionNumber);
        }
        throw new IllegalArgumentException("Unknown object type");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsPage(String sessionId, String pageMapName, int pageId, int pageVersion) {
        SessionEntry entry = this.getSessionEntry(sessionId, false);
        if (entry != null) {
            List pages;
            if (this.isSynchronous()) {
                return entry.exists(pageMapName, pageId, pageVersion);
            }
            List list = pages = this.getPagesToSaveList(sessionId);
            synchronized (list) {
                this.flushPagesToSaveList(sessionId, pages);
                return entry.exists(pageMapName, pageId, pageVersion);
            }
        }
        return false;
    }

    private static class SerializedPageWithSession
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final transient WeakReference page;
        private final List pages;
        private final String sessionId;
        private final int pageId;
        private final String pageMapName;
        private final int versionNumber;
        private final int ajaxVersionNumber;

        private SerializedPageWithSession(String sessionId, Page page, List pages) {
            this.sessionId = sessionId;
            this.pageId = page.getNumericId();
            this.pageMapName = page.getPageMapName();
            this.versionNumber = page.getCurrentVersionNumber();
            this.ajaxVersionNumber = page.getAjaxVersionNumber();
            this.pages = new ArrayList(pages);
            this.page = new WeakReference<Page>(page);
        }

        public String toString() {
            return this.getClass().getName() + " [ pageId:" + this.pageId + ", pageMapName: " + this.pageMapName + ", session: " + this.sessionId + "]";
        }
    }

    private class PageSavingThread
    implements Runnable {
        private volatile boolean stop = false;

        private PageSavingThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.stop) {
                while (DiskPageStore.this.pagesToSaveActive.isEmpty()) {
                    try {
                        Thread.sleep(DiskPageStore.this.getSavingThreadSleepTime());
                    }
                    catch (InterruptedException ignore) {}
                }
                Iterator i = DiskPageStore.this.pagesToSaveActive.entrySet().iterator();
                while (i.hasNext()) {
                    List pages;
                    Map.Entry entry = i.next();
                    String sessionId = (String)entry.getKey();
                    List list = pages = (List)entry.getValue();
                    synchronized (list) {
                        try {
                            DiskPageStore.this.flushPagesToSaveList(sessionId, pages);
                        }
                        catch (Exception e) {
                            log.error("Error flushing serialized pages from worker thread for session " + sessionId, (Throwable)e);
                        }
                        i.remove();
                    }
                }
            }
        }

        public void stop() {
            this.stop = true;
        }
    }

    protected class SessionEntry {
        private String sessionId;
        private final List pageMapEntryList = new ArrayList();

        protected SessionEntry() {
        }

        public String getSessionId() {
            return this.sessionId;
        }

        public int getTotalSize() {
            int result = 0;
            Iterator i = this.pageMapEntryList.iterator();
            while (i.hasNext()) {
                PageMapEntry entry = (PageMapEntry)i.next();
                if (entry.manager == null) continue;
                result += entry.manager.getTotalSize();
            }
            return result;
        }

        public List getPageMapEntryList() {
            return Collections.unmodifiableList(this.pageMapEntryList);
        }

        public PageMapEntry getPageMapEntry(String pageMapName, boolean create) {
            PageMapEntry result = null;
            Iterator i = this.pageMapEntryList.iterator();
            while (i.hasNext()) {
                PageMapEntry entry = (PageMapEntry)i.next();
                if (entry.pageMapName != pageMapName && (entry.pageMapName == null || !entry.pageMapName.equals(pageMapName))) continue;
                result = entry;
            }
            if (result == null && create) {
                result = new PageMapEntry();
                result.pageMapName = pageMapName;
                result.fileName = DiskPageStore.this.getPageMapFileName(this.sessionId, pageMapName, true);
                result.manager = new PageWindowManager(DiskPageStore.this.getMaxSizePerPageMap());
                this.pageMapEntryList.add(result);
            }
            return result;
        }

        private void removePageMapEntry(PageMapEntry entry) {
            DiskPageStore.this.fileChannelPool.closeAndDeleteFileChannel(entry.fileName);
            this.pageMapEntryList.remove(entry);
        }

        public synchronized void removePageMap(String pageMapName) {
            PageMapEntry entry = this.getPageMapEntry(pageMapName, false);
            if (entry != null) {
                this.removePageMapEntry(entry);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void savePage(AbstractPageStore.SerializedPage page) {
            if (page.getData() != null) {
                PageMapEntry entry = this.getPageMapEntry(page.getPageMapName(), true);
                PageWindowManager.PageWindow window = entry.manager.createPageWindow(page.getPageId(), page.getVersionNumber(), page.getAjaxVersionNumber(), page.getData().length);
                this.pageMapEntryList.remove(entry);
                this.pageMapEntryList.add(entry);
                while (this.getTotalSize() > DiskPageStore.this.getMaxSizePerSession() && this.pageMapEntryList.size() > 1) {
                    this.removePageMapEntry((PageMapEntry)this.pageMapEntryList.get(0));
                }
                FileChannel channel = DiskPageStore.this.fileChannelPool.getFileChannel(entry.fileName, true);
                try {
                    channel.write(ByteBuffer.wrap(page.getData()), window.getFilePartOffset());
                }
                catch (IOException e) {
                    log.error("Error writing to a channel " + channel, (Throwable)e);
                }
                finally {
                    DiskPageStore.this.fileChannelPool.returnFileChannel(channel);
                }
            }
        }

        public synchronized void removePage(String pageMapName, int pageId) {
            PageMapEntry entry = this.getPageMapEntry(pageMapName, false);
            if (entry != null) {
                entry.manager.removePage(pageId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] loadPage(PageWindowManager.PageWindow window, String pageMapFileName) {
            byte[] result = null;
            FileChannel channel = DiskPageStore.this.fileChannelPool.getFileChannel(pageMapFileName, false);
            if (channel != null) {
                ByteBuffer buffer = ByteBuffer.allocate(window.getFilePartSize());
                try {
                    channel.read(buffer, window.getFilePartOffset());
                    if (buffer.hasArray()) {
                        result = buffer.array();
                    }
                }
                catch (IOException e) {
                    log.error("Error reading from file channel " + channel, (Throwable)e);
                }
                finally {
                    DiskPageStore.this.fileChannelPool.returnFileChannel(channel);
                }
            }
            return result;
        }

        public synchronized byte[] loadPage(String pageMapName, int id, int versionNumber, int ajaxVersionNumber) {
            PageWindowManager.PageWindow window;
            byte[] result = null;
            PageMapEntry entry = this.getPageMapEntry(pageMapName, false);
            if (entry != null && (window = entry.manager.getPageWindow(id, versionNumber, ajaxVersionNumber)) != null) {
                result = this.loadPage(window, entry.fileName);
            }
            return result;
        }

        public synchronized void unbind() {
            while (this.pageMapEntryList.size() > 0) {
                this.removePageMapEntry((PageMapEntry)this.pageMapEntryList.get(this.pageMapEntryList.size() - 1));
            }
            File sessionFolder = DiskPageStore.this.getSessionFolder(this.sessionId, false);
            if (sessionFolder.exists()) {
                sessionFolder.delete();
            }
        }

        public synchronized boolean exists(String pageMapName, int pageId, int versionNumber) {
            PageMapEntry entry = this.getPageMapEntry(pageMapName, false);
            return entry != null && entry.getManager().getPageWindow(pageId, versionNumber, -1) != null;
        }
    }

    protected static class PageMapEntry {
        private String pageMapName;
        private String fileName;
        private PageWindowManager manager;

        protected PageMapEntry() {
        }

        public String getPageMapName() {
            return this.pageMapName;
        }

        public String getFileName() {
            return this.fileName;
        }

        public PageWindowManager getManager() {
            return this.manager;
        }
    }
}

