/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http;

import org.apache.wicket.AccessStackPageMap;
import org.apache.wicket.Application;
import org.apache.wicket.IPageMap;
import org.apache.wicket.IRequestTarget;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.Session;
import org.apache.wicket.protocol.http.IgnoreAjaxRequestException;
import org.apache.wicket.protocol.http.PageExpiredException;
import org.apache.wicket.protocol.http.request.WebRequestCodingStrategy;
import org.apache.wicket.protocol.http.servlet.AbortWithWebErrorCodeException;
import org.apache.wicket.request.AbstractRequestCycleProcessor;
import org.apache.wicket.request.IRequestCodingStrategy;
import org.apache.wicket.request.RequestParameters;
import org.apache.wicket.request.target.basic.EmptyAjaxRequestTarget;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebRequestCycleProcessor
extends AbstractRequestCycleProcessor {
    private static final Logger log = LoggerFactory.getLogger((Class)WebRequestCycleProcessor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IRequestTarget resolve(RequestCycle requestCycle, RequestParameters requestParameters) {
        IRequestCodingStrategy requestCodingStrategy = requestCycle.getProcessor().getRequestCodingStrategy();
        String path = requestParameters.getPath();
        IRequestTarget target = null;
        if (requestParameters.getBookmarkablePageClass() != null) {
            target = this.resolveBookmarkablePage(requestCycle, requestParameters);
        } else if (requestParameters.getComponentPath() != null) {
            boolean processRequest = true;
            Session session = requestCycle.getSession();
            synchronized (session) {
                if (requestParameters.isOnlyProcessIfPathActive()) {
                    AccessStackPageMap accessStackPageMap;
                    Session session2 = Session.get();
                    IPageMap pageMap = session2.pageMapForName(requestParameters.getPageMapName(), false);
                    if (pageMap == null) {
                        processRequest = false;
                    } else if (pageMap instanceof AccessStackPageMap && (accessStackPageMap = (AccessStackPageMap)pageMap).getAccessStack().size() > 0) {
                        AccessStackPageMap.Access access = (AccessStackPageMap.Access)accessStackPageMap.getAccessStack().peek();
                        int pageId = Integer.parseInt(Strings.firstPathComponent(requestParameters.getComponentPath(), ':'));
                        if (pageId != access.getId()) {
                            processRequest = false;
                        } else {
                            int version = requestParameters.getVersionNumber();
                            if (version != -1 && version != access.getVersion()) {
                                processRequest = false;
                            }
                        }
                    }
                }
            }
            if (!processRequest) throw new PageExpiredException("Request cannot be processed");
            try {
                target = this.resolveRenderedPage(requestCycle, requestParameters);
            }
            catch (IgnoreAjaxRequestException e) {
                target = EmptyAjaxRequestTarget.getInstance();
            }
        } else if (requestParameters.getResourceKey() != null) {
            target = this.resolveSharedResource(requestCycle, requestParameters);
        } else if (Strings.isEmpty(path) || "/".equals(path)) {
            target = this.resolveHomePageTarget(requestCycle, requestParameters);
        }
        if (target == null) {
            target = requestCodingStrategy.targetForRequest(requestParameters);
            if (target == null && requestParameters.getComponentPath() != null) {
                throw new PageExpiredException("Cannot find the rendered page in session [pagemap=" + requestParameters.getPageMapName() + ",componentPath=" + requestParameters.getComponentPath() + ",versionNumber=" + requestParameters.getVersionNumber() + "]");
            }
        } else if (Application.get().getSecuritySettings().getEnforceMounts() && requestCodingStrategy.pathForTarget(target) != null) {
            String msg = "Direct access not allowed for mounted targets";
            log.error(msg + " [request=" + requestCycle.getRequest() + ",target=" + target + ",session=" + Session.get() + "]");
            throw new AbortWithWebErrorCodeException(403, msg);
        }
        if (target != null) return target;
        return this.resolveExternalResource(requestCycle);
    }

    protected IRequestCodingStrategy newRequestCodingStrategy() {
        return new WebRequestCodingStrategy();
    }
}

