/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.wicket.Application;
import org.apache.wicket.IRequestTarget;
import org.apache.wicket.Page;
import org.apache.wicket.Request;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.Response;
import org.apache.wicket.Session;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.pages.AccessDeniedPage;
import org.apache.wicket.markup.html.pages.InternalErrorPage;
import org.apache.wicket.markup.html.pages.PageExpiredErrorPage;
import org.apache.wicket.markup.resolver.AutoLinkResolver;
import org.apache.wicket.protocol.http.BufferedHttpServletResponse;
import org.apache.wicket.protocol.http.BufferedWebResponse;
import org.apache.wicket.protocol.http.IRequestLogger;
import org.apache.wicket.protocol.http.SecondLevelCacheSessionStore;
import org.apache.wicket.protocol.http.WebRequest;
import org.apache.wicket.protocol.http.WebRequestCycle;
import org.apache.wicket.protocol.http.WebRequestCycleProcessor;
import org.apache.wicket.protocol.http.WebResponse;
import org.apache.wicket.protocol.http.WebSession;
import org.apache.wicket.protocol.http.WicketFilter;
import org.apache.wicket.protocol.http.pagestore.DiskPageStore;
import org.apache.wicket.protocol.http.servlet.ServletWebRequest;
import org.apache.wicket.request.IRequestCycleProcessor;
import org.apache.wicket.request.target.coding.BookmarkablePageRequestTargetUrlCodingStrategy;
import org.apache.wicket.request.target.coding.IRequestTargetUrlCodingStrategy;
import org.apache.wicket.request.target.coding.PackageRequestTargetUrlCodingStrategy;
import org.apache.wicket.request.target.coding.SharedResourceRequestTargetUrlCodingStrategy;
import org.apache.wicket.session.ISessionStore;
import org.apache.wicket.util.collections.MostRecentlyUsedMap;
import org.apache.wicket.util.file.FileCleaner;
import org.apache.wicket.util.file.IResourceFinder;
import org.apache.wicket.util.file.WebApplicationPath;
import org.apache.wicket.util.lang.PackageName;
import org.apache.wicket.util.watch.ModificationWatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WebApplication
extends Application {
    private static final Logger log = LoggerFactory.getLogger((Class)WebApplication.class);
    private String applicationKey;
    private final Map bufferedResponses = new HashMap();
    private IRequestCycleProcessor requestCycleProcessor;
    private String sessionAttributePrefix;
    private WicketFilter wicketFilter;

    public final String getApplicationKey() {
        if (this.applicationKey == null) {
            throw new IllegalStateException("the application key does not seem to be set properly or this method is called before WicketServlet is set, which leads to the wrong behavior");
        }
        return this.applicationKey;
    }

    public final String getInitParameter(String key) {
        if (this.wicketFilter != null) {
            return this.wicketFilter.getFilterConfig().getInitParameter(key);
        }
        throw new IllegalStateException("servletContext is not set yet. Any code in your Application object that uses the wicketServlet/Filter instance should be put in the init() method instead of your constructor");
    }

    public final IRequestCycleProcessor getRequestCycleProcessor() {
        if (this.requestCycleProcessor == null) {
            this.requestCycleProcessor = this.newRequestCycleProcessor();
        }
        return this.requestCycleProcessor;
    }

    public final ServletContext getServletContext() {
        if (this.wicketFilter != null) {
            return this.wicketFilter.getFilterConfig().getServletContext();
        }
        throw new IllegalStateException("servletContext is not set yet. Any code in your Application object that uses the wicket filter instance should be put in the init() method instead of your constructor");
    }

    public String getSessionAttributePrefix(WebRequest request) {
        if (this.sessionAttributePrefix == null) {
            this.sessionAttributePrefix = "wicket:" + this.getWicketFilter().getFilterConfig().getFilterName() + ":";
        }
        return this.sessionAttributePrefix;
    }

    public final WicketFilter getWicketFilter() {
        return this.wicketFilter;
    }

    public void logEventTarget(IRequestTarget target) {
        super.logEventTarget(target);
        IRequestLogger rl = this.getRequestLogger();
        if (rl != null) {
            rl.logEventTarget(target);
        }
    }

    public void logResponseTarget(IRequestTarget target) {
        super.logResponseTarget(target);
        IRequestLogger rl = this.getRequestLogger();
        if (rl != null) {
            rl.logResponseTarget(target);
        }
    }

    public final void mount(IRequestTargetUrlCodingStrategy encoder) {
        if (encoder == null) {
            throw new IllegalArgumentException("Encoder must be not null");
        }
        this.getRequestCycleProcessor().getRequestCodingStrategy().mount(encoder);
    }

    public final void mount(String path, PackageName packageName) {
        if (packageName == null) {
            throw new IllegalArgumentException("PackageName cannot be null");
        }
        this.mount(new PackageRequestTargetUrlCodingStrategy(path, packageName));
    }

    public final void mountBookmarkablePage(String path, Class bookmarkablePageClass) {
        this.mount(new BookmarkablePageRequestTargetUrlCodingStrategy(path, bookmarkablePageClass, null));
    }

    public final void mountBookmarkablePage(String path, String pageMapName, Class bookmarkablePageClass) {
        this.mount(new BookmarkablePageRequestTargetUrlCodingStrategy(path, bookmarkablePageClass, pageMapName));
    }

    public final void mountSharedResource(String path, String resourceKey) {
        this.mount(new SharedResourceRequestTargetUrlCodingStrategy(path, resourceKey));
    }

    public RequestCycle newRequestCycle(Request request, Response response) {
        return new WebRequestCycle(this, (WebRequest)request, (Response)((WebResponse)response));
    }

    public final Session newSession() {
        throw new UnsupportedOperationException("this method is replaced by Application#newSession");
    }

    public final Session newSession(Request request) {
        throw new UnsupportedOperationException("this method is replaced by Application#newSession");
    }

    public Session newSession(Request request, Response response) {
        return new WebSession(request);
    }

    public void sessionDestroyed(String sessionId) {
        this.bufferedResponses.remove(sessionId);
        IRequestLogger logger = this.getRequestLogger();
        if (logger != null) {
            logger.sessionDestroyed(sessionId);
        }
    }

    public final void setWicketFilter(WicketFilter wicketFilter) {
        this.wicketFilter = wicketFilter;
        this.applicationKey = wicketFilter.getFilterConfig().getFilterName();
    }

    public final void unmount(String path) {
        this.getRequestCycleProcessor().getRequestCodingStrategy().unmount(path);
    }

    protected final Object getDefaultRequestCycleFactory() {
        throw new UnsupportedOperationException("obsolete method. see getRequestCycleFactory");
    }

    protected void init() {
    }

    protected void internalDestroy() {
        ModificationWatcher resourceWatcher = this.getResourceSettings().getResourceWatcher(false);
        if (resourceWatcher != null) {
            resourceWatcher.destroy();
        }
        super.internalDestroy();
        this.bufferedResponses.clear();
        this.getSessionStore().destroy();
        FileCleaner.destroy();
    }

    protected void internalInit() {
        super.internalInit();
        this.getApplicationSettings().setPageExpiredErrorPage(PageExpiredErrorPage.class);
        this.getApplicationSettings().setInternalErrorPage(InternalErrorPage.class);
        this.getApplicationSettings().setAccessDeniedPage(AccessDeniedPage.class);
        this.getPageSettings().addComponentResolver(new AutoLinkResolver());
        this.getResourceSettings().setResourceFinder(this.getResourceFinder());
        String resourceFolder = this.getInitParameter("sourceFolder");
        if (resourceFolder != null) {
            this.getResourceSettings().addResourceFolder(resourceFolder);
        }
        this.configure();
    }

    public String getConfigurationType() {
        String result = null;
        try {
            result = System.getProperty("wicket.configuration");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (result == null) {
            result = this.getInitParameter("configuration");
        }
        if (result == null) {
            result = this.getServletContext().getInitParameter("configuration");
        }
        if (result != null) {
            return result;
        }
        return "development";
    }

    protected IResourceFinder getResourceFinder() {
        return new WebApplicationPath(this.getServletContext());
    }

    protected IRequestCycleProcessor newRequestCycleProcessor() {
        return new WebRequestCycleProcessor();
    }

    protected ISessionStore newSessionStore() {
        return new SecondLevelCacheSessionStore(this, new DiskPageStore());
    }

    protected WebRequest newWebRequest(HttpServletRequest servletRequest) {
        return new ServletWebRequest(servletRequest);
    }

    protected WebResponse newWebResponse(HttpServletResponse servletResponse) {
        return this.getRequestCycleSettings().getBufferResponse() ? new BufferedWebResponse(servletResponse) : new WebResponse(servletResponse);
    }

    public AjaxRequestTarget newAjaxRequestTarget(Page page) {
        return new AjaxRequestTarget(page);
    }

    protected final void setApplicationKey(String applicationKey) {
        this.applicationKey = applicationKey;
    }

    final void addBufferedResponse(String sessionId, String bufferId, BufferedHttpServletResponse renderedResponse) {
        Map responsesPerSession = (Map)this.bufferedResponses.get(sessionId);
        if (responsesPerSession == null) {
            responsesPerSession = new MostRecentlyUsedMap(4);
            this.bufferedResponses.put(sessionId, responsesPerSession);
        }
        responsesPerSession.put(bufferId, renderedResponse);
    }

    final void logStarted() {
        String version = this.getFrameworkSettings().getVersion();
        StringBuffer b = new StringBuffer();
        b.append("[").append(this.getName()).append("] Started Wicket ");
        if (!"n/a".equals(version)) {
            b.append("version ").append(version).append(" ");
        }
        b.append("in ").append(this.getConfigurationType()).append(" mode");
        log.info(b.toString());
        if ("development".equalsIgnoreCase(this.getConfigurationType())) {
            this.outputDevelopmentModeWarning();
        }
    }

    protected void outputDevelopmentModeWarning() {
        System.err.print("********************************************************************\n*** WARNING: Wicket is running in DEVELOPMENT mode.              ***\n***                               ^^^^^^^^^^^                    ***\n*** Do NOT deploy to your live server(s) without changing this.  ***\n*** See Application#getConfigurationType() for more information. ***\n********************************************************************\n");
    }

    final BufferedHttpServletResponse popBufferedResponse(String sessionId, String bufferId) {
        Map responsesPerSession = (Map)this.bufferedResponses.get(sessionId);
        if (responsesPerSession != null) {
            BufferedHttpServletResponse buffered = (BufferedHttpServletResponse)responsesPerSession.remove(bufferId);
            if (responsesPerSession.size() == 0) {
                this.bufferedResponses.remove(sessionId);
            }
            return buffered;
        }
        return null;
    }
}

