/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.IPageMap;
import org.apache.wicket.Page;
import org.apache.wicket.PageMap;
import org.apache.wicket.Request;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.Session;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.protocol.http.HttpSessionStore;
import org.apache.wicket.protocol.http.WebRequest;
import org.apache.wicket.session.pagemap.IPageMapEntry;
import org.apache.wicket.util.collections.IntHashMap;
import org.apache.wicket.version.IPageVersionManager;
import org.apache.wicket.version.undo.Change;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecondLevelCacheSessionStore
extends HttpSessionStore {
    private static Logger log = LoggerFactory.getLogger((Class)SecondLevelCacheSessionStore.class);
    static final ThreadLocal usedPages = new ThreadLocal();
    private final IPageStore pageStore;

    protected boolean isPageStoreClustered() {
        return this.pageStore instanceof IClusteredPageStore;
    }

    public static ThreadLocal getUsedPages() {
        return usedPages;
    }

    public SecondLevelCacheSessionStore(Application application, IPageStore pageStore) {
        super(application);
        this.pageStore = pageStore;
        Application.get().getPageSettings().setAutomaticMultiWindowSupport(false);
    }

    public IPageMap createPageMap(String name) {
        return new SecondLevelCachePageMap(this, name);
    }

    public void onEndRequest(Request request) {
        super.onEndRequest(request);
        usedPages.set(null);
    }

    public void destroy() {
        super.destroy();
        this.getStore().destroy();
    }

    public IPageStore getStore() {
        return this.pageStore;
    }

    public IPageVersionManager newVersionManager(Page page) {
        return new SecondLevelCachePageVersionManager(page);
    }

    public void setAttribute(Request request, String name, Object value) {
        if (!(value instanceof Page)) {
            super.setAttribute(request, name, value);
        }
    }

    protected void onUnbind(String sessionId) {
        this.getStore().unbind(sessionId);
    }

    private static final class SecondLevelCachePageVersionManager
    implements IPageVersionManager {
        private static final long serialVersionUID = 1L;
        private short currentVersionNumber;
        private short currentAjaxVersionNumber;
        private short lastAjaxVersionNumber;
        private final Page page;
        private transient boolean versionStarted;

        public SecondLevelCachePageVersionManager(Page page) {
            this.page = page;
        }

        public void beginVersion(boolean mergeVersion) {
            if (this.versionStarted) {
                return;
            }
            this.versionStarted = true;
            if (!mergeVersion) {
                this.currentVersionNumber = (short)(this.currentVersionNumber + 1);
                this.lastAjaxVersionNumber = this.currentAjaxVersionNumber;
                this.currentAjaxVersionNumber = 0;
            } else if (RequestCycle.get().getRequest() instanceof WebRequest && ((WebRequest)RequestCycle.get().getRequest()).isAjax()) {
                this.currentAjaxVersionNumber = (short)(this.currentAjaxVersionNumber + 1);
            }
        }

        public void componentAdded(Component component) {
        }

        public void componentModelChanging(Component component) {
        }

        public void componentRemoved(Component component) {
        }

        public void componentStateChanging(Change change) {
        }

        public void endVersion(boolean mergeVersion) {
            this.versionStarted = false;
            String sessionId = this.page.getSession().getId();
            if (sessionId != null) {
                this.page.getSession().touch(this.page);
            }
        }

        public void expireOldestVersion() {
        }

        public int getAjaxVersionNumber() {
            return this.currentAjaxVersionNumber;
        }

        public int getCurrentVersionNumber() {
            return this.currentVersionNumber;
        }

        public Page getVersion(int versionNumber) {
            if (this.currentVersionNumber == versionNumber) {
                return this.page;
            }
            return null;
        }

        public int getVersions() {
            return 0;
        }

        public void ignoreVersionMerge() {
            this.currentVersionNumber = (short)(this.currentVersionNumber + 1);
            this.lastAjaxVersionNumber = this.currentAjaxVersionNumber;
            this.currentAjaxVersionNumber = 0;
        }

        public Page rollbackPage(int numberOfVersions) {
            String sessionId = this.page.getSession().getId();
            if (sessionId != null) {
                int versionNumber = this.currentVersionNumber;
                int ajaxNumber = this.currentAjaxVersionNumber;
                if (this.versionStarted) {
                    --versionNumber;
                    --ajaxNumber;
                }
                IPageStore store = ((SecondLevelCacheSessionStore)Application.get().getSessionStore()).getStore();
                if (ajaxNumber >= numberOfVersions) {
                    return store.getPage(sessionId, this.page.getPageMapName(), this.page.getNumericId(), versionNumber, ajaxNumber - numberOfVersions);
                }
                --versionNumber;
                if ((ajaxNumber = this.lastAjaxVersionNumber - (numberOfVersions - ajaxNumber)) < 0) {
                    log.error("trying to rollback to many versions, jumping over 2 page versions is not supported yet.");
                    return null;
                }
                return store.getPage(sessionId, this.page.getPageMapName(), this.page.getNumericId(), versionNumber, ajaxNumber);
            }
            return null;
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            s.defaultReadObject();
        }
    }

    private static final class SecondLevelCachePageMap
    extends PageMap {
        private static final long serialVersionUID = 1L;
        private transient Page lastPage = null;
        private final boolean serializeLastPage;
        private Serializable lastPageDeserialized;
        private transient SecondLevelCacheSessionStore sessionStore;

        private IPageStore getPageStore() {
            if (this.sessionStore == null) {
                Application app;
                Application application = app = Application.exists() ? Application.get() : null;
                if (app != null) {
                    this.sessionStore = (SecondLevelCacheSessionStore)app.getSessionStore();
                }
            }
            if (this.sessionStore != null) {
                return this.sessionStore.getStore();
            }
            return null;
        }

        private Page getLastPage() {
            if (this.lastPage == null && this.lastPageDeserialized != null) {
                IPageStore store = this.getPageStore();
                if (store instanceof ISerializationAwarePageStore) {
                    this.lastPage = ((ISerializationAwarePageStore)store).restoreAfterSerialization(this.lastPageDeserialized);
                } else if (this.lastPageDeserialized instanceof Page) {
                    this.lastPage = (Page)this.lastPageDeserialized;
                }
                this.lastPageDeserialized = null;
            }
            return this.lastPage;
        }

        private void setLastPage(Page lastPage) {
            this.lastPage = lastPage;
            this.lastPageDeserialized = null;
        }

        private SecondLevelCachePageMap(SecondLevelCacheSessionStore sessionStore, String name) {
            super(name);
            this.sessionStore = sessionStore;
            this.serializeLastPage = !sessionStore.isPageStoreClustered();
        }

        public boolean containsPage(int id, int versionNumber) {
            Page lastPage = this.lastPage;
            if (lastPage != null && lastPage.getNumericId() == id && lastPage.getCurrentVersionNumber() == versionNumber) {
                return true;
            }
            return this.getStore().containsPage(this.getSession().getId(), this.getName(), id, versionNumber);
        }

        public Page get(int id, int versionNumber) {
            Page page;
            IntHashMap pages;
            HashMap<String, IntHashMap> pageMaps = (HashMap<String, IntHashMap>)usedPages.get();
            if (pageMaps == null) {
                pageMaps = new HashMap<String, IntHashMap>();
                usedPages.set(pageMaps);
            }
            if ((pages = (IntHashMap)pageMaps.get(this.getName())) == null) {
                pages = new IntHashMap();
                pageMaps.put(this.getName(), pages);
            }
            if ((page = (Page)pages.get(id)) != null) {
                return page;
            }
            String sessionId = this.getSession().getId();
            if (this.getLastPage() != null && this.getLastPage().getNumericId() == id) {
                Page page2 = page = versionNumber != -1 ? this.getLastPage().getVersion(versionNumber) : this.getLastPage();
                if (page != null) {
                    this.getStore().pageAccessed(sessionId, page);
                    pages.put(id, page);
                    return page;
                }
            }
            if (sessionId != null) {
                this.setLastPage(null);
                page = this.getStore().getPage(sessionId, this.getName(), id, versionNumber, -1);
                pages.put(id, page);
                return page;
            }
            return null;
        }

        public void put(Page page) {
            Session session;
            String sessionId;
            if (!page.isPageStateless() && (sessionId = (session = this.getSession()).getId()) != null && !session.isSessionInvalidated()) {
                this.getStore().storePage(sessionId, page);
                this.setLastPage(page);
                this.dirty();
            }
        }

        public void clear() {
            super.clear();
            String sessionId = this.getSession().getId();
            if (sessionId != null) {
                this.getStore().removePage(sessionId, this.getName(), -1);
            }
        }

        public void removeEntry(IPageMapEntry entry) {
            String sessionId = this.getSession().getId();
            if (sessionId != null) {
                this.getStore().removePage(sessionId, this.getName(), entry.getNumericId());
            }
        }

        private IPageStore getStore() {
            return ((SecondLevelCacheSessionStore)Application.get().getSessionStore()).getStore();
        }

        private void writeObject(ObjectOutputStream s) throws IOException {
            s.defaultWriteObject();
            if (this.serializeLastPage) {
                Serializable page = this.lastPage;
                IPageStore store = this.getPageStore();
                if (page != null && store instanceof ISerializationAwarePageStore) {
                    page = ((ISerializationAwarePageStore)store).prepareForSerialization(this.lastPage);
                }
                try {
                    s.writeObject(page);
                }
                catch (Exception e) {
                    throw new WicketRuntimeException("Failed to serialize " + page.toString(), e);
                }
            }
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            Serializable page;
            s.defaultReadObject();
            if (this.serializeLastPage && (page = (Serializable)s.readObject()) != null) {
                this.lastPageDeserialized = page;
            }
        }
    }

    public static interface ISerializationAwarePageStore
    extends IPageStore {
        public Serializable prepareForSerialization(Page var1);

        public Page restoreAfterSerialization(Serializable var1);
    }

    public static interface IClusteredPageStore
    extends IPageStore {
    }

    public static interface IPageStore {
        public void destroy();

        public Page getPage(String var1, String var2, int var3, int var4, int var5);

        public void pageAccessed(String var1, Page var2);

        public void removePage(String var1, String var2, int var3);

        public void storePage(String var1, Page var2);

        public void unbind(String var1);

        public boolean containsPage(String var1, String var2, int var3, int var4);
    }
}

