/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.protocol.http.WebRequest;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.value.ValueMap;

public final class RequestUtils {
    public static void decodeParameters(String queryString, ValueMap params) {
        String[] paramTuples = queryString.split("&");
        for (int t = 0; t < paramTuples.length; ++t) {
            String[] bits = paramTuples[t].split("=");
            try {
                if (bits.length == 2) {
                    params.add(URLDecoder.decode(bits[0], "UTF-8"), URLDecoder.decode(bits[1], "UTF-8"));
                    continue;
                }
                params.add(URLDecoder.decode(bits[0], "UTF-8"), "");
                continue;
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
    }

    static String removeDoubleDots(String path) {
        ArrayList<String> newcomponents = new ArrayList<String>(Arrays.asList(path.split("/")));
        for (int i = 0; i < newcomponents.size(); ++i) {
            if (i >= newcomponents.size() - 1 || ((String)newcomponents.get(i)).length() <= 0 || !newcomponents.get(i + 1).equals("..")) continue;
            newcomponents.remove(i);
            newcomponents.remove(i);
            if ((i -= 2) >= -1) continue;
            i = -1;
        }
        String newpath = Strings.join("/", newcomponents.toArray(new String[0]));
        if (path.endsWith("/")) {
            return newpath + "/";
        }
        return newpath;
    }

    private RequestUtils() {
    }

    public static String decode(String path) {
        try {
            return URLDecoder.decode(path, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new WicketRuntimeException(e);
        }
    }

    public static final String toAbsolutePath(String relativePagePath) {
        HttpServletRequest req = ((WebRequest)RequestCycle.get().getRequest()).getHttpServletRequest();
        return RequestUtils.toAbsolutePath(req.getRequestURL().toString(), relativePagePath);
    }

    public static final String toAbsolutePath(String requestPath, String relativePagePath) {
        StringBuffer result = requestPath.endsWith("/") ? new StringBuffer(requestPath) : new StringBuffer(requestPath.substring(0, requestPath.lastIndexOf(47) + 1));
        if (relativePagePath.startsWith("../")) {
            StringBuffer tempRelative = new StringBuffer(relativePagePath);
            while (tempRelative.indexOf("../") == 0) {
                tempRelative.delete(0, 3);
                result.setLength(result.length() - 1);
                result.delete(result.lastIndexOf("/") + 1, result.length());
            }
            result.append(tempRelative);
        } else {
            result.append(relativePagePath);
        }
        return result.toString();
    }
}

