/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.repeater;

import java.util.Iterator;
import org.apache.wicket.markup.repeater.DefaultItemReuseStrategy;
import org.apache.wicket.markup.repeater.IItemFactory;
import org.apache.wicket.markup.repeater.IItemReuseStrategy;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.version.undo.Change;

public abstract class RefreshingView
extends RepeatingView {
    private static final long serialVersionUID = 1L;
    private IItemReuseStrategy itemReuseStrategy;

    public RefreshingView(String id) {
        super(id);
    }

    public RefreshingView(String id, IModel model) {
        super(id, model);
    }

    protected final void onPopulate() {
        IItemFactory itemFactory = new IItemFactory(){

            public Item newItem(int index, IModel model) {
                String id = RefreshingView.this.newChildId();
                Item item = RefreshingView.this.newItem(id, index, model);
                RefreshingView.this.populateItem(item);
                return item;
            }
        };
        Iterator models = this.getItemModels();
        Iterator items = this.getItemReuseStrategy().getItems(itemFactory, models, this.getItems());
        this.removeAll();
        this.addItems(items);
    }

    protected abstract Iterator getItemModels();

    protected abstract void populateItem(Item var1);

    protected Item newItem(String id, int index, IModel model) {
        return new Item(id, index, model);
    }

    public Iterator getItems() {
        return this.iterator();
    }

    protected void addItems(Iterator items) {
        int index = 0;
        while (items.hasNext()) {
            Item item = (Item)items.next();
            item.setIndex(index);
            this.add(item);
            ++index;
        }
    }

    public IItemReuseStrategy getItemReuseStrategy() {
        if (this.itemReuseStrategy == null) {
            return DefaultItemReuseStrategy.getInstance();
        }
        return this.itemReuseStrategy;
    }

    public RefreshingView setItemReuseStrategy(IItemReuseStrategy strategy) {
        if (strategy == null) {
            throw new IllegalArgumentException();
        }
        if (!strategy.equals(this.itemReuseStrategy)) {
            if (this.isVersioned()) {
                this.addStateChange(new Change(){
                    private static final long serialVersionUID = 1L;
                    private final IItemReuseStrategy old;
                    {
                        this.old = RefreshingView.this.itemReuseStrategy;
                    }

                    public void undo() {
                        RefreshingView.this.itemReuseStrategy = this.old;
                    }

                    public String toString() {
                        return "ItemsReuseStrategyChange[component: " + RefreshingView.this.getPath() + ", reuse: " + this.old + "]";
                    }
                });
            }
            this.itemReuseStrategy = strategy;
        }
        return this;
    }
}

