/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.parser.filter;

import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupElement;
import org.apache.wicket.markup.parser.AbstractMarkupFilter;
import org.apache.wicket.markup.parser.XmlTag;
import org.apache.wicket.util.collections.ArrayListStack;

public final class TagTypeHandler
extends AbstractMarkupFilter {
    private final ArrayListStack stack = new ArrayListStack();
    private static final Map requireOpenBodyCloseTag = new HashMap();

    public MarkupElement nextTag() throws ParseException {
        if (this.stack.size() > 0) {
            ComponentTag top = (ComponentTag)this.stack.pop();
            return top;
        }
        ComponentTag tag = (ComponentTag)this.getParent().nextTag();
        if (tag == null) {
            return tag;
        }
        if (tag.isOpenClose()) {
            String name = tag.getName();
            if (tag.getNamespace() != null) {
                name = tag.getNamespace() + ":" + tag.getName();
            }
            if (TagTypeHandler.requiresOpenBodyCloseTag(name)) {
                tag.setType(XmlTag.OPEN);
                XmlTag closeTag = new XmlTag();
                closeTag.setType(XmlTag.CLOSE);
                closeTag.setName(tag.getName());
                closeTag.setNamespace(tag.getNamespace());
                closeTag.closes(tag);
                this.stack.push(new ComponentTag(closeTag));
            }
        }
        return tag;
    }

    public static boolean requiresOpenBodyCloseTag(String name) {
        return requireOpenBodyCloseTag.get(name) != null;
    }

    static {
        requireOpenBodyCloseTag.put("select", Boolean.TRUE);
    }
}

