/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.link;

import java.io.Serializable;
import org.apache.wicket.IPageMap;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.link.PopupSettings;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.string.Strings;

public class ExternalLink
extends AbstractLink {
    private static final long serialVersionUID = 1L;
    private final IModel label;
    private boolean contextRelative = false;
    private PopupSettings popupSettings = null;

    public ExternalLink(String id, String href, String label) {
        super(id);
        this.setModel(href != null ? new Model((Serializable)((Object)href)) : null);
        this.label = label != null ? new Model((Serializable)((Object)label)) : null;
    }

    public ExternalLink(String id, String href) {
        this(id, href, null);
    }

    public ExternalLink(String id, IModel href, IModel label) {
        super(id);
        this.setModel(this.wrap(href));
        this.label = this.wrap(label);
    }

    public ExternalLink(String id, IModel href) {
        this(id, href, null);
    }

    public final PopupSettings getPopupSettings() {
        return this.popupSettings;
    }

    public final ExternalLink setPopupSettings(PopupSettings popupSettings) {
        this.popupSettings = popupSettings;
        return this;
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        if (!this.isLinkEnabled()) {
            this.disableLink(tag);
        } else if (this.getModel() != null) {
            IPageMap popupPageMap;
            Object hrefValue = this.getModelObject();
            if (hrefValue != null) {
                String url = hrefValue.toString();
                if (this.contextRelative) {
                    if (url.length() > 0 && url.charAt(0) == '/') {
                        url = url.substring(1);
                    }
                    url = RequestCycle.get().getRequest().getRelativePathPrefixToContextRoot() + url;
                }
                if (tag.getName().equalsIgnoreCase("a") || tag.getName().equalsIgnoreCase("link") || tag.getName().equalsIgnoreCase("area")) {
                    tag.put("href", Strings.replaceAll(url, "&", "&amp;"));
                    if (this.popupSettings != null) {
                        tag.put("onclick", this.popupSettings.getPopupJavaScript());
                    }
                } else if (this.popupSettings != null) {
                    this.popupSettings.setTarget("'" + url + "'");
                    String popupScript = this.popupSettings.getPopupJavaScript();
                    tag.put("onclick", popupScript);
                } else {
                    tag.put("onclick", "window.location.href='" + url + "';");
                }
            }
            if (this.popupSettings != null && (popupPageMap = this.popupSettings.getPageMap(this)) != null && popupPageMap.getName() != null) {
                tag.put("target", popupPageMap.getName());
            }
        }
    }

    protected void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        if (!this.isLinkEnabled() && this.getBeforeDisabledLink() != null) {
            this.getResponse().write(this.getBeforeDisabledLink());
        }
        if (this.label != null && this.label.getObject() != null) {
            this.replaceComponentTagBody(markupStream, openTag, this.getModelObjectAsString(this.label.getObject()));
        } else {
            this.renderComponentTagBody(markupStream, openTag);
        }
        if (!this.isLinkEnabled() && this.getAfterDisabledLink() != null) {
            this.getResponse().write(this.getAfterDisabledLink());
        }
    }

    public boolean isContextRelative() {
        return this.contextRelative;
    }

    public ExternalLink setContextRelative(boolean contextRelative) {
        this.contextRelative = contextRelative;
        return this;
    }

    public IModel getLabel() {
        return this.label;
    }
}

