/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.link;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.IPageMap;
import org.apache.wicket.Page;
import org.apache.wicket.PageMap;
import org.apache.wicket.PageParameters;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.collections.MiniMap;
import org.apache.wicket.util.lang.Classes;

public class BookmarkablePageLink
extends Link {
    private static final long serialVersionUID = 1L;
    private final String pageClassName;
    private String pageMapName = null;
    protected MiniMap parameters;

    public BookmarkablePageLink(String id, Class pageClass) {
        this(id, pageClass, null);
    }

    private MiniMap pageParametersToMiniMap(PageParameters parameters) {
        if (parameters != null) {
            MiniMap map = new MiniMap(parameters, parameters.keySet().size());
            return map;
        }
        return null;
    }

    private PageParameters getPageParameters() {
        PageParameters result = new PageParameters();
        if (this.parameters != null) {
            Iterator i = this.parameters.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = (Map.Entry)i.next();
                result.put(entry.getKey(), entry.getValue());
            }
        }
        return result;
    }

    private void setParameterImpl(String key, Object value) {
        PageParameters parameters = this.getPageParameters();
        parameters.put(key, value);
        this.parameters = this.pageParametersToMiniMap(parameters);
    }

    public BookmarkablePageLink(String id, Class pageClass, PageParameters parameters) {
        super(id);
        this.parameters = this.pageParametersToMiniMap(parameters);
        if (pageClass == null) {
            throw new IllegalArgumentException("Page class for bookmarkable link cannot be null");
        }
        if (!Page.class.isAssignableFrom(pageClass)) {
            throw new IllegalArgumentException("Page class must be derived from " + Page.class.getName());
        }
        this.pageClassName = pageClass.getName();
    }

    public final Class getPageClass() {
        return Classes.resolveClass(this.pageClassName);
    }

    public final IPageMap getPageMap() {
        if (this.pageMapName != null) {
            return PageMap.forName(this.pageMapName);
        }
        return this.getPage().getPageMap();
    }

    public boolean linksTo(Page page) {
        return page.getClass() == this.getPageClass();
    }

    protected boolean getStatelessHint() {
        return true;
    }

    public final void onClick() {
    }

    public final BookmarkablePageLink setPageMap(IPageMap pageMap) {
        if (pageMap != null) {
            this.pageMapName = pageMap.getName();
            this.add(new AttributeModifier("target", true, (IModel)new Model((Serializable)((Object)this.pageMapName))));
        }
        return this;
    }

    public BookmarkablePageLink setParameter(String property, int value) {
        this.setParameterImpl(property, Integer.toString(value));
        return this;
    }

    public BookmarkablePageLink setParameter(String property, long value) {
        this.setParameterImpl(property, Long.toString(value));
        return this;
    }

    public BookmarkablePageLink setParameter(String property, String value) {
        this.setParameterImpl(property, value);
        return this;
    }

    protected CharSequence getURL() {
        if (this.pageMapName != null && this.getPopupSettings() != null) {
            throw new IllegalStateException("You cannot specify popup settings and a page map");
        }
        PageParameters parameters = this.getPageParameters();
        if (this.getPopupSettings() != null) {
            return this.urlFor(this.getPopupSettings().getPageMap(this), this.getPageClass(), parameters);
        }
        return this.urlFor(this.getPageMap(), this.getPageClass(), parameters);
    }
}

