/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.include;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.WebComponent;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.protocol.http.WebRequest;
import org.apache.wicket.util.resource.UrlResourceStream;

public class Include
extends WebComponent {
    private static final long serialVersionUID = 1L;
    private static final String VALID_SCHEME_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+.-";

    public Include(String id) {
        super(id);
    }

    public Include(String id, IModel model) {
        super(id, model);
    }

    public Include(String id, String modelObject) {
        super(id, new Model((Serializable)((Object)modelObject)));
    }

    protected String importAsString() {
        String url = this.getModelObjectAsString();
        if (!this.isAbsolute(url)) {
            return this.importRelativeUrl(url);
        }
        return this.importAbsoluteUrl(url);
    }

    protected void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        String content = this.importAsString();
        this.replaceComponentTagBody(markupStream, openTag, content);
    }

    protected final boolean isAbsolute(String url) {
        if (url == null) {
            return false;
        }
        int colonPos = url.indexOf(":");
        if (colonPos == -1) {
            return false;
        }
        for (int i = 0; i < colonPos; ++i) {
            if (VALID_SCHEME_CHARS.indexOf(url.charAt(i)) != -1) continue;
            return false;
        }
        return true;
    }

    private String importRelativeUrl(CharSequence url) {
        HttpServletRequest req = ((WebRequest)this.getRequest()).getHttpServletRequest();
        StringBuffer buildUrl = new StringBuffer(url.length());
        String scheme = req.getScheme();
        int port = req.getServerPort();
        buildUrl.append(scheme);
        buildUrl.append("://");
        buildUrl.append(req.getServerName());
        if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
            buildUrl.append(':');
            buildUrl.append(req.getServerPort());
        }
        buildUrl.append(req.getContextPath()).append('/').append((Object)url);
        return this.importAbsoluteUrl(buildUrl);
    }

    private String importAbsoluteUrl(CharSequence url) {
        try {
            return this.importUrl(new URL(((Object)url).toString()));
        }
        catch (MalformedURLException e) {
            throw new WicketRuntimeException(e);
        }
    }

    private final String importUrl(URL url) {
        UrlResourceStream resourceStream = new UrlResourceStream(url);
        String content = resourceStream.asString();
        return content;
    }
}

