/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form.persistence;

import javax.servlet.http.Cookie;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.persistence.CookieValuePersisterSettings;
import org.apache.wicket.markup.html.form.persistence.IValuePersister;
import org.apache.wicket.protocol.http.WebRequest;
import org.apache.wicket.protocol.http.WebResponse;
import org.apache.wicket.util.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CookieValuePersister
implements IValuePersister {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger((Class)CookieValuePersister.class);

    public void clear(FormComponent component) {
        Cookie cookie = this.getCookie(component);
        if (cookie != null) {
            this.clear(cookie);
            if (log.isDebugEnabled()) {
                log.debug("Cookie for " + component + " removed");
            }
        }
    }

    public void load(FormComponent component) {
        String value;
        Cookie cookie = this.getCookie(component);
        if (cookie != null && (value = cookie.getValue()) != null) {
            component.setModelValue(value.split(FormComponent.VALUE_SEPARATOR));
        }
    }

    public void save(FormComponent component) {
        String name = this.getName(component);
        String value = component.getValue();
        Cookie cookie = this.getCookie(component);
        if (cookie == null) {
            cookie = new Cookie(name, value == null ? "" : value);
        } else {
            cookie.setValue(value == null ? "" : value);
        }
        cookie.setSecure(false);
        cookie.setMaxAge(this.getSettings().getMaxAge());
        this.save(cookie);
    }

    protected String getName(FormComponent component) {
        return component.getPageRelativePath();
    }

    private void clear(Cookie cookie) {
        if (cookie != null) {
            cookie.setMaxAge(0);
            cookie.setValue(null);
            this.save(cookie);
        }
    }

    private String cookieToDebugString(Cookie cookie) {
        return "[Cookie  name = " + cookie.getName() + ", value = " + cookie.getValue() + ", domain = " + cookie.getDomain() + ", path = " + cookie.getPath() + ", maxAge = " + Time.valueOf(cookie.getMaxAge()).toDateString() + "(" + cookie.getMaxAge() + ")" + "]";
    }

    private Cookie getCookie(FormComponent component) {
        String name = this.getName(component);
        Cookie cookie = this.getCookie(name);
        if (cookie != null) {
            if (cookie.getValue() != null && cookie.getValue().length() > 0) {
                if (log.isDebugEnabled()) {
                    log.debug("Got cookie: " + this.cookieToDebugString(cookie));
                }
                return cookie;
            }
            if (log.isDebugEnabled()) {
                log.debug("Got cookie " + name + ", but it had no value; returning null");
            }
        }
        return null;
    }

    private Cookie getCookie(String name) {
        try {
            return this.getWebRequest().getCookie(name);
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    private CookieValuePersisterSettings getSettings() {
        return RequestCycle.get().getApplication().getSecuritySettings().getCookieValuePersisterSettings();
    }

    private WebRequest getWebRequest() {
        return (WebRequest)RequestCycle.get().getRequest();
    }

    private WebResponse getWebResponse() {
        return (WebResponse)RequestCycle.get().getResponse();
    }

    private Cookie save(Cookie cookie) {
        String domain;
        if (cookie == null) {
            return null;
        }
        String comment = this.getSettings().getComment();
        if (comment != null) {
            cookie.setComment(comment);
        }
        if ((domain = this.getSettings().getDomain()) != null) {
            cookie.setDomain(domain);
        }
        cookie.setPath("/");
        cookie.setVersion(this.getSettings().getVersion());
        cookie.setSecure(this.getSettings().getSecure());
        this.getWebResponse().addCookie(cookie);
        if (log.isDebugEnabled()) {
            log.debug("saved: " + this.cookieToDebugString(cookie));
        }
        return cookie;
    }
}

