/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form;

import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.RequestContext;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.form.AbstractSingleSelectChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.IOnChangeListener;
import org.apache.wicket.model.IModel;
import org.apache.wicket.protocol.http.portlet.PortletRequestContext;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.version.undo.Change;

public class RadioChoice
extends AbstractSingleSelectChoice
implements IOnChangeListener {
    private static final long serialVersionUID = 1L;
    private String prefix = "";
    private String suffix = "<br />\n";
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$apache$wicket$markup$html$form$Form;

    public RadioChoice(String id) {
        super(id);
    }

    public RadioChoice(String id, List choices) {
        super(id, choices);
    }

    public RadioChoice(String id, List choices, IChoiceRenderer renderer) {
        super(id, choices, renderer);
    }

    public RadioChoice(String id, IModel model, List choices) {
        super(id, model, choices);
    }

    public RadioChoice(String id, IModel model, List choices, IChoiceRenderer renderer) {
        super(id, model, choices, renderer);
    }

    public RadioChoice(String id, IModel choices) {
        super(id, choices);
    }

    public RadioChoice(String id, IModel model, IModel choices) {
        super(id, model, choices);
    }

    public RadioChoice(String id, IModel choices, IChoiceRenderer renderer) {
        super(id, choices, renderer);
    }

    public RadioChoice(String id, IModel model, IModel choices, IChoiceRenderer renderer) {
        super(id, model, choices, renderer);
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        tag.remove("name");
    }

    public void onSelectionChanged() {
        this.convertInput();
        this.updateModel();
        this.onSelectionChanged(this.getModelObject());
    }

    protected void onSelectionChanged(Object newSelection) {
    }

    protected boolean wantOnSelectionChangedNotifications() {
        return false;
    }

    protected boolean getStatelessHint() {
        if (this.wantOnSelectionChangedNotifications()) {
            return false;
        }
        return super.getStatelessHint();
    }

    public final String getPrefix() {
        return this.prefix;
    }

    public final RadioChoice setPrefix(String prefix) {
        Page page = this.findPage();
        if (page != null) {
            this.addStateChange(new PrefixChange(this.prefix));
        }
        this.prefix = prefix;
        return this;
    }

    public final String getSuffix() {
        return this.suffix;
    }

    public final RadioChoice setSuffix(String suffix) {
        Page page = this.findPage();
        if (page != null) {
            this.addStateChange(new SuffixChange(this.suffix));
        }
        this.suffix = suffix;
        return this;
    }

    protected final void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        List choices = this.getChoices();
        AppendingStringBuffer buffer = new AppendingStringBuffer((choices.size() + 1) * 70);
        String selected = this.getValue();
        for (int index = 0; index < choices.size(); ++index) {
            Object choice = choices.get(index);
            Object displayValue = this.getChoiceRenderer().getDisplayValue(choice);
            Class<?> objectClass = displayValue == null ? null : displayValue.getClass();
            String label = "";
            if (objectClass != null && objectClass != (class$java$lang$String == null ? RadioChoice.class$("java.lang.String") : class$java$lang$String)) {
                label = this.getConverter(objectClass).convertToString(displayValue, this.getLocale());
            } else if (displayValue != null) {
                label = displayValue.toString();
            }
            if (label == null) continue;
            buffer.append(this.getPrefix());
            String id = this.getChoiceRenderer().getIdValue(choice, index);
            String idAttr = this.getInputName() + "_" + id;
            buffer.append("<input name=\"").append(this.getInputName()).append("\"").append(" type=\"radio\"").append(this.isSelected(choice, index, selected) ? " checked=\"checked\"" : "").append(this.isEnabled() ? "" : " disabled=\"disabled\"").append(" value=\"").append(id).append("\" id=\"").append(idAttr).append("\"");
            if (this.wantOnSelectionChangedNotifications()) {
                CharSequence url = this.urlFor(IOnChangeListener.INTERFACE);
                Form form = (Form)this.findParent(class$org$apache$wicket$markup$html$form$Form == null ? RadioChoice.class$("org.apache.wicket.markup.html.form.Form") : class$org$apache$wicket$markup$html$form$Form);
                if (form != null) {
                    RequestContext rc = RequestContext.get();
                    if (rc.isPortletRequest()) {
                        url = ((PortletRequestContext)rc).getLastEncodedPath();
                    }
                    buffer.append(" onclick=\"").append(form.getJsForInterfaceUrl(url)).append(";\"");
                } else {
                    buffer.append(" onclick=\"window.location.href='").append(url).append((((Object)url).toString().indexOf(63) > -1 ? "&amp;" : "?") + this.getInputName()).append("=").append(id).append("';\"");
                }
            }
            buffer.append("/>");
            String display = label;
            if (this.localizeDisplayValues()) {
                display = this.getLocalizer().getString(label, (Component)this, label);
            }
            CharSequence escaped = Strings.escapeMarkup(display, false, true);
            buffer.append("<label for=\"").append(idAttr).append("\">").append(escaped).append("</label>");
            buffer.append(this.getSuffix());
        }
        this.replaceComponentTagBody(markupStream, openTag, buffer);
    }

    private class PrefixChange
    extends Change {
        private static final long serialVersionUID = 1L;
        private final String prevPrefix;

        PrefixChange(String prevSuffix) {
            this.prevPrefix = prevSuffix;
        }

        public void undo() {
            RadioChoice.this.setPrefix(this.prevPrefix);
        }

        public String toString() {
            return "PrefixChange[component: " + RadioChoice.this.getPath() + ", prefix: " + this.prevPrefix + "]";
        }
    }

    private class SuffixChange
    extends Change {
        private static final long serialVersionUID = 1L;
        final String prevSuffix;

        SuffixChange(String prevSuffix) {
            this.prevSuffix = prevSuffix;
        }

        public void undo() {
            RadioChoice.this.setSuffix(this.prevSuffix);
        }

        public String toString() {
            return "SuffixChange[component: " + RadioChoice.this.getPath() + ", suffix: " + this.prevSuffix + "]";
        }
    }
}

