/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form;

import org.apache.wicket.RequestContext;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IOnChangeListener;
import org.apache.wicket.markup.html.form.LabeledWebMarkupContainer;
import org.apache.wicket.markup.html.form.RadioGroup;
import org.apache.wicket.model.IModel;
import org.apache.wicket.protocol.http.portlet.PortletRequestContext;
import org.apache.wicket.util.lang.Objects;

public class Radio
extends LabeledWebMarkupContainer {
    private static final long serialVersionUID = 1L;
    private static final String ATTR_DISABLED = "disabled";
    private short uuid = (short)-1;

    public Radio(String id) {
        super(id);
    }

    public Radio(String id, IModel model) {
        super(id, model);
    }

    public final String getValue() {
        if (this.uuid < 0) {
            this.uuid = this.getPage().getAutoIndex();
        }
        return "radio" + this.uuid;
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        this.checkComponentTag(tag, "input");
        this.checkComponentTagAttribute(tag, "type", "radio");
        String value = this.getValue();
        RadioGroup group = (RadioGroup)this.findParent(RadioGroup.class);
        if (group == null) {
            throw new WicketRuntimeException("Radio component [" + this.getPath() + "] cannot find its parent RadioGroup. All Radio components must be a child of or below in the hierarchy of a RadioGroup component.");
        }
        tag.put("name", group.getInputName());
        tag.put("value", value);
        if (group.hasRawInput()) {
            String rawInput = group.getRawInput();
            if (rawInput != null && rawInput.equals(value)) {
                tag.put("checked", "checked");
            }
        } else if (Objects.equal(group.getModelObject(), this.getModelObject())) {
            tag.put("checked", "checked");
        }
        if (group.wantOnSelectionChangedNotifications()) {
            CharSequence url = group.urlFor(IOnChangeListener.INTERFACE);
            Form form = (Form)group.findParent(Form.class);
            if (form != null) {
                RequestContext rc = RequestContext.get();
                if (rc.isPortletRequest()) {
                    url = ((PortletRequestContext)rc).getLastEncodedPath();
                }
                tag.put("onclick", form.getJsForInterfaceUrl(url));
            } else {
                tag.put("onclick", "window.location.href='" + url + (((Object)url).toString().indexOf(63) > -1 ? "&amp;" : "?") + group.getInputName() + "=' + this.value;");
            }
        }
        if (!(this.isActionAuthorized(ENABLE) && this.isEnabled() && group.isEnabled())) {
            tag.put(ATTR_DISABLED, ATTR_DISABLED);
        }
    }

    public Radio setLabel(IModel labelModel) {
        this.setLabelInternal(labelModel);
        return this;
    }
}

