/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form;

import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.Localizer;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IFormVisitorParticipant;
import org.apache.wicket.markup.html.form.LabeledWebMarkupContainer;
import org.apache.wicket.markup.html.form.ValidationErrorFeedback;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.convert.ConversionException;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.lang.Classes;
import org.apache.wicket.util.string.PrependingStringBuffer;
import org.apache.wicket.util.string.StringList;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.string.interpolator.MapVariableInterpolator;
import org.apache.wicket.validation.IErrorMessageSource;
import org.apache.wicket.validation.INullAcceptingValidator;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.IValidatorAddListener;
import org.apache.wicket.validation.ValidationError;
import org.apache.wicket.version.undo.Change;

public abstract class FormComponent
extends LabeledWebMarkupContainer
implements IFormVisitorParticipant {
    public static String VALUE_SEPARATOR = ";";
    private static final String[] EMPTY_STRING_ARRAY = new String[]{""};
    private static final short FLAG_PERSISTENT = 512;
    private static final short FLAG_REQUIRED = 1024;
    private static final String NO_RAW_INPUT = "[-NO-RAW-INPUT-]";
    private static final long serialVersionUID = 1L;
    protected static final short FLAG_CONVERT_EMPTY_INPUT_STRING_TO_NULL = 256;
    private transient Object convertedInput;
    private String rawInput = "[-NO-RAW-INPUT-]";
    private String typeName;
    private Object validators = null;

    public static final void visitFormComponentsPostOrder(Component component, IVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument `visitor` cannot be null");
        }
        FormComponent.visitFormComponentsPostOrderHelper(component, visitor);
    }

    private static final Object visitFormComponentsPostOrderHelper(Component component, IVisitor visitor) {
        MarkupContainer container;
        if (component instanceof MarkupContainer && (container = (MarkupContainer)component).size() > 0) {
            boolean visitChildren = true;
            if (container instanceof IFormVisitorParticipant) {
                visitChildren = ((IFormVisitorParticipant)((Object)container)).processChildren();
            }
            if (visitChildren) {
                Iterator children = container.iterator();
                while (children.hasNext()) {
                    Component child = (Component)children.next();
                    Object value = FormComponent.visitFormComponentsPostOrderHelper(child, visitor);
                    if (value != Component.IVisitor.STOP_TRAVERSAL) continue;
                    return value;
                }
            }
        }
        if (component instanceof FormComponent) {
            FormComponent fc = (FormComponent)component;
            return visitor.formComponent(fc);
        }
        return null;
    }

    public FormComponent(String id) {
        super(id);
        this.setVersioned(false);
    }

    public FormComponent(String id, IModel model) {
        super(id, model);
        this.setVersioned(false);
    }

    public final FormComponent add(IValidator validator) {
        if (validator == null) {
            throw new IllegalArgumentException("validator argument cannot be null");
        }
        this.validators_add(validator);
        if (validator instanceof IValidatorAddListener) {
            ((IValidatorAddListener)((Object)validator)).onAdded(this);
        }
        return this;
    }

    public boolean checkRequired() {
        if (this.isRequired()) {
            String input = this.getInput();
            if (input == null && !this.isInputNullable()) {
                return true;
            }
            return !Strings.isEmpty(input);
        }
        return true;
    }

    public final void clearInput() {
        this.rawInput = NO_RAW_INPUT;
    }

    public void error(IValidationError error) {
        if (error == null) {
            throw new IllegalArgumentException("Argument [[error]] cannot be null");
        }
        String message = error.getErrorMessage(new MessageSource());
        if (message == null) {
            message = "Could not locate error message for error: " + error.toString();
        }
        this.error(new ValidationErrorFeedback(error, message));
    }

    public final Object getConvertedInput() {
        return this.convertedInput;
    }

    public final void setConvertedInput(Object convertedInput) {
        this.convertedInput = convertedInput;
    }

    public Form getForm() {
        Form form = (Form)this.findParent(Form.class);
        if (form == null) {
            throw new WicketRuntimeException("Could not find Form parent for " + this);
        }
        return form;
    }

    public String getInput() {
        String[] input = this.getInputAsArray();
        if (input == null || input.length == 0) {
            return null;
        }
        return input[0].trim();
    }

    public String[] getInputAsArray() {
        String[] values = this.getRequest().getParameters(this.getInputName());
        if (!this.isInputNullable() && values != null && values.length == 1 && values[0] == null) {
            return EMPTY_STRING_ARRAY;
        }
        return values;
    }

    public String getInputName() {
        String id = this.getId();
        PrependingStringBuffer inputName = new PrependingStringBuffer(id.length());
        MarkupContainer c = this;
        while (true) {
            inputName.prepend(id);
            c = c.getParent();
            if (c == null || c instanceof Form && ((Form)c).isRootForm() || c instanceof Page) break;
            inputName.prepend(':');
            id = c.getId();
        }
        if (inputName.equals("submit")) {
            inputName.prepend(':');
        }
        return inputName.toString();
    }

    public final String getRawInput() {
        return NO_RAW_INPUT.equals(this.rawInput) ? null : this.rawInput;
    }

    public final Class getType() {
        return this.typeName == null ? null : Classes.resolveClass(this.typeName);
    }

    public String getValidatorKeyPrefix() {
        Form form = (Form)this.findParent(Form.class);
        if (form != null) {
            return this.getForm().getValidatorKeyPrefix();
        }
        return null;
    }

    public final List getValidators() {
        int size = this.validators_size();
        if (size == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<IValidator> list = new ArrayList<IValidator>(size);
        for (int i = 0; i < size; ++i) {
            list.add(this.validators_get(i));
        }
        return Collections.unmodifiableList(list);
    }

    public final String getValue() {
        if (NO_RAW_INPUT.equals(this.rawInput)) {
            return this.getModelValue();
        }
        if (this.getEscapeModelStrings() && this.rawInput != null) {
            return ((Object)Strings.escapeMarkup(this.rawInput)).toString();
        }
        return this.rawInput;
    }

    public final boolean hasRawInput() {
        return !NO_RAW_INPUT.equals(this.rawInput);
    }

    public final void inputChanged() {
        if (this.isVisibleInHierarchy() && this.isEnabled()) {
            String[] input = this.getInputAsArray();
            this.rawInput = input != null && input.length > 0 && input[0] != null ? StringList.valueOf(input).join(VALUE_SEPARATOR) : (this.isInputNullable() ? null : NO_RAW_INPUT);
        }
    }

    public final void invalid() {
        this.onInvalid();
    }

    public boolean isInputNullable() {
        return true;
    }

    public boolean isMultiPart() {
        return false;
    }

    public final boolean isPersistent() {
        return this.supportsPersistence() && this.getFlag((short)512);
    }

    public boolean isRequired() {
        return this.getFlag((short)1024);
    }

    public final boolean isValid() {
        class IsValidVisitor
        implements IVisitor {
            boolean valid = true;

            IsValidVisitor() {
            }

            public Object formComponent(IFormVisitorParticipant formComponent) {
                FormComponent fc = (FormComponent)formComponent;
                if (fc.hasErrorMessage()) {
                    this.valid = false;
                    return Component.IVisitor.STOP_TRAVERSAL;
                }
                return Component.IVisitor.CONTINUE_TRAVERSAL;
            }
        }
        IsValidVisitor tmp = new IsValidVisitor();
        FormComponent.visitFormComponentsPostOrder(this, tmp);
        return tmp.valid;
    }

    public boolean processChildren() {
        return true;
    }

    public final void processInput() {
        this.inputChanged();
        this.validate();
        if (this.hasErrorMessage()) {
            this.invalid();
        } else {
            this.valid();
            this.updateModel();
        }
    }

    public FormComponent setLabel(IModel labelModel) {
        this.setLabelInternal(labelModel);
        return this;
    }

    public void setModelValue(String value) {
        this.setModelValue(value.split(VALUE_SEPARATOR));
    }

    public void setModelValue(String[] value) {
        this.convertedInput = this.convertValue(value);
        this.updateModel();
    }

    public final FormComponent setPersistent(boolean persistent) {
        if (!this.supportsPersistence()) {
            throw new UnsupportedOperationException("FormComponent " + this.getClass() + " does not support cookies");
        }
        this.setFlag((short)512, persistent);
        return this;
    }

    public final FormComponent setRequired(boolean required) {
        if (!required && this.getType() != null && this.getType().isPrimitive()) {
            throw new WicketRuntimeException("FormComponent can't be not required when the type is primitive class: " + this);
        }
        if (required != this.isRequired()) {
            this.addStateChange(new RequiredStateChange());
        }
        this.setFlag((short)1024, required);
        return this;
    }

    public final FormComponent setType(Class type) {
        String string = this.typeName = type == null ? null : type.getName();
        if (type != null && type.isPrimitive()) {
            this.setRequired(true);
        }
        return this;
    }

    public void updateModel() {
        this.setModelObject(this.getConvertedInput());
    }

    public final void valid() {
        this.clearInput();
        this.onValid();
    }

    public final void validate() {
        this.validateRequired();
        if (this.isValid()) {
            this.convertInput();
            if (this.isValid() && this.isRequired() && this.getConvertedInput() == null && this.isInputNullable()) {
                this.reportRequiredError();
            }
            if (this.isValid()) {
                this.validateValidators();
            }
        }
    }

    private void validators_add(IValidator validator) {
        if (this.validators == null) {
            this.validators = validator;
        } else {
            int size = this.validators_size();
            IValidator[] validators = new IValidator[size + 1];
            for (int i = 0; i < size; ++i) {
                validators[i] = this.validators_get(i);
            }
            validators[size] = validator;
            this.validators = validators;
        }
    }

    private IValidator validators_get(int index) {
        if (this.validators == null) {
            throw new IndexOutOfBoundsException();
        }
        if (this.validators instanceof IValidator[]) {
            return ((IValidator[])this.validators)[index];
        }
        return (IValidator)this.validators;
    }

    private int validators_size() {
        if (this.validators == null) {
            return 0;
        }
        if (this.validators instanceof IValidator[]) {
            return ((IValidator[])this.validators).length;
        }
        return 1;
    }

    protected void convertInput() {
        if (this.typeName == null) {
            try {
                this.convertedInput = this.convertValue(this.getInputAsArray());
            }
            catch (ConversionException e) {
                ValidationError error = new ValidationError();
                if (e.getResourceKey() != null) {
                    error.addMessageKey(e.getResourceKey());
                }
                if (e.getTargetType() != null) {
                    error.addMessageKey("ConversionError." + Classes.simpleName(e.getTargetType()));
                }
                error.addMessageKey("ConversionError");
                this.reportValidationError(e, error);
            }
        } else {
            IConverter converter = this.getConverter(this.getType());
            try {
                this.convertedInput = converter.convertToObject(this.getInput(), this.getLocale());
            }
            catch (ConversionException e) {
                ValidationError error = new ValidationError();
                if (e.getResourceKey() != null) {
                    error.addMessageKey(e.getResourceKey());
                }
                String simpleName = Classes.simpleName(this.getType());
                error.addMessageKey("IConverter." + simpleName);
                error.addMessageKey("IConverter");
                error.setVariable("type", simpleName);
                this.reportValidationError(e, error);
            }
        }
    }

    private void reportValidationError(ConversionException e, ValidationError error) {
        Map variables;
        Locale locale = e.getLocale();
        if (locale != null) {
            error.setVariable("locale", locale);
        }
        error.setVariable("exception", e);
        Format format = e.getFormat();
        if (format instanceof SimpleDateFormat) {
            error.setVariable("format", ((SimpleDateFormat)format).toLocalizedPattern());
        }
        if ((variables = e.getVariables()) != null) {
            error.getVariables().putAll(variables);
        }
        this.error(error);
    }

    protected Object convertValue(String[] value) throws ConversionException {
        return value != null && value.length > 0 && value[0] != null ? value[0].trim() : null;
    }

    protected List getBehaviors(Class type) {
        return super.getBehaviors(type);
    }

    protected String getModelValue() {
        return this.getModelObjectAsString();
    }

    protected final int inputAsInt() {
        String string = this.getInput();
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(this.exceptionMessage("Internal error.  Request string '" + string + "' not a valid integer"));
        }
    }

    protected final int inputAsInt(int defaultValue) {
        String string = this.getInput();
        if (string != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(this.exceptionMessage("Request string '" + string + "' is not a valid integer"));
            }
        }
        return defaultValue;
    }

    protected final int[] inputAsIntArray() {
        String[] strings = this.getInputAsArray();
        if (strings != null) {
            int[] ints = new int[strings.length];
            for (int i = 0; i < strings.length; ++i) {
                ints[i] = Integer.parseInt(strings[i]);
            }
            return ints;
        }
        return null;
    }

    protected void internalOnModelChanged() {
        this.valid();
    }

    protected void onComponentTag(ComponentTag tag) {
        tag.put("name", this.getInputName());
        if (!this.isEnabled() || !this.isEnableAllowed()) {
            this.onDisabled(tag);
        }
        super.onComponentTag(tag);
    }

    protected void onDetach() {
        super.onDetach();
        this.convertedInput = null;
    }

    protected void onDisabled(ComponentTag tag) {
        tag.put("disabled", "disabled");
    }

    protected void onInvalid() {
    }

    protected void onValid() {
    }

    protected boolean supportsPersistence() {
        return false;
    }

    protected final void validateRequired() {
        if (!this.checkRequired()) {
            this.reportRequiredError();
        }
    }

    private void reportRequiredError() {
        this.error(new ValidationError().addMessageKey("Required"));
    }

    protected final void validateValidators() {
        int size = this.validators_size();
        ValidatableAdapter validatable = new ValidatableAdapter();
        int i = 0;
        IValidator validator = null;
        boolean isNull = this.getConvertedInput() == null;
        try {
            for (i = 0; i < size; ++i) {
                validator = this.validators_get(i);
                if (!isNull || validator instanceof INullAcceptingValidator) {
                    validator.validate(validatable);
                }
                if (this.isValid()) {
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            throw new WicketRuntimeException("Exception '" + e + "' occurred during validation " + validator.getClass().getName() + " on component " + this.getPath(), e);
        }
    }

    private class ValidatableAdapter
    implements IValidatable {
        private ValidatableAdapter() {
        }

        public void error(IValidationError error) {
            FormComponent.this.error(error);
        }

        public Object getValue() {
            return FormComponent.this.getConvertedInput();
        }

        public boolean isValid() {
            return FormComponent.this.isValid();
        }
    }

    private final class RequiredStateChange
    extends Change {
        private static final long serialVersionUID = 1L;
        private final boolean required;

        private RequiredStateChange() {
            this.required = FormComponent.this.isRequired();
        }

        public void undo() {
            FormComponent.this.setRequired(this.required);
        }
    }

    private class MessageSource
    implements IErrorMessageSource {
        private MessageSource() {
        }

        public String getMessage(String key) {
            String resource;
            Localizer localizer;
            String message;
            FormComponent formComponent = FormComponent.this;
            String prefix = formComponent.getValidatorKeyPrefix();
            if (Strings.isEmpty(prefix)) {
                prefix = "";
            }
            if (Strings.isEmpty(message = (localizer = formComponent.getLocalizer()).getString(resource = prefix + FormComponent.this.getId() + "." + key, (Component)formComponent.getParent(), ""))) {
                resource = prefix + key;
                message = localizer.getString(resource, (Component)formComponent.getParent(), "");
            }
            if (Strings.isEmpty(message) && Strings.isEmpty(message = localizer.getString(resource = prefix + FormComponent.this.getId() + "." + key, (Component)formComponent, ""))) {
                resource = prefix + key;
                message = localizer.getString(resource, (Component)formComponent, "");
            }
            if (Strings.isEmpty(message)) {
                message = null;
            }
            return message;
        }

        public String substitute(String string, Map vars) throws IllegalStateException {
            return new MapVariableInterpolator(string, this.addDefaultVars(vars), Application.get().getResourceSettings().getThrowExceptionOnMissingResource()).toString();
        }

        private Map addDefaultVars(Map params) {
            HashMap<String, Object> fullParams;
            if (params == null) {
                fullParams = new HashMap<String, Object>(6);
            } else {
                fullParams = new HashMap(params.size() + 6);
                fullParams.putAll(params);
            }
            if (!fullParams.containsKey("input")) {
                fullParams.put("input", FormComponent.this.getInput());
            }
            if (!fullParams.containsKey("name")) {
                fullParams.put("name", FormComponent.this.getId());
            }
            if (!fullParams.containsKey("label")) {
                fullParams.put("label", this.getLabel());
            }
            return fullParams;
        }

        private Object getLabel() {
            FormComponent fc = FormComponent.this;
            Object label = null;
            if (fc.getLabel() != null) {
                label = fc.getLabel().getObject();
            }
            if (label == null) {
                label = fc.getLocalizer().getString(fc.getId(), (Component)fc.getParent(), fc.getId());
            }
            return label;
        }
    }

    public static interface IVisitor {
        public Object formComponent(IFormVisitorParticipant var1);
    }

    public static abstract class AbstractVisitor
    implements IVisitor {
        public Object formComponent(IFormVisitorParticipant component) {
            if (component instanceof FormComponent) {
                this.onFormComponent((FormComponent)component);
            }
            return Component.IVisitor.CONTINUE_TRAVERSAL;
        }

        protected abstract void onFormComponent(FormComponent var1);
    }
}

