/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form;

import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.IObjectClassAwareModel;
import org.apache.wicket.util.convert.ConversionException;
import org.apache.wicket.util.string.Strings;

public abstract class AbstractTextComponent
extends FormComponent {
    private static final int TYPE_RESOLVED = 2048;
    private static final long serialVersionUID = 1L;

    public AbstractTextComponent(String id) {
        super(id);
        this.setConvertEmptyInputStringToNull(true);
    }

    public AbstractTextComponent(String id, IModel model) {
        super(id, model);
        this.setConvertEmptyInputStringToNull(true);
    }

    public final boolean getConvertEmptyInputStringToNull() {
        return this.getFlag((short)256);
    }

    public boolean isInputNullable() {
        return false;
    }

    protected void onBeforeRender() {
        super.onBeforeRender();
        if (!this.getFlag(2048) && this.getType() == null) {
            Class type;
            if (!String.class.equals(type = this.getModelType(this.getModel()))) {
                this.setType(type);
            }
            this.setFlag(2048, true);
        }
    }

    private Class getModelType(IModel model) {
        if (model instanceof IObjectClassAwareModel) {
            return ((IObjectClassAwareModel)model).getObjectClass();
        }
        return null;
    }

    public final FormComponent setConvertEmptyInputStringToNull(boolean flag) {
        this.setFlag((short)256, flag);
        return this;
    }

    protected Object convertValue(String[] value) throws ConversionException {
        String tmp;
        String string = tmp = value != null && value.length > 0 ? value[0] : null;
        if (this.getConvertEmptyInputStringToNull() && Strings.isEmpty(tmp)) {
            return null;
        }
        return super.convertValue(value);
    }

    protected boolean supportsPersistence() {
        return true;
    }

    public static interface ITextFormatProvider {
        public String getTextFormat();
    }
}

