/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupElement;
import org.apache.wicket.markup.MarkupResourceData;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.WicketTag;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Markup {
    private static final Logger log = LoggerFactory.getLogger((Class)Markup.class);
    public static final Markup NO_MARKUP = new Markup(MarkupResourceData.NO_MARKUP_RESOURCE_DATA);
    private List markupElements;
    private final MarkupResourceData markupResourceData;
    private Map componentMap;
    private StringBuffer currentPath;

    Markup(MarkupResourceData markupResourceData) {
        this.markupResourceData = markupResourceData;
        this.markupElements = new ArrayList();
    }

    public final MarkupElement get(int index) {
        return (MarkupElement)this.markupElements.get(index);
    }

    public final MarkupResourceData getMarkupResourceData() {
        return this.markupResourceData;
    }

    public int size() {
        return this.markupElements.size();
    }

    public final void addMarkupElement(MarkupElement markupElement) {
        this.markupElements.add(markupElement);
    }

    public final void addMarkupElement(int pos, MarkupElement markupElement) {
        this.markupElements.add(pos, markupElement);
    }

    final void makeImmutable() {
        for (int i = 0; i < this.markupElements.size(); ++i) {
            MarkupElement elem = (MarkupElement)this.markupElements.get(i);
            if (!(elem instanceof ComponentTag)) continue;
            ((ComponentTag)elem).makeImmutable();
        }
        this.markupElements = Collections.unmodifiableList(this.markupElements);
        this.initialize();
    }

    private void addToCache(int index, ComponentTag tag) {
        if ((tag.isOpen() || tag.isOpenClose()) && tag.getAttributes().containsKey(this.getMarkupResourceData().getWicketId())) {
            if (this.componentMap == null) {
                this.componentMap = new HashMap();
            }
            boolean fragment = tag instanceof WicketTag && ((WicketTag)tag).isFragementTag();
            String key = tag.getPath() != null && !fragment ? tag.getPath() + ":" + tag.getId() : tag.getId();
            this.componentMap.put(key, new Integer(index));
        }
    }

    private StringBuffer setComponentPathForTag(StringBuffer componentPath, ComponentTag tag) {
        if ((tag.isOpen() || tag.isOpenClose()) && tag.getAttributes().containsKey(this.markupResourceData.getWicketId())) {
            if (tag.isOpenClose() || tag.hasNoCloseTag()) {
                if (this.currentPath != null && this.currentPath.length() > 0) {
                    tag.setPath(this.currentPath.toString());
                }
            } else {
                if (this.currentPath == null) {
                    this.currentPath = new StringBuffer(100);
                } else if (this.currentPath.length() > 0) {
                    tag.setPath(this.currentPath.toString());
                    this.currentPath.append(':');
                }
                this.currentPath.append(tag.getId());
            }
        } else if (tag.isClose() && this.currentPath != null && (tag.getOpenTag() == null || tag.getOpenTag().getAttributes().containsKey(this.markupResourceData.getWicketId()))) {
            int index = this.currentPath.lastIndexOf(":");
            if (index != -1) {
                this.currentPath.setLength(index);
            } else {
                this.currentPath.setLength(0);
            }
        }
        return this.currentPath;
    }

    public int findComponentIndex(String path, String id) {
        if (id == null || id.length() == 0) {
            throw new IllegalArgumentException("Parameter 'id' must not be null");
        }
        String completePath = path == null || path.length() == 0 ? id : path + ":" + id;
        Pattern re = Pattern.compile(":\\d+");
        Matcher matcher = re.matcher(completePath);
        completePath = matcher.replaceAll("");
        if (this.componentMap == null) {
            return -1;
        }
        Integer value = (Integer)this.componentMap.get(completePath);
        if (value == null) {
            return -1;
        }
        return value;
    }

    public boolean equalTo(Markup that) {
        MarkupStream thisStream = new MarkupStream(this);
        MarkupStream thatStream = new MarkupStream(that);
        return thisStream.equalTo(thatStream);
    }

    protected void initialize() {
        this.componentMap = null;
        if (this.markupElements != null) {
            StringBuffer componentPath = null;
            for (int i = 0; i < this.size(); ++i) {
                MarkupElement elem = this.get(i);
                if (!(elem instanceof ComponentTag)) continue;
                ComponentTag tag = (ComponentTag)elem;
                componentPath = this.setComponentPathForTag(componentPath, tag);
                this.addToCache(i, tag);
            }
        }
        this.currentPath = null;
    }

    public final String toString() {
        AppendingStringBuffer buf = new AppendingStringBuffer(400);
        buf.append(this.markupResourceData.toString());
        buf.append("\n");
        Iterator iter = this.markupElements.iterator();
        while (iter.hasNext()) {
            buf.append(iter.next());
        }
        return buf.toString();
    }
}

