/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.behavior;

import org.apache.wicket.Component;
import org.apache.wicket.RequestListenerInterface;
import org.apache.wicket.Response;
import org.apache.wicket.behavior.AbstractBehavior;
import org.apache.wicket.behavior.IActivePageBehaviorListener;
import org.apache.wicket.behavior.IBehaviorListener;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.markup.html.IHeaderResponse;

public abstract class AbstractAjaxBehavior
extends AbstractBehavior
implements IBehaviorListener,
IHeaderContributor {
    private static final long serialVersionUID = 1L;
    private Component component;

    public final void bind(Component hostComponent) {
        if (hostComponent == null) {
            throw new IllegalArgumentException("Argument hostComponent must be not null");
        }
        if (this.component != null) {
            throw new IllegalStateException("this kind of handler cannot be attached to multiple components; it is already attached to component " + this.component + ", but component " + hostComponent + " wants to be attached too");
        }
        this.component = hostComponent;
        this.onBind();
    }

    public CharSequence getCallbackUrl() {
        return this.getCallbackUrl(true);
    }

    public final CharSequence getCallbackUrl(boolean onlyTargetActivePage) {
        if (this.getComponent() == null) {
            throw new IllegalArgumentException("Behavior must be bound to a component to create the URL");
        }
        RequestListenerInterface rli = onlyTargetActivePage ? IActivePageBehaviorListener.INTERFACE : IBehaviorListener.INTERFACE;
        return this.getComponent().urlFor(this, rli);
    }

    public final void onComponentTag(Component component, ComponentTag tag) {
        this.onComponentTag(tag);
    }

    public final void onRendered(Component hostComponent) {
        this.onComponentRendered();
    }

    public void renderHead(IHeaderResponse response) {
    }

    protected final Component getComponent() {
        return this.component;
    }

    protected void onComponentTag(ComponentTag tag) {
    }

    protected void onBind() {
    }

    protected void onComponentRendered() {
    }

    public boolean getStatelessHint(Component component) {
        return false;
    }

    protected final String getImplementationId() {
        return "foo";
    }

    protected final void onRenderHeadContribution(Response response) {
    }

    protected final void onRenderHeadInitContribution(Response response) {
    }
}

