/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.ajax.markup.html.form;

import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.IAjaxCallDecorator;
import org.apache.wicket.ajax.form.AjaxFormSubmitBehavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.form.AbstractSubmitLink;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.util.string.AppendingStringBuffer;

public abstract class AjaxSubmitLink
extends AbstractSubmitLink {
    private static final long serialVersionUID = 1L;

    public AjaxSubmitLink(String id) {
        this(id, (Form)null);
    }

    public AjaxSubmitLink(String id, final Form form) {
        super(id);
        this.add(new AjaxFormSubmitBehavior(form, "onclick"){
            private static final long serialVersionUID = 1L;

            protected void onSubmit(AjaxRequestTarget target) {
                AjaxSubmitLink.this.onSubmit(target, form);
            }

            protected void onError(AjaxRequestTarget target) {
                AjaxSubmitLink.this.onError(target, form);
            }

            protected CharSequence getEventHandler() {
                return new AppendingStringBuffer(super.getEventHandler()).append("; return false;");
            }

            protected IAjaxCallDecorator getAjaxCallDecorator() {
                return AjaxSubmitLink.this.getAjaxCallDecorator();
            }

            protected void onComponentTag(ComponentTag tag) {
                if (AjaxSubmitLink.this.isLinkEnabled()) {
                    super.onComponentTag(tag);
                }
            }
        });
    }

    protected IAjaxCallDecorator getAjaxCallDecorator() {
        return null;
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        if (this.isLinkEnabled()) {
            if (tag.getName().toLowerCase().equals("a")) {
                tag.put("href", "#");
            }
        } else {
            this.disableLink(tag);
        }
    }

    public final void onSubmit() {
    }

    protected abstract void onSubmit(AjaxRequestTarget var1, Form var2);

    protected void onError(AjaxRequestTarget target, Form form) {
    }
}

