/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.ajax.markup.html.form;

import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.IAjaxCallDecorator;
import org.apache.wicket.ajax.form.AjaxFormSubmitBehavior;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.string.AppendingStringBuffer;

public abstract class AjaxFallbackButton
extends Button {
    private static final long serialVersionUID = 1L;
    private final Form mForm;

    public AjaxFallbackButton(String id, Form form) {
        this(id, null, form);
    }

    public AjaxFallbackButton(String id, IModel model, Form form) {
        super(id, model);
        this.mForm = form;
        this.add(new AjaxFormSubmitBehavior(form, "onclick"){
            private static final long serialVersionUID = 1L;

            protected void onSubmit(AjaxRequestTarget target) {
                AjaxFallbackButton.this.onSubmit(target, AjaxFallbackButton.this.mForm);
            }

            protected void onError(AjaxRequestTarget target) {
                AjaxFallbackButton.this.onError(target, AjaxFallbackButton.this.mForm);
            }

            protected CharSequence getEventHandler() {
                return new AppendingStringBuffer(super.getEventHandler()).append("; return false;");
            }

            protected IAjaxCallDecorator getAjaxCallDecorator() {
                return AjaxFallbackButton.this.getAjaxCallDecorator();
            }
        });
    }

    protected void onError(AjaxRequestTarget target, Form form) {
    }

    public final void onSubmit() {
        if (!(this.getRequestCycle().getRequestTarget() instanceof AjaxRequestTarget)) {
            this.onSubmit(null, this.getForm());
        }
    }

    public Form getForm() {
        return this.mForm == null ? super.getForm() : this.mForm;
    }

    protected abstract void onSubmit(AjaxRequestTarget var1, Form var2);

    protected IAjaxCallDecorator getAjaxCallDecorator() {
        return null;
    }

    protected final boolean isButtonEnabled() {
        return this.isEnabled() && this.isEnableAllowed();
    }
}

