/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.ajax.form;

import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.util.string.AppendingStringBuffer;

public abstract class AjaxFormSubmitBehavior
extends AjaxEventBehavior {
    private static final long serialVersionUID = 1L;
    private Form form;

    public AjaxFormSubmitBehavior(String event) {
        this(null, event);
    }

    public AjaxFormSubmitBehavior(Form form, String event) {
        super(event);
        this.form = form;
        if (form != null) {
            form.setOutputMarkupId(true);
        }
    }

    private Form getForm() {
        if (this.form == null) {
            Component cursor;
            for (cursor = this.getComponent(); cursor != null && !(cursor instanceof Form); cursor = cursor.getParent()) {
            }
            if (cursor == null) {
                throw new IllegalStateException("form was not specified in the constructor and cannot be found in the hierarchy of the component this behavior is attached to");
            }
            this.form = (Form)cursor;
        }
        return this.form;
    }

    protected CharSequence getEventHandler() {
        String formId = this.getForm().getMarkupId();
        CharSequence url = this.getCallbackUrl();
        AppendingStringBuffer call = new AppendingStringBuffer("wicketSubmitFormById('").append(formId).append("', '").append(url).append("', ");
        if (this.getComponent() instanceof IFormSubmittingComponent) {
            call.append("'").append(((IFormSubmittingComponent)((Object)this.getComponent())).getInputName()).append("' ");
        } else {
            call.append("null");
        }
        return this.generateCallbackScript(call) + ";";
    }

    protected void onEvent(AjaxRequestTarget target) {
        this.getForm().onFormSubmitted();
        if (!this.getForm().hasError()) {
            this.onSubmit(target);
        }
        if (this.form.findParent(Page.class) != null && this.getForm().hasError()) {
            this.onError(target);
        }
    }

    protected abstract void onSubmit(AjaxRequestTarget var1);

    protected abstract void onError(AjaxRequestTarget var1);

    protected CharSequence getPreconditionScript() {
        return "return Wicket.$$(this)&amp;&amp;Wicket.$$('" + this.getForm().getMarkupId() + "')";
    }
}

