/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.ajax.form;

import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.form.CheckBoxMultipleChoice;
import org.apache.wicket.markup.html.form.CheckGroup;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.RadioChoice;
import org.apache.wicket.markup.html.form.RadioGroup;
import org.apache.wicket.util.string.AppendingStringBuffer;

public abstract class AjaxFormChoiceComponentUpdatingBehavior
extends AbstractDefaultAjaxBehavior {
    private static final long serialVersionUID = 1L;

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        AppendingStringBuffer asb = new AppendingStringBuffer();
        asb.append("function attachChoiceHandlers(markupid, callbackscript) {\n");
        asb.append(" var choiceElement = document.getElementById(markupid);\n");
        asb.append(" for( var x = 0; x < choiceElement.childNodes.length; x++ ) {\n");
        asb.append("   if (choiceElement.childNodes[x] && choiceElement.childNodes[x].tagName) {\n");
        asb.append("     var tag = choiceElement.childNodes[x].tagName.toLowerCase();\n");
        asb.append("     if (tag == 'input') {\n");
        asb.append("       Wicket.Event.add(choiceElement.childNodes[x],'click', callbackscript);");
        asb.append("     }\n");
        asb.append("   }\n");
        asb.append(" }\n");
        asb.append("}\n");
        response.renderJavascript(asb, "attachChoice");
        response.renderOnLoadJavascript("attachChoiceHandlers('" + this.getComponent().getMarkupId() + "', function() {" + this.getEventHandler() + "});");
    }

    protected abstract void onUpdate(AjaxRequestTarget var1);

    protected void onError(AjaxRequestTarget target, RuntimeException e) {
        if (e != null) {
            throw e;
        }
    }

    protected void onBind() {
        super.onBind();
        if (!(this.getComponent() instanceof RadioChoice || this.getComponent() instanceof CheckBoxMultipleChoice || this.getComponent() instanceof RadioGroup || this.getComponent() instanceof CheckGroup)) {
            throw new WicketRuntimeException("Behavior " + this.getClass().getName() + " can only be added to an instance of a RadioChoice/CheckboxChoice/RadioGroup/CheckGroup");
        }
        if (this.getComponent() instanceof RadioGroup || this.getComponent() instanceof CheckGroup) {
            this.getComponent().setRenderBodyOnly(false);
        }
    }

    protected final FormComponent getFormComponent() {
        return (FormComponent)this.getComponent();
    }

    protected final CharSequence getEventHandler() {
        return this.generateCallbackScript(new AppendingStringBuffer("wicketAjaxPost('").append(this.getCallbackUrl()).append("', wicketSerializeForm(document.getElementById('" + this.getComponent().getMarkupId() + "',false))"));
    }

    protected final void respond(AjaxRequestTarget target) {
        FormComponent formComponent = this.getFormComponent();
        try {
            formComponent.inputChanged();
            formComponent.validate();
            if (formComponent.hasErrorMessage()) {
                formComponent.invalid();
                this.onError(target, null);
            } else {
                formComponent.valid();
                formComponent.updateModel();
                this.onUpdate(target);
            }
        }
        catch (RuntimeException e) {
            this.onError(target, e);
        }
    }
}

