/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.ajax;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.Response;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.internal.HeaderResponse;
import org.apache.wicket.markup.html.internal.HtmlHeaderContainer;
import org.apache.wicket.markup.repeater.AbstractRepeater;
import org.apache.wicket.protocol.http.WebResponse;
import org.apache.wicket.request.target.component.IPageRequestTarget;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AjaxRequestTarget
implements IPageRequestTarget {
    private static final Logger LOG = LoggerFactory.getLogger((Class)AjaxRequestTarget.class);
    private final List appendJavascripts = new ArrayList();
    private final List domReadyJavascripts = new ArrayList();
    private final AjaxResponse encodingBodyResponse;
    private final AjaxResponse encodingHeaderResponse;
    private final Map markupIdToComponent = new LinkedHashMap();
    private final List prependJavascripts = new ArrayList();
    private List listeners = null;
    private final Page page;
    private boolean headerRendering = false;
    private HtmlHeaderContainer header = null;
    private IHeaderResponse headerResponse;

    public Page getPage() {
        return this.page;
    }

    public AjaxRequestTarget(Page page) {
        this.page = page;
        Response response = RequestCycle.get().getResponse();
        this.encodingBodyResponse = new AjaxResponse(response);
        this.encodingHeaderResponse = new AjaxResponse(response);
    }

    public void addListener(IListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument `listener` cannot be null");
        }
        if (this.listeners == null) {
            this.listeners = new LinkedList();
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public final void addChildren(MarkupContainer parent, Class childCriteria) {
        if (parent == null) {
            throw new IllegalArgumentException("Argument `parent` cannot be null");
        }
        if (childCriteria == null) {
            throw new IllegalArgumentException("Argument `childCriteria` cannot be null. If you want to traverse all components use `" + Component.class.getName() + ".class` as the value for this argument");
        }
        parent.visitChildren(childCriteria, new Component.IVisitor(){

            public Object component(Component component) {
                AjaxRequestTarget.this.addComponent(component);
                return CONTINUE_TRAVERSAL_BUT_DONT_GO_DEEPER;
            }
        });
    }

    public final void addComponent(Component component) {
        if (component == null) {
            throw new IllegalArgumentException("component cannot be null");
        }
        if (!component.getOutputMarkupId()) {
            throw new IllegalArgumentException("cannot update component that does not have setOutputMarkupId property set to true. Component: " + component.toString());
        }
        this.addComponent(component, component.getMarkupId());
    }

    public final void addComponent(Component component, String markupId) {
        if (Strings.isEmpty(markupId)) {
            throw new IllegalArgumentException("markupId cannot be empty");
        }
        if (component == null) {
            throw new IllegalArgumentException("component cannot be null");
        }
        if (component instanceof Page) {
            throw new IllegalArgumentException("component cannot be a page");
        }
        if (component instanceof AbstractRepeater) {
            throw new IllegalArgumentException("Component " + component.getClass().getName() + " has been added to the target. This component is a repeater and cannot be repainted via ajax directly. Instead add its parent or another markup container higher in the hierarchy.");
        }
        this.markupIdToComponent.put(markupId, component);
    }

    public final void addJavascript(String javascript) {
        this.appendJavascript(javascript);
    }

    public final void focusComponent(Component component) {
        if (component != null && !component.getOutputMarkupId()) {
            throw new IllegalArgumentException("cannot update component that does not have setOutputMarkupId property set to true. Component: " + component.toString());
        }
        String id = component != null ? component.getMarkupId() : null;
        this.appendJavascript("Wicket.Focus.setFocusOnId('" + id + "');");
    }

    public final void appendJavascript(String javascript) {
        if (javascript == null) {
            throw new IllegalArgumentException("javascript cannot be null");
        }
        this.appendJavascripts.add(javascript);
    }

    public void detach(RequestCycle requestCycle) {
        if (this.markupIdToComponent.size() > 0) {
            Component component = (Component)this.markupIdToComponent.values().iterator().next();
            component.getPage().detach();
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof AjaxRequestTarget) {
            AjaxRequestTarget that = (AjaxRequestTarget)obj;
            return ((Object)this.markupIdToComponent).equals(that.markupIdToComponent) && ((Object)this.prependJavascripts).equals(that.prependJavascripts) && ((Object)this.appendJavascripts).equals(that.appendJavascripts);
        }
        return false;
    }

    public int hashCode() {
        int result = "AjaxRequestTarget".hashCode();
        result += ((Object)this.markupIdToComponent).hashCode() * 17;
        result += ((Object)this.prependJavascripts).hashCode() * 17;
        return result += ((Object)this.appendJavascripts).hashCode() * 17;
    }

    public final void prependJavascript(String javascript) {
        if (javascript == null) {
            throw new IllegalArgumentException("javascript cannot be null");
        }
        this.prependJavascripts.add(javascript);
    }

    public final void respond(RequestCycle requestCycle) {
        String js;
        Application app = Application.get();
        String encoding = app.getRequestCycleSettings().getResponseRequestEncoding();
        WebResponse response = (WebResponse)requestCycle.getResponse();
        response.setCharacterEncoding(encoding);
        response.setContentType("text/xml; charset=" + encoding);
        response.setHeader("Expires", "Mon, 26 Jul 1997 05:00:00 GMT");
        response.setHeader("Cache-Control", "no-cache, must-revalidate");
        response.setHeader("Pragma", "no-cache");
        response.write("<?xml version=\"1.0\" encoding=\"");
        response.write(encoding);
        response.write("\"?>");
        response.write("<ajax-response>");
        this.fireOnBeforeRespondListeners();
        Iterator it = this.prependJavascripts.iterator();
        while (it.hasNext()) {
            js = (String)it.next();
            this.respondInvocation(response, js);
        }
        this.respondComponents(response);
        this.fireOnAfterRespondListeners(response);
        it = this.domReadyJavascripts.iterator();
        while (it.hasNext()) {
            js = (String)it.next();
            this.respondInvocation(response, js);
        }
        it = this.appendJavascripts.iterator();
        while (it.hasNext()) {
            js = (String)it.next();
            this.respondInvocation(response, js);
        }
        response.write("</ajax-response>");
    }

    private void fireOnBeforeRespondListeners() {
        if (this.listeners != null) {
            Map components = Collections.unmodifiableMap(this.markupIdToComponent);
            Iterator it = this.listeners.iterator();
            while (it.hasNext()) {
                ((IListener)it.next()).onBeforeRespond(components, this);
            }
        }
    }

    private void fireOnAfterRespondListeners(final WebResponse response) {
        if (this.listeners != null) {
            Map components = Collections.unmodifiableMap(this.markupIdToComponent);
            IJavascriptResponse jsresponse = new IJavascriptResponse(){

                public void addJavascript(String script) {
                    AjaxRequestTarget.this.respondInvocation(response, script);
                }
            };
            Iterator it = this.listeners.iterator();
            while (it.hasNext()) {
                ((IListener)it.next()).onAfterRespond(components, jsresponse);
            }
        }
    }

    private void respondComponents(WebResponse response) {
        Iterator it = this.markupIdToComponent.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Component component = (Component)entry.getValue();
            String markupId = (String)entry.getKey();
            this.respondComponent(response, markupId, component);
        }
    }

    public String toString() {
        return "[AjaxRequestTarget@" + this.hashCode() + " markupIdToComponent [" + this.markupIdToComponent + "], prependJavascript [" + this.prependJavascripts + "], appendJavascript [" + this.appendJavascripts + "]";
    }

    protected String encode(String str) {
        if (str == null) {
            return null;
        }
        return ((Object)Strings.replaceAll(str, "]", "]^")).toString();
    }

    protected String getEncodingName() {
        return "wicket1";
    }

    protected boolean needsEncoding(String str) {
        return str.indexOf(93) >= 0;
    }

    private void respondComponent(Response response, String markupId, Component component) {
        if (component.getRenderBodyOnly()) {
            throw new IllegalStateException("Ajax render cannot be called on component that has setRenderBodyOnly enabled. Component: " + component.toString());
        }
        component.setOutputMarkupId(true);
        Response originalResponse = response;
        this.encodingBodyResponse.reset();
        RequestCycle.get().setResponse(this.encodingBodyResponse);
        Page page = component.getPage();
        if (page == null) {
            throw new IllegalStateException("Ajax request attempted on a component that is not associated with a Page");
        }
        page.startComponentRender(component);
        component.prepareForRender();
        this.respondHeaderContribution(response, component);
        component.renderComponent();
        page.endComponentRender(component);
        RequestCycle.get().setResponse(originalResponse);
        response.write("<component id=\"");
        response.write(markupId);
        response.write("\" ");
        if (this.encodingBodyResponse.isContentsEncoded()) {
            response.write(" encoding=\"");
            response.write(this.getEncodingName());
            response.write("\" ");
        }
        response.write("><![CDATA[");
        response.write(this.encodingBodyResponse.getContents());
        response.write("]]></component>");
        this.encodingBodyResponse.reset();
    }

    public IHeaderResponse getHeaderResponse() {
        if (this.headerResponse == null) {
            this.headerResponse = new AjaxHeaderResponse();
        }
        return this.headerResponse;
    }

    private void respondHeaderContribution(Response response, Component component) {
        this.headerRendering = true;
        if (this.header == null) {
            this.header = new AjaxHtmlHeaderContainer("_header_", this);
            Component oldHeader = component.getPage().get("_header_");
            if (oldHeader != null) {
                component.getPage().replace(this.header);
            } else {
                component.getPage().add(this.header);
            }
        }
        Response oldResponse = RequestCycle.get().setResponse(this.encodingHeaderResponse);
        this.encodingHeaderResponse.reset();
        component.renderHead(this.header);
        if (component instanceof MarkupContainer) {
            ((MarkupContainer)component).visitChildren(new Component.IVisitor(){

                public Object component(Component component) {
                    if (component.isVisible()) {
                        component.renderHead(AjaxRequestTarget.this.header);
                        return CONTINUE_TRAVERSAL;
                    }
                    return CONTINUE_TRAVERSAL_BUT_DONT_GO_DEEPER;
                }
            });
        }
        RequestCycle.get().setResponse(oldResponse);
        if (this.encodingHeaderResponse.getContents().length() != 0) {
            response.write("<header-contribution");
            if (this.encodingHeaderResponse.isContentsEncoded()) {
                response.write(" encoding=\"");
                response.write(this.getEncodingName());
                response.write("\" ");
            }
            response.write("><![CDATA[<head xmlns:wicket=\"http://wicket.apache.org\">");
            response.write(this.encodingHeaderResponse.getContents());
            response.write("</head>]]>");
            response.write("</header-contribution>");
        }
        this.headerRendering = false;
    }

    private void respondInvocation(Response response, String js) {
        boolean encoded = false;
        String javascript = js;
        if (this.needsEncoding(js)) {
            encoded = true;
            javascript = this.encode(js);
        }
        response.write("<evaluate");
        if (encoded) {
            response.write(" encoding=\"");
            response.write(this.getEncodingName());
            response.write("\"");
        }
        response.write(">");
        response.write("<![CDATA[");
        response.write(javascript);
        response.write("]]>");
        response.write("</evaluate>");
        this.encodingBodyResponse.reset();
    }

    public static AjaxRequestTarget get() {
        RequestCycle requestCycle = RequestCycle.get();
        if (requestCycle != null && requestCycle.getRequestTarget() instanceof AjaxRequestTarget) {
            return (AjaxRequestTarget)requestCycle.getRequestTarget();
        }
        return null;
    }

    private static class AjaxHtmlHeaderContainer
    extends HtmlHeaderContainer {
        private static final long serialVersionUID = 1L;
        private final transient AjaxRequestTarget target;

        public AjaxHtmlHeaderContainer(String id, AjaxRequestTarget target) {
            super(id);
            this.target = target;
        }

        protected IHeaderResponse newHeaderResponse() {
            return this.target.getHeaderResponse();
        }
    }

    private class AjaxHeaderResponse
    extends HeaderResponse {
        private static final long serialVersionUID = 1L;

        private void checkHeaderRendering() {
            if (!AjaxRequestTarget.this.headerRendering) {
                throw new WicketRuntimeException("Only methods that can be called on IHeaderResponse outside renderHead() are renderOnLoadJavascript and renderOnDomReadyJavascript");
            }
        }

        public void renderCSSReference(ResourceReference reference, String media) {
            this.checkHeaderRendering();
            super.renderCSSReference(reference, media);
        }

        public void renderCSSReference(String url) {
            this.checkHeaderRendering();
            super.renderCSSReference(url);
        }

        public void renderCSSReference(String url, String media) {
            this.checkHeaderRendering();
            super.renderCSSReference(url, media);
        }

        public void renderJavascript(CharSequence javascript, String id) {
            this.checkHeaderRendering();
            super.renderJavascript(javascript, id);
        }

        public void renderCSSReference(ResourceReference reference) {
            this.checkHeaderRendering();
            super.renderCSSReference(reference);
        }

        public void renderJavascriptReference(ResourceReference reference) {
            this.checkHeaderRendering();
            super.renderJavascriptReference(reference);
        }

        public void renderJavascriptReference(ResourceReference reference, String id) {
            this.checkHeaderRendering();
            super.renderJavascriptReference(reference, id);
        }

        public void renderJavascriptReference(String url) {
            this.checkHeaderRendering();
            super.renderJavascriptReference(url);
        }

        public void renderJavascriptReference(String url, String id) {
            this.checkHeaderRendering();
            super.renderJavascriptReference(url, id);
        }

        public void renderString(CharSequence string) {
            this.checkHeaderRendering();
            super.renderString(string);
        }

        public void renderOnDomReadyJavascript(String javascript) {
            List<Object> token = Arrays.asList("javascript-event", "window", "domready", javascript);
            if (!this.wasRendered(token)) {
                AjaxRequestTarget.this.domReadyJavascripts.add(javascript);
                this.markRendered(token);
            }
        }

        public void renderOnLoadJavascript(String javascript) {
            List<Object> token = Arrays.asList("javascript-event", "window", "load", javascript);
            if (!this.wasRendered(token)) {
                AjaxRequestTarget.this.appendJavascripts.add(javascript);
                this.markRendered(token);
            }
        }

        protected Response getRealResponse() {
            return RequestCycle.get().getResponse();
        }
    }

    private final class AjaxResponse
    extends WebResponse {
        private final AppendingStringBuffer buffer;
        private boolean escaped;
        private final Response originalResponse;

        public AjaxResponse(Response originalResponse) {
            super(((WebResponse)originalResponse).getHttpServletResponse());
            this.buffer = new AppendingStringBuffer(256);
            this.escaped = false;
            this.originalResponse = originalResponse;
            this.setAjax(true);
        }

        public CharSequence encodeURL(CharSequence url) {
            return this.originalResponse.encodeURL(url);
        }

        public CharSequence getContents() {
            return this.buffer;
        }

        public OutputStream getOutputStream() {
            throw new UnsupportedOperationException("Cannot get output stream on StringResponse");
        }

        public boolean isContentsEncoded() {
            return this.escaped;
        }

        public void reset() {
            this.buffer.clear();
            this.escaped = false;
        }

        public void write(CharSequence cs) {
            String string = ((Object)cs).toString();
            if (AjaxRequestTarget.this.needsEncoding(string)) {
                string = AjaxRequestTarget.this.encode(string);
                this.escaped = true;
                this.buffer.append(string);
            } else {
                this.buffer.append(cs);
            }
        }
    }

    public static interface IJavascriptResponse {
        public void addJavascript(String var1);
    }

    public static interface IListener {
        public void onBeforeRespond(Map var1, AjaxRequestTarget var2);

        public void onAfterRespond(Map var1, IJavascriptResponse var2);
    }
}

