/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.wicket.Application;
import org.apache.wicket.IClusterable;
import org.apache.wicket.IPageFactory;
import org.apache.wicket.IPageMap;
import org.apache.wicket.MetaDataEntry;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.Page;
import org.apache.wicket.PageMap;
import org.apache.wicket.Request;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.Response;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.application.IClassResolver;
import org.apache.wicket.authorization.IAuthorizationStrategy;
import org.apache.wicket.feedback.FeedbackMessages;
import org.apache.wicket.protocol.http.IgnoreAjaxRequestException;
import org.apache.wicket.request.ClientInfo;
import org.apache.wicket.session.ISessionStore;
import org.apache.wicket.util.lang.Objects;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Session
implements IClusterable {
    public static final MetaDataKey PAGEMAP_ACCESS_MDK = new MetaDataKey(PageMapAccessMetaData.class){
        private static final long serialVersionUID = 1L;
    };
    public static final String SESSION_ATTRIBUTE_NAME = "session";
    private static final ThreadLocal current = new ThreadLocal();
    private static final ThreadLocal dirtyObjects = new ThreadLocal();
    private static final Logger log = LoggerFactory.getLogger((Class)Session.class);
    private static final String pageMapAttributePrefix = "m:";
    private static final long serialVersionUID = 1L;
    private static final ThreadLocal touchedPages = new ThreadLocal();
    static final String pageMapEntryAttributePrefix = "p:";
    private int autoCreatePageMapCounter = 0;
    private ClientInfo clientInfo;
    private transient boolean dirty = false;
    private final FeedbackMessages feedbackMessages = new FeedbackMessages();
    private String id = null;
    private Locale locale;
    private MetaDataEntry[] metaData;
    private transient Map pageMapsUsedInRequest;
    private transient boolean sessionInvalidated = false;
    private transient ISessionStore sessionStore;
    private String style;
    private transient Map temporarySessionAttributes;
    private final LinkedList usedPageMaps = new LinkedList();
    private int pageIdCounter = 0;

    public static boolean exists() {
        return current.get() != null;
    }

    public static final Session findOrCreate() {
        RequestCycle requestCycle = RequestCycle.get();
        if (requestCycle == null) {
            throw new IllegalStateException("you can only locate or create sessions in the context of a request cycle");
        }
        Response response = requestCycle.getResponse();
        Request request = requestCycle.getRequest();
        return Session.findOrCreate(request, response);
    }

    public static Session findOrCreate(Request request, Response response) {
        Application application = Application.get();
        ISessionStore sessionStore = application.getSessionStore();
        Session session = sessionStore.lookup(request);
        if (session == null) {
            session = application.newSession(request, response);
        }
        Session.set(session);
        return session;
    }

    public static Session get() {
        Session session = (Session)current.get();
        if (session == null) {
            session = Session.findOrCreate();
        }
        return session;
    }

    public static void set(Session session) {
        if (session == null) {
            throw new IllegalArgumentException("Argument session can not be null");
        }
        current.set(session);
        session.attach();
    }

    public static void unset() {
        current.set(null);
    }

    public Session(Request request) {
        this.locale = request.getLocale();
        if (this.locale == null) {
            throw new IllegalArgumentException("Parameter 'locale' must not be null");
        }
    }

    protected Session(Application application, Request request) {
        this(request);
    }

    public final void bind() {
        Request request;
        if (RequestCycle.get() == null) {
            return;
        }
        ISessionStore store = this.getSessionStore();
        if (store.lookup(request = RequestCycle.get().getRequest()) == null) {
            this.id = store.getSessionId(request, true);
            store.bind(request, this);
            if (this.temporarySessionAttributes != null) {
                Iterator i = this.temporarySessionAttributes.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry entry = i.next();
                    store.setAttribute(request, String.valueOf(entry.getKey()), entry.getValue());
                }
                this.temporarySessionAttributes = null;
            }
        }
    }

    public abstract void cleanupFeedbackMessages();

    public final void clear() {
        this.visitPageMaps(new IPageMapVisitor(){

            public void pageMap(IPageMap pageMap) {
                pageMap.clear();
            }
        });
    }

    public final IPageMap createAutoPageMap() {
        return this.newPageMap(this.createAutoPageMapName());
    }

    protected int currentCreateAutoPageMapCounter() {
        return this.autoCreatePageMapCounter;
    }

    protected void incrementCreateAutoPageMapCounter() {
        ++this.autoCreatePageMapCounter;
    }

    public final synchronized String createAutoPageMapName() {
        String name = this.getAutoPageMapNamePrefix() + this.currentCreateAutoPageMapCounter() + this.getAutoPageMapNameSuffix();
        IPageMap pm = this.pageMapForName(name, false);
        while (pm != null) {
            this.incrementCreateAutoPageMapCounter();
            name = this.getAutoPageMapNamePrefix() + this.currentCreateAutoPageMapCounter() + this.getAutoPageMapNameSuffix();
            pm = this.pageMapForName(name, false);
        }
        return name;
    }

    protected String getAutoPageMapNamePrefix() {
        return "wicket-";
    }

    protected String getAutoPageMapNameSuffix() {
        return "";
    }

    public final void error(String message) {
        this.addFeedbackMessage(message, 400);
    }

    public final Application getApplication() {
        return Application.get();
    }

    public IAuthorizationStrategy getAuthorizationStrategy() {
        return this.getApplication().getSecuritySettings().getAuthorizationStrategy();
    }

    public final IClassResolver getClassResolver() {
        return this.getApplication().getApplicationSettings().getClassResolver();
    }

    public ClientInfo getClientInfo() {
        if (this.clientInfo == null) {
            this.clientInfo = RequestCycle.get().newClientInfo();
        }
        return this.clientInfo;
    }

    public final IPageMap getDefaultPageMap() {
        return this.pageMapForName(PageMap.DEFAULT_NAME, true);
    }

    public final FeedbackMessages getFeedbackMessages() {
        return this.feedbackMessages;
    }

    public final String getId() {
        if (this.id == null) {
            this.id = this.getSessionStore().getSessionId(RequestCycle.get().getRequest(), false);
            if (this.id != null) {
                this.dirty();
            }
        }
        return this.id;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public final Serializable getMetaData(MetaDataKey key) {
        return key.get(this.metaData);
    }

    protected boolean isCurrentRequestValid(RequestCycle lockedRequestCycle) {
        return true;
    }

    public final Page getPage(int pageId, int versionNumber) {
        if (!Application.get().getSessionSettings().isPageIdUniquePerSession()) {
            throw new IllegalStateException("To call this method ISessionSettings.setPageIdUniquePerSession must be set to true");
        }
        List pageMaps = this.getPageMaps();
        Iterator i = pageMaps.iterator();
        while (i.hasNext()) {
            IPageMap pm = (IPageMap)i.next();
            if (!pm.containsPage(pageId, versionNumber)) continue;
            return this.getPage(pm.getName(), "" + pageId, versionNumber);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Page getPage(String pageMapName, String path, int versionNumber) {
        IPageMap pageMap;
        if (log.isDebugEnabled()) {
            log.debug("Getting page [path = " + path + ", versionNumber = " + versionNumber + "]");
        }
        if ((pageMap = this.pageMapForName(pageMapName, pageMapName == PageMap.DEFAULT_NAME)) != null) {
            Object object = this.usedPageMaps;
            synchronized (object) {
                if (this.pageMapsUsedInRequest == null) {
                    this.pageMapsUsedInRequest = new HashMap(3);
                }
            }
            object = this.pageMapsUsedInRequest;
            synchronized (object) {
                Thread t;
                long startTime = System.currentTimeMillis();
                Duration timeout = Application.get().getRequestCycleSettings().getTimeout();
                PageMapsUsedInRequestEntry entry = (PageMapsUsedInRequestEntry)this.pageMapsUsedInRequest.get(pageMap);
                Thread thread = t = entry != null ? entry.thread : null;
                while (t != null && t != Thread.currentThread()) {
                    if (!this.isCurrentRequestValid(entry.requestCycle)) {
                        throw new IgnoreAjaxRequestException();
                    }
                    try {
                        this.pageMapsUsedInRequest.wait(timeout.getMilliseconds());
                    }
                    catch (InterruptedException ex) {
                        throw new WicketRuntimeException(ex);
                    }
                    entry = (PageMapsUsedInRequestEntry)this.pageMapsUsedInRequest.get(pageMap);
                    t = entry != null ? entry.thread : null;
                    if (t == null || t == Thread.currentThread() || startTime + timeout.getMilliseconds() >= System.currentTimeMillis()) continue;
                    throw new WicketRuntimeException("After " + timeout + " the Pagemap " + pageMapName + " is still locked by: " + t + ", giving up trying to get the page for path: " + path);
                }
                PageMapsUsedInRequestEntry newEntry = new PageMapsUsedInRequestEntry();
                newEntry.thread = Thread.currentThread();
                newEntry.requestCycle = RequestCycle.get();
                this.pageMapsUsedInRequest.put(pageMap, newEntry);
                String id = Strings.firstPathComponent(path, ':');
                Page page = pageMap.get(Integer.parseInt(id), versionNumber);
                if (page == null) {
                    this.pageMapsUsedInRequest.remove(pageMap);
                    this.pageMapsUsedInRequest.notifyAll();
                } else {
                    page.onPageAttached();
                    this.touch(page);
                }
                return page;
            }
        }
        return null;
    }

    public final IPageFactory getPageFactory() {
        return this.getApplication().getSessionSettings().getPageFactory();
    }

    public final IPageFactory getPageFactory(Page page) {
        if (page != null) {
            return page.getPageFactory();
        }
        return this.getPageFactory();
    }

    public final List getPageMaps() {
        ArrayList<Object> list = new ArrayList<Object>();
        Iterator iterator = this.getAttributeNames().iterator();
        while (iterator.hasNext()) {
            String attribute = (String)iterator.next();
            if (!attribute.startsWith(pageMapAttributePrefix)) continue;
            list.add(this.getAttribute(attribute));
        }
        return list;
    }

    public final long getSizeInBytes() {
        long size = Objects.sizeof(this);
        Iterator iterator = this.getPageMaps().iterator();
        while (iterator.hasNext()) {
            IPageMap pageMap = (IPageMap)iterator.next();
            size += pageMap.getSizeInBytes();
        }
        return size;
    }

    public final String getStyle() {
        return this.style;
    }

    public final void info(String message) {
        this.addFeedbackMessage(message, 200);
    }

    public void invalidate() {
        this.sessionInvalidated = true;
    }

    public void invalidateNow() {
        this.sessionInvalidated = true;
        this.getSessionStore().invalidate(RequestCycle.get().getRequest());
    }

    public final boolean isSessionInvalidated() {
        return this.sessionInvalidated;
    }

    public final boolean isTemporary() {
        return this.getId() == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IPageMap newPageMap(String name) {
        int maxPageMaps = this.getApplication().getSessionSettings().getMaxPageMaps();
        LinkedList linkedList = this.usedPageMaps;
        synchronized (linkedList) {
            if (this.usedPageMaps.size() >= maxPageMaps) {
                IPageMap pm = (IPageMap)this.usedPageMaps.getFirst();
                pm.remove();
            }
        }
        IPageMap pageMap = this.getSessionStore().createPageMap(name);
        this.setAttribute(this.attributeForPageMapName(name), pageMap);
        this.dirty();
        return pageMap;
    }

    public final IPageMap pageMapForName(String pageMapName, boolean autoCreate) {
        IPageMap pageMap = (IPageMap)this.getAttribute(this.attributeForPageMapName(pageMapName));
        if (pageMap == null && autoCreate) {
            pageMap = this.newPageMap(pageMapName);
        }
        return pageMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removePageMap(IPageMap pageMap) {
        PageMapAccessMetaData pagemapMetaData = (PageMapAccessMetaData)this.getMetaData(PAGEMAP_ACCESS_MDK);
        if (pagemapMetaData != null) {
            pagemapMetaData.pageMapNames.remove(pageMap.getName());
        }
        LinkedList linkedList = this.usedPageMaps;
        synchronized (linkedList) {
            this.usedPageMaps.remove(pageMap);
        }
        this.removeAttribute(this.attributeForPageMapName(pageMap.getName()));
        this.dirty();
    }

    public final void setApplication(Application application) {
    }

    public final void setClientInfo(ClientInfo clientInfo) {
        this.clientInfo = clientInfo;
        this.dirty();
    }

    public final void setLocale(Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException("Parameter 'locale' must not be null");
        }
        this.locale = locale;
        this.dirty();
    }

    public final void setMetaData(MetaDataKey key, Serializable object) {
        this.metaData = key.set(this.metaData, object);
    }

    public final Session setStyle(String style) {
        this.style = style;
        this.dirty();
        return this;
    }

    public final void touch(Page page) {
        ArrayList<Page> lst = (ArrayList<Page>)touchedPages.get();
        if (lst == null) {
            lst = new ArrayList<Page>();
            touchedPages.set(lst);
            lst.add(page);
        } else if (!lst.contains(page)) {
            lst.add(page);
        }
    }

    public final void untouch(Page page) {
        List lst = (List)touchedPages.get();
        if (lst != null) {
            lst.remove(page);
        }
    }

    public final void visitPageMaps(IPageMapVisitor visitor) {
        Iterator iterator = this.getAttributeNames().iterator();
        while (iterator.hasNext()) {
            String attribute = (String)iterator.next();
            if (!attribute.startsWith(pageMapAttributePrefix)) continue;
            visitor.pageMap((IPageMap)this.getAttribute(attribute));
        }
    }

    public final void warn(String message) {
        this.addFeedbackMessage(message, 300);
    }

    private void addFeedbackMessage(String message, int level) {
        this.getFeedbackMessages().add(null, message, level);
        this.dirty();
    }

    private final String attributeForPageMapName(String pageMapName) {
        return pageMapAttributePrefix + pageMapName;
    }

    protected void attach() {
    }

    protected void detach() {
        if (this.sessionInvalidated) {
            this.invalidateNow();
        }
    }

    public final void dirty() {
        this.dirty = true;
    }

    protected final Object getAttribute(String name) {
        if (!this.isTemporary()) {
            RequestCycle cycle = RequestCycle.get();
            if (cycle != null) {
                return this.getSessionStore().getAttribute(cycle.getRequest(), name);
            }
        } else if (this.temporarySessionAttributes != null) {
            return this.temporarySessionAttributes.get(name);
        }
        return null;
    }

    protected final List getAttributeNames() {
        if (!this.isTemporary()) {
            RequestCycle cycle = RequestCycle.get();
            if (cycle != null) {
                return this.getSessionStore().getAttributeNames(cycle.getRequest());
            }
        } else if (this.temporarySessionAttributes != null) {
            return new ArrayList(this.temporarySessionAttributes.keySet());
        }
        return Collections.EMPTY_LIST;
    }

    protected ISessionStore getSessionStore() {
        if (this.sessionStore == null) {
            this.sessionStore = this.getApplication().getSessionStore();
        }
        return this.sessionStore;
    }

    protected final void removeAttribute(String name) {
        if (!this.isTemporary()) {
            RequestCycle cycle = RequestCycle.get();
            if (cycle != null) {
                this.getSessionStore().removeAttribute(cycle.getRequest(), name);
            }
        } else if (this.temporarySessionAttributes != null) {
            this.temporarySessionAttributes.remove(name);
        }
    }

    protected final void setAttribute(String name, Object value) {
        if (!this.isTemporary()) {
            String id;
            Object current;
            RequestCycle cycle = RequestCycle.get();
            if (cycle == null) {
                throw new IllegalStateException("Cannot set the attribute: no RequestCycle available.  If you get this error when using WicketTester.startPage(Page), make sure to call WicketTester.createRequestCycle() beforehand.");
            }
            ISessionStore store = this.getSessionStore();
            Request request = cycle.getRequest();
            if (value == this && (current = store.getAttribute(request, name)) == null && (id = store.getSessionId(request, false)) != null) {
                store.bind(request, (Session)value);
            }
            store.setAttribute(request, name, value);
        } else {
            if (this.temporarySessionAttributes == null) {
                this.temporarySessionAttributes = new HashMap(3);
            }
            this.temporarySessionAttributes.put(name, value);
        }
    }

    protected final void update() {
        throw new UnsupportedOperationException();
    }

    void dirtyPage(Page page) {
        List dirtyObjects = this.getDirtyObjectsList();
        if (!dirtyObjects.contains(page)) {
            dirtyObjects.add(page);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dirtyPageMap(IPageMap map) {
        List dirtyObjects;
        if (!map.isDefault()) {
            LinkedList linkedList = this.usedPageMaps;
            synchronized (linkedList) {
                this.usedPageMaps.remove(map);
                this.usedPageMaps.addLast(map);
            }
        }
        if (!(dirtyObjects = this.getDirtyObjectsList()).contains(map)) {
            dirtyObjects.add(map);
        }
    }

    List getDirtyObjectsList() {
        ArrayList list = (ArrayList)dirtyObjects.get();
        if (list == null) {
            list = new ArrayList(4);
            dirtyObjects.set(list);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void requestDetached() {
        List touchedPages = (List)Session.touchedPages.get();
        Session.touchedPages.set(null);
        if (touchedPages != null) {
            for (int i = 0; i < touchedPages.size(); ++i) {
                Page page = (Page)touchedPages.get(i);
                page.getPageMap().put(page);
            }
        }
        if (this.dirty) {
            this.dirty = false;
            this.setAttribute(SESSION_ATTRIBUTE_NAME, this);
        } else if (log.isDebugEnabled()) {
            log.debug("update: Session not dirty.");
        }
        List dirtyObjects = (List)Session.dirtyObjects.get();
        Session.dirtyObjects.set(null);
        HashMap tempMap = new HashMap();
        if (dirtyObjects != null) {
            Iterator iterator = dirtyObjects.iterator();
            while (iterator.hasNext()) {
                String attribute = null;
                Object object = iterator.next();
                if (object instanceof Page) {
                    Page page = (Page)object;
                    if (page.isStateless() || this.getAttribute(attribute = page.getPageMap().attributeForId(page.getNumericId())) == null) continue;
                    object = page.getPageMapEntry();
                } else if (object instanceof IPageMap) {
                    attribute = this.attributeForPageMapName(((IPageMap)object).getName());
                }
                tempMap.put(attribute, object);
            }
        }
        if (!tempMap.isEmpty()) {
            Iterator i = tempMap.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                this.setAttribute((String)entry.getKey(), entry.getValue());
            }
        }
        if (this.pageMapsUsedInRequest != null) {
            Map map = this.pageMapsUsedInRequest;
            synchronized (map) {
                Thread t = Thread.currentThread();
                Iterator it = this.pageMapsUsedInRequest.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    if (((PageMapsUsedInRequestEntry)entry.getValue()).thread != t) continue;
                    it.remove();
                }
                this.pageMapsUsedInRequest.notifyAll();
            }
        }
    }

    protected synchronized int nextPageId() {
        return this.pageIdCounter++;
    }

    private static class PageMapsUsedInRequestEntry {
        Thread thread;
        RequestCycle requestCycle;

        private PageMapsUsedInRequestEntry() {
        }
    }

    public static final class PageMapAccessMetaData
    implements IClusterable {
        private static final long serialVersionUID = 1L;
        Set pageMapNames = new HashSet(2);

        public boolean add(IPageMap pagemap) {
            return this.pageMapNames.add(pagemap.getName());
        }
    }

    public static interface IPageMapVisitor {
        public void pageMap(IPageMap var1);
    }
}

