/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.net.URLConnection;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletContext;
import org.apache.wicket.Application;
import org.apache.wicket.IResponseFilter;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.util.io.Streams;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Response {
    private static final Logger log = LoggerFactory.getLogger((Class)Response.class);
    private String defaultEncoding;

    public void close() {
    }

    public void reset() {
    }

    public CharSequence encodeURL(CharSequence url) {
        return url;
    }

    public final AppendingStringBuffer filter(AppendingStringBuffer responseBuffer) {
        List responseFilters = Application.get().getRequestCycleSettings().getResponseFilters();
        if (responseFilters == null) {
            return responseBuffer;
        }
        for (int i = 0; i < responseFilters.size(); ++i) {
            IResponseFilter filter = (IResponseFilter)responseFilters.get(i);
            responseBuffer = filter.filter(responseBuffer);
        }
        return responseBuffer;
    }

    public String getCharacterEncoding() {
        if (this.defaultEncoding == null) {
            return Application.get().getRequestCycleSettings().getResponseRequestEncoding();
        }
        return this.defaultEncoding;
    }

    public abstract OutputStream getOutputStream();

    public boolean isRedirect() {
        return false;
    }

    public void redirect(String url) {
    }

    public void setCharacterEncoding(String encoding) {
        this.defaultEncoding = encoding;
    }

    public void setContentLength(long length) {
    }

    public void setContentType(String mimeType) {
    }

    public void setLastModifiedTime(Time time) {
    }

    public void setLocale(Locale locale) {
    }

    public final void write(ComponentTag tag) {
        this.write(tag.toString());
    }

    public abstract void write(CharSequence var1);

    private void handleException(Exception e) {
        boolean ignoreException = false;
        for (Throwable throwable = e; throwable != null && !(throwable instanceof SQLException); throwable = throwable.getCause()) {
            if (throwable instanceof SocketException) {
                String message = throwable.getMessage();
                ignoreException = message != null && (message.indexOf("Connection reset") != -1 || message.indexOf("Broken pipe") != -1 || message.indexOf("Socket closed") != -1 || message.indexOf("connection abort") != -1);
            } else {
                boolean bl = ignoreException = throwable.getClass().getName().indexOf("ClientAbortException") >= 0 || throwable.getClass().getName().indexOf("EofException") >= 0;
            }
            if (!ignoreException) continue;
            if (!log.isDebugEnabled()) break;
            log.debug("Socket exception ignored for sending Resource response to client (ClientAbort)", (Throwable)e);
            break;
        }
        if (!ignoreException) {
            throw new WicketRuntimeException("Unable to write the response", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void write(InputStream in) {
        block8: {
            OutputStream out = this.getOutputStream();
            Streams.copy(in, out);
            Object var5_3 = null;
            try {
                in.close();
                out.flush();
            }
            catch (IOException e2) {
                this.handleException(e2);
            }
            break block8;
            {
                catch (Exception e) {
                    this.handleException(e);
                    Object var5_4 = null;
                    try {
                        in.close();
                        out.flush();
                    }
                    catch (IOException e2) {
                        this.handleException(e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                try {
                    in.close();
                    out.flush();
                }
                catch (IOException e2) {
                    this.handleException(e2);
                }
                throw throwable;
            }
        }
    }

    public final void println(CharSequence string) {
        this.write(string);
        this.write(Strings.LINE_SEPARATOR);
    }

    public void detectContentType(RequestCycle requestCycle, String uri) {
        ServletContext context = ((WebApplication)requestCycle.getApplication()).getServletContext();
        String contentType = context.getMimeType(uri);
        if (contentType == null) {
            contentType = URLConnection.getFileNameMap().getContentTypeFor(uri);
        }
        if (contentType != null) {
            this.setContentType(contentType + "; charset=" + this.getCharacterEncoding());
        }
    }
}

