/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket;

import java.io.Serializable;
import java.util.Iterator;
import org.apache.wicket.AbortException;
import org.apache.wicket.AbstractRestartResponseException;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.IPageMap;
import org.apache.wicket.IRedirectListener;
import org.apache.wicket.IRequestTarget;
import org.apache.wicket.MetaDataEntry;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.Page;
import org.apache.wicket.PageMap;
import org.apache.wicket.PageParameters;
import org.apache.wicket.Request;
import org.apache.wicket.RequestListenerInterface;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.Response;
import org.apache.wicket.Session;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.protocol.http.BufferedWebResponse;
import org.apache.wicket.protocol.http.IRequestLogger;
import org.apache.wicket.protocol.http.PageExpiredException;
import org.apache.wicket.protocol.http.servlet.ServletWebRequest;
import org.apache.wicket.request.ClientInfo;
import org.apache.wicket.request.IRequestCycleProcessor;
import org.apache.wicket.request.RequestParameters;
import org.apache.wicket.request.target.component.BookmarkableListenerInterfaceRequestTarget;
import org.apache.wicket.request.target.component.BookmarkablePageRequestTarget;
import org.apache.wicket.request.target.component.ComponentRequestTarget;
import org.apache.wicket.request.target.component.IBookmarkablePageRequestTarget;
import org.apache.wicket.request.target.component.IPageRequestTarget;
import org.apache.wicket.request.target.component.PageRequestTarget;
import org.apache.wicket.request.target.component.listener.BehaviorRequestTarget;
import org.apache.wicket.request.target.component.listener.ListenerInterfaceRequestTarget;
import org.apache.wicket.request.target.resource.SharedResourceRequestTarget;
import org.apache.wicket.util.collections.ArrayListStack;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.time.Time;
import org.apache.wicket.util.value.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RequestCycle {
    private static final ThreadLocal current = new ThreadLocal();
    private static final int DETACH_REQUEST = 5;
    private static final int DONE = 6;
    private static final Logger log = LoggerFactory.getLogger((Class)RequestCycle.class);
    private static final int NOT_STARTED = 0;
    private static final int PREPARE_REQUEST = 1;
    private static final int PROCESS_EVENTS = 3;
    private static final int RESOLVE_TARGET = 2;
    private static final int RESPOND = 4;
    private boolean automaticallyClearFeedbackMessages = true;
    private int currentStep = 0;
    private boolean handlingException = false;
    private final Response originalResponse;
    private boolean redirect;
    private final transient ArrayListStack requestTargets = new ArrayListStack(3);
    private PageParameters pageParameters;
    private Session session;
    private final long startTime = System.currentTimeMillis();
    protected final Application application;
    protected final IRequestCycleProcessor processor;
    protected Request request;
    protected Response response;
    private transient boolean urlForNewWindowEncoding;
    private MetaDataEntry[] metaData;

    public static RequestCycle get() {
        return (RequestCycle)current.get();
    }

    protected static void set(RequestCycle cycle) {
        current.set(cycle);
    }

    protected RequestCycle(Application application, Request request, Response response) {
        this.application = application;
        this.request = request;
        this.response = response;
        this.originalResponse = response;
        this.processor = this.safeGetRequestProcessor();
        current.set(this);
    }

    public final Application getApplication() {
        return this.application;
    }

    public final ClientInfo getClientInfo() {
        return this.getSession().getClientInfo();
    }

    public final Response getOriginalResponse() {
        return this.originalResponse;
    }

    public final PageParameters getPageParameters() {
        return this.pageParameters;
    }

    public abstract IRequestCycleProcessor getProcessor();

    public final boolean getRedirect() {
        return this.isRedirect();
    }

    public final Request getRequest() {
        return this.request;
    }

    public final IRequestTarget getRequestTarget() {
        return !this.requestTargets.isEmpty() ? (IRequestTarget)this.requestTargets.peek() : null;
    }

    public final Response getResponse() {
        return this.response;
    }

    public final Page getResponsePage() {
        IRequestTarget target = this.getRequestTarget();
        if (target instanceof IPageRequestTarget) {
            return ((IPageRequestTarget)target).getPage();
        }
        if (target instanceof BookmarkablePageRequestTarget) {
            return ((BookmarkablePageRequestTarget)target).getPage();
        }
        return null;
    }

    public final Class getResponsePageClass() {
        IRequestTarget target = this.getRequestTarget();
        if (target != null && target instanceof IBookmarkablePageRequestTarget) {
            return ((IBookmarkablePageRequestTarget)target).getPageClass();
        }
        return null;
    }

    public final Session getSession() {
        if (this.session == null) {
            this.session = Session.get();
        }
        return this.session;
    }

    public final long getStartTime() {
        return this.startTime;
    }

    public boolean isRedirect() {
        return this.redirect;
    }

    public Page onRuntimeException(Page page, RuntimeException e) {
        return null;
    }

    public abstract void redirectTo(Page var1);

    public final void request() {
        this.checkReuse();
        this.currentStep = 1;
        this.steps();
    }

    public final void request(Component component) {
        this.checkReuse();
        if (component.isAuto()) {
            throw new WicketRuntimeException("Auto-added components can not be re-rendered");
        }
        this.request(new ComponentRequestTarget(component));
    }

    public final void request(IRequestTarget target) {
        this.checkReuse();
        this.requestTargets.push(target);
        this.currentStep = 3;
        this.steps();
    }

    public void setAutomaticallyClearFeedbackMessages(boolean automaticallyClearFeedbackMessages) {
        this.automaticallyClearFeedbackMessages = automaticallyClearFeedbackMessages;
    }

    public final void setRedirect(boolean redirect) {
        this.redirect = redirect;
    }

    public final void setRequest(Request request) {
        this.request = request;
    }

    public final void setRequestTarget(IRequestTarget requestTarget) {
        if (log.isDebugEnabled()) {
            if (!this.requestTargets.isEmpty()) {
                IRequestTarget former = (IRequestTarget)this.requestTargets.peek();
                log.debug("replacing request target " + former + " with " + requestTarget);
            } else {
                log.debug("setting request target to " + requestTarget);
            }
        }
        if (this.currentStep >= 4) {
            if (log.isDebugEnabled()) {
                log.debug("rewinding request processing to PROCESS_EVENTS");
            }
            this.currentStep = 3;
        }
        this.requestTargets.push(requestTarget);
    }

    public final Response setResponse(Response response) {
        Response orig = this.response;
        this.response = response;
        return orig;
    }

    private String getCurrentPageMap() {
        IRequestTarget target = RequestCycle.get().getRequestTarget();
        if (target instanceof IPageRequestTarget) {
            Page page = ((IPageRequestTarget)target).getPage();
            return page != null ? page.getPageMapName() : null;
        }
        if (target instanceof IBookmarkablePageRequestTarget) {
            return ((IBookmarkablePageRequestTarget)target).getPageMapName();
        }
        return null;
    }

    public final void setResponsePage(Class pageClass) {
        this.setResponsePage(pageClass, null);
    }

    public final void setResponsePage(Class pageClass, PageParameters pageParameters) {
        this.setResponsePage(pageClass, pageParameters, this.getCurrentPageMap());
    }

    public final void setResponsePage(Class pageClass, PageParameters pageParameters, String pageMapName) {
        BookmarkablePageRequestTarget target = new BookmarkablePageRequestTarget(pageMapName, pageClass, pageParameters);
        this.setRequestTarget(target);
    }

    public final void setResponsePage(Page page) {
        PageRequestTarget target = new PageRequestTarget(page);
        this.setRequestTarget(target);
    }

    public String toString() {
        return "[RequestCycle@" + Integer.toHexString(this.hashCode()) + " thread=" + Thread.currentThread().getName() + "]";
    }

    public final boolean isUrlForNewWindowEncoding() {
        return this.urlForNewWindowEncoding;
    }

    public final void setUrlForNewWindowEncoding() {
        this.urlForNewWindowEncoding = true;
    }

    private final CharSequence encodeUrlFor(IRequestTarget requestTarget) {
        CharSequence url = this.getProcessor().getRequestCodingStrategy().encode(this, requestTarget);
        this.urlForNewWindowEncoding = false;
        return url;
    }

    public final CharSequence urlFor(Class pageClass, PageParameters parameters) {
        return this.urlFor(null, pageClass, parameters);
    }

    public final CharSequence urlFor(Component component, IBehavior behaviour, RequestListenerInterface listener) {
        int index = component.getBehaviors().indexOf(behaviour);
        if (index == -1) {
            throw new IllegalArgumentException("Behavior " + this + " was not registered with this component: " + component.toString());
        }
        RequestParameters params = new RequestParameters();
        params.setBehaviorId(String.valueOf(index));
        if (this.request instanceof ServletWebRequest) {
            ServletWebRequest swr = (ServletWebRequest)this.request;
            int urlDepth = swr.getRequestParameters().getUrlDepth();
            params.setUrlDepth(urlDepth > -1 ? urlDepth : swr.getDepthRelativeToWicketHandler());
        }
        BehaviorRequestTarget target = new BehaviorRequestTarget(component.getPage(), component, listener, params);
        return this.encodeUrlFor(target);
    }

    public final CharSequence urlFor(Component component, RequestListenerInterface listener) {
        IRequestTarget target;
        Page page = component.getPage();
        if (listener != IRedirectListener.INTERFACE && component.isStateless() && page.isBookmarkable()) {
            PageParameters pageParameters = page.getPageParameters();
            if (pageParameters == null) {
                pageParameters = new PageParameters();
            }
            target = new BookmarkableListenerInterfaceRequestTarget(page.getPageMapName(), page.getClass(), pageParameters, component, listener);
        } else {
            page.setPageStateless(Boolean.FALSE);
            Session session = this.getSession();
            if (session.isTemporary()) {
                session.bind();
            }
            target = new ListenerInterfaceRequestTarget(page, component, listener);
        }
        return this.encodeUrlFor(target);
    }

    public final CharSequence urlFor(IPageMap pageMap, Class pageClass, PageParameters parameters) {
        BookmarkablePageRequestTarget target = new BookmarkablePageRequestTarget(pageMap == null ? PageMap.DEFAULT_NAME : pageMap.getName(), pageClass, parameters);
        return this.encodeUrlFor(target);
    }

    public final CharSequence urlFor(IRequestTarget requestTarget) {
        return this.encodeUrlFor(requestTarget);
    }

    public final CharSequence urlFor(Page page) {
        PageRequestTarget target = new PageRequestTarget(page);
        this.getSession().touch(((IPageRequestTarget)target).getPage());
        return this.encodeUrlFor(target);
    }

    public final CharSequence urlFor(ResourceReference resourceReference) {
        return this.urlFor(resourceReference, null);
    }

    public final CharSequence urlFor(ResourceReference resourceReference, ValueMap parameters) {
        Time time;
        RequestParameters requestParameters = new RequestParameters();
        requestParameters.setResourceKey(resourceReference.getSharedResourceKey());
        if (this.getApplication().getResourceSettings().getAddLastModifiedTimeToResourceReferenceUrl() && !Strings.isEmpty(resourceReference.getName()) && (time = resourceReference.lastModifiedTime()) != null && parameters == null) {
            parameters = new ValueMap();
            parameters.put("wicket:lm", new Long(time.getMilliseconds()));
        }
        requestParameters.setParameters(parameters);
        return this.encodeUrlFor(new SharedResourceRequestTarget(requestParameters));
    }

    private void checkReuse() {
        if (this.currentStep != 0) {
            this.detach();
            throw new WicketRuntimeException("RequestCycles are non-reusable objects. This instance (" + this + ") already executed");
        }
    }

    public void detach() {
        Iterator iter = this.requestTargets.iterator();
        while (iter.hasNext()) {
            IRequestTarget target = (IRequestTarget)iter.next();
            if (target == null) continue;
            try {
                target.detach(this);
            }
            catch (RuntimeException e) {
                log.error("there was an error cleaning up target " + target + ".", (Throwable)e);
            }
        }
        if (this.automaticallyClearFeedbackMessages) {
            try {
                if (this.sessionExists()) {
                    this.getSession().cleanupFeedbackMessages();
                }
            }
            catch (RuntimeException re) {
                log.error("there was an error cleaning up the feedback messages", (Throwable)re);
            }
        }
        try {
            IRequestLogger requestLogger = this.getApplication().getRequestLogger();
            if (requestLogger != null) {
                requestLogger.requestTime(System.currentTimeMillis() - this.startTime);
            }
        }
        catch (RuntimeException re) {
            log.error("there was an error in the RequestLogger ending.", (Throwable)re);
        }
        if (this.sessionExists()) {
            try {
                this.getSession().requestDetached();
            }
            catch (RuntimeException re) {
                log.error("there was an error detaching the request from the session " + this.session + ".", (Throwable)re);
            }
        }
        if (this.getResponse() instanceof BufferedWebResponse) {
            try {
                ((BufferedWebResponse)this.getResponse()).filter();
            }
            catch (RuntimeException re) {
                log.error("there was an error filtering the response.", (Throwable)re);
            }
        }
        try {
            this.onEndRequest();
        }
        catch (RuntimeException e) {
            log.error("Exception occurred during onEndRequest", (Throwable)e);
        }
        try {
            this.getApplication().getSessionStore().onEndRequest(this.getRequest());
        }
        catch (RuntimeException e) {
            log.error("Exception occurred during onEndRequest of the SessionStore", (Throwable)e);
        }
        try {
            this.threadDetach();
        }
        catch (RuntimeException re) {
            log.error("Exception occurred during threadDetach", (Throwable)re);
        }
    }

    private void prepare() {
        try {
            this.getApplication().getSessionStore().onBeginRequest(this.getRequest());
        }
        catch (RuntimeException e) {
            log.error("Exception occurred during onEndRequest of the SessionStore", (Throwable)e);
        }
        this.onBeginRequest();
    }

    private final void processEventsAndRespond() {
        this.processor.processEvents(this);
        this.currentStep = 4;
        this.processor.respond(this);
    }

    private final void respond() {
        this.processor.respond(this);
    }

    private final IRequestCycleProcessor safeGetRequestProcessor() {
        IRequestCycleProcessor processor = this.getProcessor();
        if (processor == null) {
            throw new WicketRuntimeException("request cycle processor must be not-null");
        }
        return processor;
    }

    private boolean sessionExists() {
        return Session.exists();
    }

    private final void step() {
        try {
            switch (this.currentStep) {
                case 1: {
                    this.prepare();
                    break;
                }
                case 2: {
                    IRequestTarget target = this.processor.resolve(this, this.request.getRequestParameters());
                    if (target == null) {
                        throw new WicketRuntimeException("the processor did not resolve to any request target");
                    }
                    this.requestTargets.add(0, target);
                    break;
                }
                case 3: {
                    this.processEventsAndRespond();
                    break;
                }
                case 4: {
                    this.respond();
                    break;
                }
            }
        }
        catch (AbortException e) {
            throw e;
        }
        catch (RuntimeException e) {
            if (!this.handlingException) {
                this.handlingException = true;
                if (!(e instanceof PageExpiredException)) {
                    this.logRuntimeException(e);
                }
                if (this.processor != null) {
                    this.processor.respond(e, this);
                }
            }
            log.error("unexpected exception when handling another exception: " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void steps() {
        try {
            int maxSteps = 100;
            int totalSteps = 0;
            while (this.currentStep < 6) {
                if (totalSteps >= 100) {
                    throw new IllegalStateException("Request processing executed 100 steps, which means it is probably in an infinite loop.");
                }
                try {
                    this.step();
                    ++this.currentStep;
                }
                catch (AbstractRestartResponseException e) {
                    this.currentStep = 4;
                }
                ++totalSteps;
            }
        }
        finally {
            this.currentStep = 5;
            this.detach();
            this.currentStep = 6;
        }
    }

    private final void threadDetach() {
        if (this.sessionExists()) {
            try {
                this.getSession().detach();
            }
            catch (RuntimeException re) {
                log.error("there was an error detaching the session", (Throwable)re);
            }
        }
        if (this.isRedirect()) {
            this.setRedirect(false);
        }
        current.set(null);
    }

    final void setPageParameters(PageParameters parameters) {
        if (this.currentStep == 2) {
            this.pageParameters = parameters;
        }
    }

    protected void logRuntimeException(RuntimeException e) {
        log.error(e.getMessage(), (Throwable)e);
    }

    protected abstract ClientInfo newClientInfo();

    protected void onBeginRequest() {
    }

    protected void onEndRequest() {
    }

    public final void setMetaData(MetaDataKey key, Serializable object) {
        this.metaData = key.set(this.metaData, object);
    }

    public final Serializable getMetaData(MetaDataKey key) {
        return key.get(this.metaData);
    }
}

