/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import com.sun.midp.lcdui.DynamicCharacterArray;
import com.sun.midp.lcdui.InputMethodClient;
import com.sun.midp.lcdui.InputMethodHandler;
import com.sun.midp.lcdui.PhoneDial;
import com.sun.midp.lcdui.Text;
import com.sun.midp.lcdui.TextCursor;
import com.sun.midp.lcdui.TextPolicy;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.Screen;

public class TextField
extends Item {
    public static final int ANY = 0;
    public static final int EMAILADDR = 1;
    public static final int NUMERIC = 2;
    public static final int PHONENUMBER = 3;
    public static final int URL = 4;
    public static final int DECIMAL = 5;
    public static final int PASSWORD = 65536;
    public static final int UNEDITABLE = 131072;
    public static final int SENSITIVE = 262144;
    public static final int NON_PREDICTIVE = 524288;
    public static final int INITIAL_CAPS_WORD = 0x100000;
    public static final int INITIAL_CAPS_SENTENCE = 0x200000;
    public static final int CONSTRAINT_MASK = 65535;
    private boolean firstTimeInTraverse = true;
    private boolean editable;
    private static int BORDER_PAD = 2;
    DynamicCharacterArray buffer;
    TextCursor cursor;
    char currentInputChar;
    int oldNumChars;
    boolean multiLine;
    boolean hasBorder;
    boolean usePreferredX = true;
    String initialInputMode = null;
    InputMethodHandler inputHandler = null;
    InputMethodClientImpl inputClient = null;
    private boolean ignoreNextKeyEntered;
    private char[] inputChars = new char[2];
    private static final int FRONT_PART = 0;
    private static final int LAST_PART = 1;
    private static final int LAST_LABEL_PART_INDEX = 1;
    private String[] cachedLabelParts = new String[2];
    private int[] cachedLabelPartWidths = new int[2];
    private int[] cachedLabelPartHeights = new int[2];
    private int[] cachedReqLabelPartW = new int[2];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextField(String label, String text, int maxSize, int constraints) {
        super(label);
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.initializeLabelParts(label);
            this.buffer = new DynamicCharacterArray(maxSize);
            this.cursor = new TextCursor(0);
            this.cursor.visible = false;
            this.hasBorder = true;
            this.inputHandler = InputMethodHandler.getInputMethodHandler();
            this.inputClient = new InputMethodClientImpl();
            this.setConstraints(constraints);
            this.inputClient.setInputMethodHandler(this.inputHandler);
            this.inputHandler.setInputMethodClient(this.inputClient);
            this.setString(text);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString() {
        Object object = Display.LCDUILock;
        synchronized (object) {
            return this.buffer.toString();
        }
    }

    public void setString(String text) {
        if (text == null) {
            this.setChars(null, 0, 0);
        } else {
            this.setChars(text.toCharArray(), 0, text.length());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChars(char[] data) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            try {
                this.buffer.getChars(0, this.buffer.length(), data, 0);
            }
            catch (IndexOutOfBoundsException e) {
                throw new ArrayIndexOutOfBoundsException(e.getMessage());
            }
            return this.buffer.length();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChars(char[] data, int offset, int length) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            if (data == null) {
                this.buffer.delete(0, this.buffer.length());
                this.cursor.index = 0;
                this.cursor.option = 0;
            } else {
                if (offset < 0 || offset > data.length || length < 0 || length > data.length || offset + length < 0 || offset + length > data.length) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                if (length > this.buffer.capacity()) {
                    throw new IllegalArgumentException();
                }
                if (length > 0) {
                    DynamicCharacterArray dca = new DynamicCharacterArray(length);
                    dca.set(data, offset, length);
                    if (!TextPolicy.isValidString(dca, this.inputClient.getConstraints())) {
                        throw new IllegalArgumentException();
                    }
                }
                this.buffer.set(data, offset, length);
                this.cursor.index = this.buffer.length();
                this.cursor.option = 0;
            }
            this.invalidate();
        }
    }

    public void insert(String src, int position) {
        this.insert(src.toCharArray(), 0, src.length(), position);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(char[] data, int offset, int length, int position) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            int pos = this.buffer.insert(data, offset, length, position);
            if (!TextPolicy.isValidString(this.buffer, this.inputClient.getConstraints())) {
                this.buffer.delete(pos, length);
                throw new IllegalArgumentException();
            }
            if (position <= this.cursor.index) {
                this.cursor.index += length;
                this.cursor.option = 0;
            }
            this.invalidate();
        }
    }

    private void insert(char ch, int position) {
        char[] chArray = new char[]{ch};
        this.insert(chArray, 0, 1, position);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(int offset, int length) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            if (length == 0) {
                return;
            }
            String str = this.buffer.toString();
            this.buffer.delete(offset, length);
            if (!TextPolicy.isValidString(this.buffer, this.inputClient.getConstraints())) {
                this.buffer.delete(0, this.buffer.length());
                this.buffer.insert(0, str);
                throw new IllegalArgumentException();
            }
            if (this.cursor.index >= offset) {
                int diff = this.cursor.index - offset;
                this.cursor.index = this.cursor.index - (diff < length ? diff : length);
                this.cursor.option = 0;
            }
            this.invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxSize() {
        Object object = Display.LCDUILock;
        synchronized (object) {
            return this.buffer.capacity();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setMaxSize(int maxSize) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            int oldCapacity = this.buffer.capacity();
            this.buffer.setCapacity(maxSize);
            if (!TextPolicy.isValidString(this.buffer, this.inputClient.getConstraints())) {
                this.buffer.setCapacity(oldCapacity);
                throw new IllegalArgumentException();
            }
            this.invalidate();
            return this.buffer.capacity();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = Display.LCDUILock;
        synchronized (object) {
            return this.buffer.length();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCaretPosition() {
        Object object = Display.LCDUILock;
        synchronized (object) {
            return this.cursor.index;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConstraints(int constraints) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            if ((constraints & 0xFFFF) < 0 || (constraints & 0xFFFF) > 5) {
                throw new IllegalArgumentException();
            }
            if (this.inputClient.setConstraints(constraints) && !TextPolicy.isValidString(this.buffer, constraints)) {
                this.delete(0, this.buffer.length());
            }
            this.editable = (0x20000 & constraints) != 131072;
            this.multiLine = (constraints & 0xFFFF) != 3;
            this.invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConstraints() {
        Object object = Display.LCDUILock;
        synchronized (object) {
            return this.inputClient.getConstraints();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInitialInputMode(String characterSubset) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.initialInputMode = characterSubset;
        }
    }

    void commitPendingInteraction() {
        this.inputHandler.endComposition(false);
    }

    boolean equateNLA() {
        if (super.equateNLA()) {
            return true;
        }
        return (this.layout & 0x4000) != 16384;
    }

    boolean equateNLB() {
        if (super.equateNLB()) {
            return true;
        }
        return (this.layout & 0x4000) != 16384;
    }

    int callMinimumWidth() {
        if ((this.layout == 0 || this.equateNLB() && this.equateNLA()) && this.owner != null) {
            return this.owner.getWidth();
        }
        return Screen.CONTENT_FONT.charWidth('W') * 8 + 2 * BORDER_PAD + 1;
    }

    int callPreferredWidth(int h) {
        int labelAndTextW;
        int frontLabelPartW = this.getLabelPartWidth(0);
        int textW = Screen.CONTENT_FONT.charWidth('W') * this.buffer.capacity();
        textW += 2 * BORDER_PAD + 1;
        int labelW = this.getLabelPartWidth(1);
        if (labelW > 0) {
            labelW += 2;
        }
        return (labelAndTextW = textW + labelW) > frontLabelPartW ? labelAndTextW : frontLabelPartW;
    }

    int callMinimumHeight() {
        return this.callPreferredHeight(-1);
    }

    int callPreferredHeight(int w) {
        if (w == -1) {
            w = DEFAULT_WIDTH;
        }
        boolean isCompact = w >= this.callPreferredWidth(-1);
        int h = this.getLabelPartHeight(0, w) + 2 * BORDER_PAD;
        h = this.buffer.length() == 0 ? (h += Screen.CONTENT_HEIGHT) : (h += Text.getHeightForWidth(TextPolicy.getDisplayString(this.buffer, this.currentInputChar, this.inputClient.getConstraints(), this.inputHandler, this.cursor), Screen.CONTENT_FONT, w - (2 * BORDER_PAD + 1), 0));
        if (!isCompact) {
            h += this.getLabelPartHeight(1, w);
        }
        return h;
    }

    void callPaint(Graphics g, int width, int height) {
        boolean isCompact = width >= this.callPreferredWidth(-1);
        int frontLabelPartHeight = this.getLabelPartHeight(0, width);
        if (g.getClipY() < frontLabelPartHeight) {
            this.paintLabelPart(g, 0, width);
        }
        g.translate(0, frontLabelPartHeight);
        height -= frontLabelPartHeight;
        int labelHeight = this.getLabelPartHeight(1, width);
        int labelWidth = this.getLabelPartWidth(1);
        if (labelWidth > 0) {
            labelWidth += 2;
        }
        if (g.getClipY() < labelHeight) {
            if (isCompact) {
                g.translate(0, 2);
            }
            this.paintLabelPart(g, 1, width);
            if (isCompact) {
                g.translate(0, -2);
            }
        }
        if (isCompact) {
            width -= labelWidth;
            g.translate(labelWidth, 0);
        } else {
            height -= labelHeight;
            g.translate(0, labelHeight);
        }
        if (this.hasBorder) {
            if (!this.hasFocus) {
                g.setColor(0xAFAFAF);
            }
            g.drawRect(0, 0, width - 1, height - 1);
        }
        g.setColor(this.editable ? Display.FG_COLOR : 0xAFAFAF);
        g.translate(BORDER_PAD + 1, BORDER_PAD);
        TextPolicy.paint(this.buffer, this.currentInputChar, this.inputClient.getConstraints(), this.inputHandler, Screen.CONTENT_FONT, g, width - (2 * BORDER_PAD + 1), height, 0, 0, this.cursor);
        g.translate(-(BORDER_PAD + 1), -BORDER_PAD);
        if (isCompact) {
            g.translate(-labelWidth, 0);
        } else {
            g.translate(0, -labelHeight);
        }
        g.translate(0, -frontLabelPartHeight);
        g.setColor(Display.FG_COLOR);
        if (this.usePreferredX) {
            this.cursor.preferredX = this.cursor.x;
        }
    }

    void validateCursor() {
        TextPolicy.paint(this.buffer, this.currentInputChar, this.inputClient.getConstraints(), this.inputHandler, Screen.CONTENT_FONT, null, this.bounds[2] - (2 * BORDER_PAD + 1), this.bounds[3], 0, 0, this.cursor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void keyEntered(int keyCode) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.oldNumChars = this.buffer.length();
            this.cursor.visible = true;
            this.currentInputChar = '\u0000';
            switch (keyCode) {
                case -3: {
                    if (this.buffer.length() <= 0) break;
                    this.delete(0, this.buffer.length());
                    this.notifyStateChanged();
                    break;
                }
                case -2: {
                    try {
                        if (this.cursor.index <= 0) break;
                        this.delete(this.cursor.index - 1, 1);
                        this.validateCursor();
                        this.notifyStateChanged();
                    }
                    catch (IllegalArgumentException e) {
                        if (this.buffer.length() <= 0) break;
                        this.delete(0, this.buffer.length());
                        this.notifyStateChanged();
                    }
                    break;
                }
                case -4: {
                    try {
                        if (this.buffer.length() <= 0) break;
                        if (this.buffer.charAt(0) == '-') {
                            this.delete(0, 1);
                        } else {
                            this.insert('-', 0);
                        }
                        this.notifyStateChanged();
                    }
                    catch (IllegalArgumentException e) {
                        AlertType.WARNING.playSound(this.owner.currentDisplay);
                    }
                    break;
                }
                default: {
                    try {
                        int inputLength = 0;
                        if ((this.inputClient.getConstraints() & 0xFFFF) == 5 && keyCode == 46 && this.buffer.length() == 0) {
                            this.inputChars[inputLength] = 48;
                            ++inputLength;
                        }
                        this.inputChars[inputLength] = (char)keyCode;
                        this.insert(this.inputChars, 0, ++inputLength, this.cursor.index);
                        this.validateCursor();
                        this.notifyStateChanged();
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        AlertType.WARNING.playSound(this.owner.currentDisplay);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callKeyPressed(int keyCode) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            if (Display.getSystemKey(keyCode) == 2) {
                if ((this.inputClient.getConstraints() & 0xFFFF) == 3) {
                    PhoneDial.call(this.getString());
                }
                return;
            }
            if (!this.editable) {
                AlertType.WARNING.playSound(this.owner.currentDisplay);
                return;
            }
            int key = this.inputHandler.keyPressed(keyCode);
            if (key != -1) {
                if (this.buffer.length() == this.buffer.capacity()) {
                    AlertType.WARNING.playSound(this.owner.currentDisplay);
                    this.inputHandler.flush();
                    return;
                }
                this.currentInputChar = (char)key;
                this.cursor.visible = false;
                this.invalidate();
                this.validateCursor();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callKeyReleased(int keyCode) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.inputHandler.keyReleased(keyCode);
        }
    }

    void callKeyRepeated(int keyCode) {
        this.callKeyPressed(keyCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callKeyTyped(char c) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            if (!this.editable) {
                AlertType.WARNING.playSound(this.owner.currentDisplay);
                return;
            }
            this.inputHandler.keyTyped(c);
        }
    }

    boolean moveCursor(int dir) {
        boolean keyUsed = false;
        switch (dir) {
            case 2: {
                if (this.cursor.index <= 0) break;
                --this.cursor.index;
                this.cursor.option = 0;
                keyUsed = true;
                break;
            }
            case 5: {
                if (this.cursor.index >= this.buffer.length()) break;
                ++this.cursor.index;
                this.cursor.option = 0;
                keyUsed = true;
                break;
            }
            case 1: {
                if (!this.multiLine) break;
                this.cursor.y -= Screen.CONTENT_FONT.getHeight();
                if (this.cursor.y > 0) {
                    this.cursor.option = 1;
                    keyUsed = true;
                    break;
                }
                this.cursor.y += Screen.CONTENT_FONT.getHeight();
                break;
            }
            case 6: {
                if (!this.multiLine) break;
                this.cursor.y += Screen.CONTENT_FONT.getHeight();
                boolean isCompact = this.bounds[2] >= this.callPreferredWidth(-1);
                int height = this.bounds[3];
                height -= this.getLabelPartHeight(0, this.bounds[2]);
                if (!isCompact) {
                    height -= this.getLabelPartHeight(1, this.bounds[2]);
                }
                if (this.cursor.y < height) {
                    this.cursor.option = 1;
                    keyUsed = true;
                    break;
                }
                this.cursor.y -= Screen.CONTENT_FONT.getHeight();
            }
        }
        return keyUsed;
    }

    boolean callTraverse(int dir, int viewportWidth, int viewportHeight, int[] visRect_inout) {
        super.callTraverse(dir, viewportWidth, viewportHeight, visRect_inout);
        boolean ret = false;
        boolean bl = this.usePreferredX = dir != 1 && dir != 6;
        if (this.firstTimeInTraverse || dir == 0) {
            if (this.firstTimeInTraverse) {
                this.inputClient.setInputMode(this.initialInputMode);
                this.inputHandler.setInputMethodClient(this.inputClient);
                this.cursor.option = 0;
                this.cursor.visible = this.editable;
                this.firstTimeInTraverse = false;
            }
            this.repaint();
            if (this.owner.currentDisplay != null) {
                this.owner.currentDisplay.serviceRepaints(this.owner);
            }
            ret = true;
        } else {
            this.inputHandler.endComposition(false);
            if (this.moveCursor(dir)) {
                this.repaint();
                if (this.owner.currentDisplay != null) {
                    this.owner.currentDisplay.serviceRepaints(this.owner);
                }
                ret = true;
            }
        }
        visRect_inout[0] = this.cursor.x;
        visRect_inout[1] = this.cursor.y - this.cursor.height;
        boolean isCompact = visRect_inout[2] >= this.callPreferredWidth(-1);
        visRect_inout[1] = visRect_inout[1] + this.getLabelPartHeight(0, visRect_inout[2]);
        if (!isCompact) {
            visRect_inout[1] = visRect_inout[1] + this.getLabelPartHeight(1, visRect_inout[2]);
        }
        visRect_inout[2] = this.cursor.width;
        visRect_inout[3] = this.cursor.height + BORDER_PAD + 2;
        return ret;
    }

    void callTraverseOut() {
        super.callTraverseOut();
        this.firstTimeInTraverse = true;
        this.inputHandler.clearInputMethodClient(this.inputClient);
        try {
            this.owner.currentDisplay.setInputMode(0);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.cursor.option = 0;
        this.cursor.index = this.buffer.length();
        this.cursor.visible = false;
        this.repaint();
    }

    void callHideNotify() {
        this.firstTimeInTraverse = true;
    }

    void setBorder(boolean state) {
        this.hasBorder = state;
    }

    private String getLabelPart(int index) {
        return this.cachedLabelParts[index];
    }

    private int getLabelPartWidth(int index) {
        if (this.cachedLabelParts[index] == null || this.cachedLabelParts[index].length() == 0) {
            return 0;
        }
        if (this.cachedLabelPartWidths[index] == 0) {
            this.cachedLabelPartWidths[index] = Text.getWidestLineWidth(this.cachedLabelParts[index].toCharArray(), 0, DEFAULT_WIDTH, LABEL_FONT);
        }
        return this.cachedLabelPartWidths[index];
    }

    private int getLabelPartHeight(int index, int w) {
        if (this.cachedLabelParts[index] == null || this.cachedLabelParts[index].length() == 0) {
            return 0;
        }
        if (w == -1) {
            w = DEFAULT_WIDTH;
        }
        if (this.cachedReqLabelPartW[index] != w || this.cachedLabelPartHeights[index] == 0) {
            this.cachedReqLabelPartW[index] = w;
            this.cachedLabelPartHeights[index] = Text.getHeightForWidth(this.cachedLabelParts[index], LABEL_FONT, w, 0);
        }
        return this.cachedLabelPartHeights[index];
    }

    private void initializeLabelParts(String label) {
        int index;
        int n = index = label != null ? label.lastIndexOf(10) : -1;
        if (index == -1) {
            this.cachedLabelParts[0] = null;
            this.cachedLabelParts[1] = label;
        } else {
            this.cachedLabelParts[0] = index > 0 ? label.substring(0, index) : " ";
            this.cachedLabelParts[1] = label.substring(index + 1, label.length());
        }
        this.cachedLabelPartWidths[0] = 0;
        this.cachedLabelPartWidths[1] = 0;
        this.cachedLabelPartHeights[0] = 0;
        this.cachedLabelPartHeights[1] = 0;
    }

    private int paintLabelPart(Graphics g, int index, int width) {
        int labelHeight = this.getLabelPartHeight(index, width);
        Text.paint(this.cachedLabelParts[index], LABEL_FONT, g, width, labelHeight, 0, 0, null);
        return labelHeight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLabel(String label) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            super.setLabel(label);
            this.initializeLabelParts(label);
        }
    }

    private class InputMethodClientImpl
    implements InputMethodClient {
        private InputMethodHandler imh = null;
        private int constraints = 0;
        private String inputMode = null;
        private String[] allowedModes = null;

        private InputMethodClientImpl() {
        }

        public void setInputMethodHandler(InputMethodHandler imh) {
            this.imh = imh;
        }

        public void setInputMode(String inputMode) {
            this.inputMode = inputMode;
        }

        public String getInputMode() {
            return this.inputMode;
        }

        public void setAllowedModes(String[] allowedModes) {
            this.allowedModes = new String[allowedModes.length];
            System.arraycopy(allowedModes, 0, this.allowedModes, 0, allowedModes.length);
        }

        public String[] getAllowedModes() {
            return this.allowedModes;
        }

        public int getConstraints() {
            return this.constraints;
        }

        public boolean setConstraints(int constraints) {
            this.constraints = constraints;
            if (this.imh != null) {
                return this.imh.setConstraints(constraints);
            }
            return true;
        }

        public void keyEntered(int keyCode) {
            TextField.this.keyEntered(keyCode);
        }

        public void showInputMode(int mode) {
            if (TextField.this.hasFocus && TextField.this.owner.currentDisplay != null) {
                TextField.this.owner.currentDisplay.setInputMode(mode);
            }
        }

        public Display getDisplay() {
            return TextField.this.owner.currentDisplay;
        }

        public void setCurrent(Displayable displayable, Display display) {
            TextField.this.owner.resetToTop = false;
            display.setCurrent(displayable);
        }

        public boolean isNewWord() {
            if (TextField.this.buffer.length() == 0) {
                return true;
            }
            return TextField.this.cursor.index > 0 && (TextField.this.buffer.charAt(TextField.this.cursor.index - 1) == ' ' || TextField.this.buffer.charAt(TextField.this.cursor.index - 1) == '\n' || TextField.this.buffer.charAt(TextField.this.cursor.index - 1) == '\t');
        }

        public boolean isNewSentence() {
            if (TextField.this.buffer.length() == 0) {
                return true;
            }
            if (TextField.this.cursor.index > 0 && TextField.this.buffer.charAt(TextField.this.cursor.index - 1) != ' ' && TextField.this.buffer.charAt(TextField.this.cursor.index - 1) != '\n' && TextField.this.buffer.charAt(TextField.this.cursor.index - 1) != '\t') {
                return false;
            }
            for (int i = TextField.this.cursor.index - 2; i >= 0; --i) {
                if (TextField.this.buffer.charAt(i) == '.') {
                    return true;
                }
                if (TextField.this.buffer.charAt(i) == ' ' || TextField.this.buffer.charAt(i) == '\n' || TextField.this.buffer.charAt(i) == '\t') continue;
                return false;
            }
            return true;
        }

        public boolean isNewInputEntry() {
            return TextField.this.buffer.length() == 0 && TextField.this.oldNumChars != 0;
        }
    }
}

