/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import com.sun.midp.lcdui.Text;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.ImmutableImage;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;

public class ImageItem
extends Item {
    public static final int LAYOUT_DEFAULT = 0;
    public static final int LAYOUT_LEFT = 1;
    public static final int LAYOUT_RIGHT = 2;
    public static final int LAYOUT_CENTER = 3;
    public static final int LAYOUT_NEWLINE_BEFORE = 256;
    public static final int LAYOUT_NEWLINE_AFTER = 512;
    private Image img;
    private Image mutImg;
    private String altText;
    private int vertPad;
    private int appearanceMode;
    private int originalAppearanceMode;
    private static final int HYPERLINK_PAD = 3;
    private static final Image HYPERLINK_IMG;
    private static final Image VERTICAL_HYPERLINK_IMG;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageItem(String label, Image img, int layout, String altText) {
        super(label);
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.setImageImpl(img);
            this.setLayoutImpl(layout);
            this.altText = altText;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageItem(String label, Image image, int layout, String altText, int appearanceMode) {
        this(label, image, layout, altText);
        Object object = Display.LCDUILock;
        synchronized (object) {
            switch (appearanceMode) {
                case 0: 
                case 1: 
                case 2: {
                    this.appearanceMode = appearanceMode;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getImage() {
        Object object = Display.LCDUILock;
        synchronized (object) {
            return this.mutImg == null ? this.img : this.mutImg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImage(Image img) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.setImageImpl(img);
            this.invalidate();
        }
    }

    public String getAltText() {
        return this.altText;
    }

    public void setAltText(String text) {
        this.altText = text;
    }

    public int getLayout() {
        return super.getLayout();
    }

    public void setLayout(int layout) {
        super.setLayout(layout);
    }

    public int getAppearanceMode() {
        return this.appearanceMode;
    }

    int callMinimumWidth() {
        return this.callPreferredWidth(-1);
    }

    int callPreferredWidth(int h) {
        int imageW;
        int labelWidth;
        if (this.img == null) {
            return this.getLabelWidth();
        }
        if (this.numCommands >= 1) {
            if (this.appearanceMode == 2) {
                return this.img.getWidth() + 10;
            }
            if (this.appearanceMode == 1) {
                return this.img.getWidth() + (VERTICAL_HYPERLINK_IMG.getWidth() + 3) * 2;
            }
        }
        return (labelWidth = this.getLabelWidth()) > (imageW = this.img.getWidth()) ? labelWidth : imageW;
    }

    int callMinimumHeight() {
        return this.callPreferredHeight(-1);
    }

    int callPreferredHeight(int w) {
        if (this.img == null) {
            return this.getLabelHeight(w);
        }
        if (this.numCommands >= 1) {
            if (this.appearanceMode == 2) {
                return this.img.getHeight() + this.getLabelHeight(w) + 10;
            }
            if (this.appearanceMode == 1) {
                return this.img.getHeight() + this.getLabelHeight(w) + (HYPERLINK_IMG.getHeight() + 3) * 2;
            }
        }
        return this.img.getHeight() + this.getLabelHeight(w);
    }

    void callPaint(Graphics g, int width, int height) {
        int labelHeight = super.paintLabel(g, width);
        if (this.img == null) {
            return;
        }
        int x = 0;
        int y = labelHeight;
        int l = this.getLayout() & 3;
        if (l == 3) {
            x = width / 2;
            if (this.numCommands >= 1 && this.appearanceMode == 2) {
                x += 5;
                y += 5;
            } else if (this.numCommands >= 1 && this.appearanceMode == 1) {
                x += VERTICAL_HYPERLINK_IMG.getWidth() + 3;
                y += HYPERLINK_IMG.getHeight() + 3;
            }
            g.drawImage(this.img, x, y, 17);
        } else if (l == 2) {
            x = width;
            if (this.numCommands >= 1 && this.appearanceMode == 2) {
                x -= 5;
                y += 5;
            } else if (this.numCommands >= 1 && this.appearanceMode == 1) {
                x -= VERTICAL_HYPERLINK_IMG.getWidth() + 3;
                y += HYPERLINK_IMG.getHeight() + 3;
            }
            g.drawImage(this.img, x, y, 24);
        } else {
            if (this.numCommands >= 1 && this.appearanceMode == 2) {
                x += 5;
                y += 5;
            } else if (this.numCommands >= 1 && this.appearanceMode == 1) {
                x += VERTICAL_HYPERLINK_IMG.getWidth() + 3;
                y += HYPERLINK_IMG.getHeight() + 3;
            }
            g.drawImage(this.img, x, y, 20);
        }
        if (this.numCommands >= 1 && this.appearanceMode == 2) {
            int w = this.img.getWidth();
            int h = this.img.getHeight();
            y = labelHeight;
            x = l == 3 ? width / 2 - w / 2 : (l == 2 ? width - w - 10 : 0);
            this.drawButtonBorder(g, x, y, w += 10, h += 10, this.hasFocus);
        } else if (this.numCommands >= 1 && this.appearanceMode == 1) {
            int imageItemWidth = this.img.getWidth();
            int imageItemHeight = this.img.getHeight();
            y = labelHeight;
            if (l == 3) {
                this.drawTop_BottomBorder(g, width / 2 - imageItemWidth / 2 - 3 - VERTICAL_HYPERLINK_IMG.getWidth(), width / 2 + imageItemWidth / 2 + 6, y, y + HYPERLINK_IMG.getHeight() + imageItemHeight + 6);
                this.drawLeft_RightBorder(g, y, y + imageItemHeight + 6, width / 2 - imageItemWidth / 2 - VERTICAL_HYPERLINK_IMG.getHeight(), width / 2 + imageItemWidth / 2 + 6);
            } else if (l == 2) {
                this.drawTop_BottomBorder(g, width - imageItemWidth - 6 - VERTICAL_HYPERLINK_IMG.getWidth(), width - VERTICAL_HYPERLINK_IMG.getWidth(), y, y + HYPERLINK_IMG.getHeight() + imageItemHeight + 6);
                this.drawLeft_RightBorder(g, y, y + imageItemHeight + 6, width - imageItemWidth - 3 - VERTICAL_HYPERLINK_IMG.getHeight(), width - VERTICAL_HYPERLINK_IMG.getWidth());
            } else {
                this.drawTop_BottomBorder(g, 0, imageItemWidth + 6, y, y + HYPERLINK_IMG.getHeight() + imageItemHeight + 6);
                this.drawLeft_RightBorder(g, y, y + imageItemHeight + 6, 0, HYPERLINK_IMG.getHeight() + imageItemWidth + 6);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callKeyPressed(int keyCode) {
        if (keyCode != Display.KEYCODE_SELECT) {
            return;
        }
        if (this.getCommandCount() == 0 || this.commandListener == null) {
            return;
        }
        ItemCommandListener cl = null;
        Command defaultCmd = null;
        Object object = Display.LCDUILock;
        synchronized (object) {
            cl = this.commandListener;
            defaultCmd = this.defaultCommand;
        }
        if (cl != null) {
            try {
                object = Display.calloutLock;
                synchronized (object) {
                    if (defaultCmd != null) {
                        cl.commandAction(defaultCmd, this);
                    }
                }
            }
            catch (Throwable thr) {
                Display.handleThrowable(thr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addCommandImpl(Command cmd) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            super.addCommandImpl(cmd);
            if (this.numCommands >= 1 && this.appearanceMode == 0 && this.commandListener != null) {
                this.appearanceMode = this.originalAppearanceMode == 2 ? 2 : 1;
                this.invalidate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeCommandImpl(Command cmd) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            super.removeCommandImpl(cmd);
            if ((this.numCommands < 1 || this.commandListener == null) && this.appearanceMode != 0) {
                this.originalAppearanceMode = this.appearanceMode;
                this.appearanceMode = 0;
                this.invalidate();
            }
        }
    }

    boolean shouldSkipTraverse() {
        return (this.label == null || this.label.length() == 0) && this.img == null;
    }

    private void setImageImpl(Image img) {
        if (img != null && img.isMutable()) {
            this.mutImg = img;
            this.img = Image.createImage(img);
        } else {
            this.mutImg = null;
            this.img = img;
        }
    }

    private void setAltTextImpl(String text) {
        this.altText = text;
    }

    private void drawTop_BottomBorder(Graphics g, int start, int end, int y1, int y2) {
        for (int x = start; x < end; x += HYPERLINK_IMG.getWidth()) {
            g.drawImage(HYPERLINK_IMG, x, y1, 20);
            g.drawImage(HYPERLINK_IMG, x, y2, 20);
        }
    }

    private void drawLeft_RightBorder(Graphics g, int start, int end, int x1, int x2) {
        for (int y = start; y < end; y += VERTICAL_HYPERLINK_IMG.getHeight()) {
            g.drawImage(VERTICAL_HYPERLINK_IMG, x1, y, 20);
            g.drawImage(VERTICAL_HYPERLINK_IMG, x2, y, 20);
        }
    }

    void setItemCommandListenerImpl(ItemCommandListener l) {
        ItemCommandListener tempCL = this.commandListener;
        super.setItemCommandListenerImpl(l);
        if (l == null && tempCL != null) {
            this.originalAppearanceMode = this.appearanceMode;
            this.appearanceMode = 0;
            this.invalidate();
        } else if (this.numCommands >= 1 && l != null && this.appearanceMode == 0) {
            this.appearanceMode = this.originalAppearanceMode == 2 ? 2 : 1;
            this.invalidate();
        }
    }

    static {
        VERTICAL_HYPERLINK_IMG = ImmutableImage.createIcon("link_vertical.png");
        Text.HYPERLINK_IMG = HYPERLINK_IMG = ImmutableImage.createIcon("link_horizontal.png");
    }
}

