/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.ImmutableImage;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.game.Sprite;

public class Gauge
extends Item {
    public static final int INDEFINITE = -1;
    public static final int CONTINUOUS_IDLE = 0;
    public static final int INCREMENTAL_IDLE = 1;
    public static final int CONTINUOUS_RUNNING = 2;
    public static final int INCREMENTAL_UPDATING = 3;
    private Sprite spriteInUse;
    private Sprite INCREMENTAL_SPRITE;
    private Sprite CONTINUOUS_SPRITE;
    private static final Image LEFTARROW_IMG;
    private static final Image RIGHTARROW_IMG;
    private static final Image INCREMENTAL_IMG;
    private static final Image CONTINUOUS_IMG;
    private static final int[] IDLE_SEQUENCE;
    private static final int[] ACTIVE_SEQUENCE;
    private int value;
    private int maxValue = 0;
    private boolean interactive;
    private int blockCount = -1;
    private boolean traversedIn;
    private static final int DEFAULT_WIDTH = 78;
    private static final int BLOCK_SPACE = 8;
    private static final int GAUGE_HEIGHT = 25;
    private int valueOfEachBlock;
    private boolean drawLeftArrow;
    private boolean drawRightArrow;
    private int arrowWidth;
    private int blockMargin;
    private static Timer gaugeUpdateTimer;
    private GaugeUpdateTask updateHelper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Gauge(String label, boolean interactive, int maxValue, int initialValue) {
        super(label);
        if (maxValue == -1 && (initialValue < 0 || initialValue > 3)) {
            throw new IllegalArgumentException();
        }
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.interactive = interactive;
            this.arrowWidth = this.interactive ? LEFTARROW_IMG.getWidth() + 6 : 0;
            this.blockMargin = 2 + this.arrowWidth;
            this.setMaxValueImpl(maxValue);
            this.setValue(initialValue);
        }
    }

    public void setLabel(String label) {
        if (this.owner instanceof Alert) {
            throw new IllegalStateException("Gauge contained within an Alert");
        }
        super.setLabel(label);
    }

    public void setLayout(int layout) {
        if (this.owner instanceof Alert) {
            throw new IllegalStateException("Gauge contained within an Alert");
        }
        super.setLayout(layout);
    }

    public void addCommand(Command cmd) {
        if (this.owner instanceof Alert) {
            throw new IllegalStateException("Gauge contained within an Alert");
        }
        super.addCommand(cmd);
    }

    public void setItemCommandListener(ItemCommandListener l) {
        if (this.owner instanceof Alert) {
            throw new IllegalStateException("Gauge contained within an Alert");
        }
        super.setItemCommandListener(l);
    }

    public void setPreferredSize(int width, int height) {
        if (this.owner instanceof Alert) {
            throw new IllegalStateException("Gauge contained within an Alert");
        }
        super.setPreferredSize(width, height);
    }

    public void setDefaultCommand(Command cmd) {
        if (this.owner instanceof Alert) {
            throw new IllegalStateException("Gauge contained within an Alert");
        }
        super.setDefaultCommand(cmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(int value) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            if (!this.interactive && this.maxValue == -1) {
                if (value != 2 && this.value == 2) {
                    this.cancelGaugeUpdateTask();
                }
                switch (value) {
                    case 0: {
                        this.spriteInUse = this.CONTINUOUS_SPRITE;
                        this.spriteInUse.setFrameSequence(IDLE_SEQUENCE);
                        break;
                    }
                    case 1: {
                        this.spriteInUse = this.INCREMENTAL_SPRITE;
                        this.spriteInUse.setFrameSequence(IDLE_SEQUENCE);
                        break;
                    }
                    case 3: {
                        if (this.spriteInUse != this.INCREMENTAL_SPRITE || this.spriteInUse.getFrameSequenceLength() == 1) {
                            this.spriteInUse = this.INCREMENTAL_SPRITE;
                            this.spriteInUse.setFrameSequence(ACTIVE_SEQUENCE);
                            break;
                        }
                        this.spriteInUse.nextFrame();
                        break;
                    }
                    case 2: {
                        if (this.spriteInUse != this.CONTINUOUS_SPRITE || this.spriteInUse.getFrameSequenceLength() == 1) {
                            this.spriteInUse = this.CONTINUOUS_SPRITE;
                            this.spriteInUse.setFrameSequence(ACTIVE_SEQUENCE);
                        }
                        if (this.updateHelper != null) break;
                        this.startGaugeUpdateTask(this.spriteInUse);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
            this.value = value;
            this.checkValue();
            this.repaint();
        }
    }

    public int getValue() {
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxValue(int maxValue) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.setMaxValueImpl(maxValue);
        }
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    boolean equateNLA() {
        if (super.equateNLA()) {
            return true;
        }
        return (this.layout & 0x4000) != 16384;
    }

    boolean equateNLB() {
        if (super.equateNLB()) {
            return true;
        }
        return (this.layout & 0x4000) != 16384;
    }

    int callMinimumWidth() {
        return 78;
    }

    int callPreferredWidth(int h) {
        return Math.max(78, this.getLabelWidth());
    }

    int callMinimumHeight() {
        return this.callPreferredHeight(-1);
    }

    int callPreferredHeight(int w) {
        if (this.maxValue == -1) {
            return this.INCREMENTAL_SPRITE.getHeight() + this.getLabelHeight(w);
        }
        return 25 + this.getLabelHeight(w) + 2;
    }

    boolean callTraverse(int dir, int viewportWidth, int viewportHeight, int[] visRect) {
        super.callTraverse(dir, viewportWidth, viewportHeight, visRect);
        if (!this.traversedIn) {
            this.traversedIn = true;
            return true;
        }
        if (this.interactive) {
            switch (dir) {
                case 2: 
                case 5: {
                    this.modifyValue(dir);
                    return true;
                }
                case 1: 
                case 6: {
                    return false;
                }
            }
        }
        return false;
    }

    void callTraverseOut() {
        super.callTraverseOut();
        this.traversedIn = false;
    }

    void callPaint(Graphics g, int w, int h) {
        if (this.blockCount == -1) {
            this.setBlockCountAndValue(w);
        }
        int clipX = g.getClipX();
        int labelHeight = super.paintLabel(g, w);
        g.translate(0, labelHeight);
        if (this.maxValue == -1) {
            this.spriteInUse.paint(g);
        } else {
            int RGBdrawColor;
            if (this.hasFocus) {
                RGBdrawColor = Display.FG_COLOR;
            } else {
                g.setColor(0x606060);
                RGBdrawColor = 0x606060;
            }
            this.setGaugeArrows();
            if (this.interactive && clipX < this.blockMargin) {
                if (this.drawLeftArrow) {
                    g.drawImage(LEFTARROW_IMG, 2, 12, 6);
                } else {
                    g.setColor(Display.ERASE_COLOR);
                    g.fillRect(0, 2, this.arrowWidth, 25);
                    g.setColor(RGBdrawColor);
                }
            }
            int startBlock = this.blockCount;
            int stopBlock = this.blockCount;
            if (clipX - this.blockMargin < this.blockCount * 8) {
                startBlock = (clipX - this.blockMargin) / 8;
                int n = startBlock = startBlock < 0 ? 0 : startBlock;
                if (clipX + g.getClipWidth() > this.blockMargin) {
                    stopBlock = (clipX + g.getClipWidth() - this.blockMargin) / 8;
                    stopBlock = ++stopBlock > this.blockCount ? this.blockCount : stopBlock;
                }
            }
            int bc = this.blockCount - 1;
            int bc2 = bc * bc;
            for (int i = startBlock; i < stopBlock; ++i) {
                int blockHeight = 25;
                if (this.interactive && this.blockCount > 1) {
                    blockHeight = 5 + (i * (bc - i) << 1) / bc2 + 20 * (i * i) / bc2;
                }
                if (this.valueOfEachBlock * (i + 1) > this.value && this.value != this.maxValue) {
                    if (this.hasFocus) {
                        g.drawRect(this.blockMargin + i * 8, 25 - blockHeight, 5, blockHeight);
                        continue;
                    }
                    g.setStrokeStyle(1);
                    g.drawRect(this.blockMargin + i * 8, 25 - blockHeight, 5, blockHeight);
                    g.setStrokeStyle(0);
                    continue;
                }
                g.fillRect(this.blockMargin + i * 8, 25 - blockHeight, 6, blockHeight + 1);
            }
            if (this.interactive) {
                if (this.drawRightArrow) {
                    g.drawImage(RIGHTARROW_IMG, this.blockMargin + this.blockCount * 8 + this.arrowWidth / 2, 12, 3);
                } else {
                    g.setColor(Display.ERASE_COLOR);
                    g.fillRect(this.blockMargin + this.blockCount * 8 + this.arrowWidth / 2, 0, this.arrowWidth, 25);
                    g.setColor(RGBdrawColor);
                }
            }
            if (!this.hasFocus) {
                g.setColor(Display.FG_COLOR);
            }
        }
        g.translate(0, -labelHeight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void modifyValue(int dir) {
        Displayable form = null;
        Object object = Display.LCDUILock;
        synchronized (object) {
            int blockToRepaint = -1;
            int oldValue = this.value++;
            if (dir == 2) {
                if (this.value % this.valueOfEachBlock == 0) {
                    blockToRepaint = this.value / this.valueOfEachBlock - 1;
                } else if (this.value == this.maxValue) {
                    blockToRepaint = this.blockCount - 1;
                }
                --this.value;
            } else if (this.value % this.valueOfEachBlock == 0) {
                blockToRepaint = this.value / this.valueOfEachBlock - 1;
            } else if (this.value == this.maxValue) {
                blockToRepaint = this.blockCount - 1;
            }
            this.checkValue();
            int blockY = this.getLabelHeight(this.bounds[2]);
            if (this.value != oldValue) {
                if (blockToRepaint < this.blockCount) {
                    this.repaint(this.blockMargin + blockToRepaint * 8, blockY, 8, 27);
                }
                if (blockToRepaint <= 0) {
                    this.repaint(2, blockY, this.arrowWidth, 25);
                }
                if (blockToRepaint >= this.blockCount - 1) {
                    this.repaint(this.blockMargin + this.blockCount * 8, blockY, this.arrowWidth, 25);
                }
                form = (Form)this.getOwner();
            }
        }
        if (form != null) {
            form.itemStateChanged(this);
        }
    }

    void callShowNotify() {
        if (this.maxValue == -1 && this.value == 2 && this.updateHelper == null) {
            this.setValue(2);
        }
        this.visible = true;
    }

    void callHideNotify() {
        if (this.updateHelper != null) {
            this.cancelGaugeUpdateTask();
        }
        this.visible = false;
    }

    private void initSprites() {
        this.INCREMENTAL_SPRITE = new Sprite(INCREMENTAL_IMG, 44, 45);
        this.CONTINUOUS_SPRITE = new Sprite(CONTINUOUS_IMG, 29, 33);
    }

    private void setBlockCountAndValue(int width) {
        this.blockCount = (width - 2 * this.arrowWidth) / 8;
        if (this.maxValue != -1) {
            if (this.blockCount > this.maxValue) {
                this.blockCount = this.maxValue;
            }
            this.valueOfEachBlock = 1;
            if (this.maxValue <= this.blockCount) {
                return;
            }
            try {
                this.valueOfEachBlock = this.maxValue / this.blockCount;
                if (this.maxValue % this.blockCount != 0) {
                    ++this.valueOfEachBlock;
                }
                this.blockCount = this.maxValue / this.valueOfEachBlock;
                if (this.maxValue % this.valueOfEachBlock != 0) {
                    ++this.blockCount;
                }
            }
            catch (ArithmeticException arithmeticException) {
                // empty catch block
            }
        }
    }

    private void setGaugeArrows() {
        if (this.hasFocus && this.interactive) {
            int scrollPosition = this.value * 100 / this.maxValue;
            if (this.value > 0 && scrollPosition == 0) {
                scrollPosition = 1;
            }
            if (0 < this.value && this.value < this.maxValue) {
                this.drawRightArrow = true;
                this.drawLeftArrow = true;
            } else if (this.value == 0) {
                this.drawLeftArrow = false;
                this.drawRightArrow = true;
            } else {
                this.drawLeftArrow = true;
                this.drawRightArrow = false;
            }
        } else {
            this.drawRightArrow = false;
            this.drawLeftArrow = false;
        }
    }

    private void checkValue() {
        if (this.maxValue == -1) {
            if (this.value < 0 || this.value > 3) {
                this.value = 0;
            }
        } else if (this.value < 0) {
            this.value = 0;
        } else if (this.value > this.maxValue) {
            this.value = this.maxValue;
        }
    }

    private void setMaxValueImpl(int maxValue) {
        if (maxValue <= 0 && (this.interactive || maxValue != -1)) {
            throw new IllegalArgumentException();
        }
        int oldMaxValue = this.maxValue;
        this.maxValue = maxValue;
        if (oldMaxValue == -1) {
            if (maxValue > -1) {
                this.value = 0;
                this.blockCount = -1;
            }
        } else if (maxValue == -1) {
            this.value = 0;
            if (this.spriteInUse == null) {
                this.initSprites();
            }
            this.spriteInUse = this.CONTINUOUS_SPRITE;
            this.spriteInUse.setFrameSequence(IDLE_SEQUENCE);
        }
        this.checkValue();
        this.blockCount = -1;
        this.invalidate();
    }

    private void startGaugeUpdateTask(Sprite sprite) {
        this.updateHelper = new GaugeUpdateTask(sprite, this);
        gaugeUpdateTimer.schedule((TimerTask)this.updateHelper, 250L, 250L);
    }

    private void cancelGaugeUpdateTask() {
        if (this.updateHelper != null) {
            this.updateHelper.cancel();
            this.updateHelper = null;
        }
    }

    static {
        IDLE_SEQUENCE = new int[]{4};
        ACTIVE_SEQUENCE = new int[]{0, 1, 2, 3};
        gaugeUpdateTimer = new Timer();
        LEFTARROW_IMG = ImmutableImage.createIcon("gauge_leftarrow.png");
        RIGHTARROW_IMG = ImmutableImage.createIcon("gauge_rightarrow.png");
        CONTINUOUS_IMG = ImmutableImage.createIcon("continuous_strip.png");
        INCREMENTAL_IMG = ImmutableImage.createIcon("incremental_strip.png");
    }

    private class GaugeUpdateTask
    extends TimerTask {
        private Sprite mySprite;
        private Gauge myGauge;

        GaugeUpdateTask(Sprite sprite, Gauge gauge) {
            this.mySprite = sprite;
            this.myGauge = gauge;
        }

        public final void run() {
            this.mySprite.nextFrame();
            this.myGauge.repaint();
        }
    }
}

