/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import com.sun.midp.lcdui.DisplayAccess;
import com.sun.midp.lcdui.DisplayDeviceAccess;
import com.sun.midp.lcdui.DisplayManager;
import com.sun.midp.lcdui.DisplayManagerFactory;
import com.sun.midp.lcdui.EmulEventHandler;
import com.sun.midp.lcdui.EventHandler;
import com.sun.midp.lcdui.GameMap;
import com.sun.midp.lcdui.MIDletEventListener;
import com.sun.midp.lcdui.SystemEventListener;
import com.sun.midp.lcdui.Text;
import com.sun.midp.main.Configuration;
import com.sun.midp.midlet.MIDletState;
import com.sun.midp.midlet.MIDletStateMap;
import com.sun.midp.midlet.MIDletSuite;
import com.sun.midp.midlet.Scheduler;
import com.sun.midp.security.SecurityToken;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.DeviceCaps;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.ImmutableImage;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.Screen;
import javax.microedition.lcdui.TextBox;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.midlet.MIDlet;

public class Display {
    public static final int LIST_ELEMENT = 1;
    public static final int CHOICE_GROUP_ELEMENT = 2;
    public static final int ALERT = 3;
    public static final int COLOR_BACKGROUND = 0;
    public static final int COLOR_FOREGROUND = 1;
    public static final int COLOR_HIGHLIGHTED_BACKGROUND = 2;
    public static final int COLOR_HIGHLIGHTED_FOREGROUND = 3;
    public static final int COLOR_BORDER = 4;
    public static final int COLOR_HIGHLIGHTED_BORDER = 5;
    static final Object LCDUILock = new Object();
    static final Object calloutLock = new Object();
    static final int WIDTH;
    static final int HEIGHT;
    static final int ADORNEDHEIGHT;
    static final int ERASE_COLOR;
    static final int BORDER_COLOR = 0xAFAFAF;
    static final int BORDER_H_COLOR = 0x606060;
    static final int DISPLAY_DEPTH;
    static final boolean DISPLAY_IS_COLOR;
    static final boolean POINTER_SUPPORTED;
    static final boolean MOTION_SUPPORTED;
    static final boolean REPEAT_SUPPORTED;
    static final boolean IS_DOUBLE_BUFFERED;
    static final int FG_COLOR;
    static final int BG_H_COLOR;
    static final int FG_H_COLOR;
    static final int ALPHA_LEVELS;
    static final int KEYCODE_UP;
    static final int KEYCODE_DOWN;
    static final int KEYCODE_LEFT;
    static final int KEYCODE_RIGHT;
    static final int KEYCODE_SELECT;
    private static DisplayManagerImpl displayManagerImpl;
    private static DisplayDeviceAccess deviceAccess;
    private static EventHandler eventHandler;
    private static final Graphics screenGraphics;
    private DisplayAccessor accessor;
    private MIDlet midlet;
    private Displayable current;
    private boolean wantsForeground;
    private int stickyKeyMask;
    private int currentKeyMask;
    private MIDletEventListener midletEventListener;
    private boolean paintSuspended;
    private boolean hasForeground;
    private static Vector queue1;
    private static Vector queue2;
    private static Vector currentQueue;
    private static SecurityToken classSecurityToken;

    Display(MIDlet m) {
        this.midlet = m;
        this.accessor = new DisplayAccessor();
        this.drawTrustedIcon(false);
    }

    public static Display getDisplay(MIDlet m) {
        Object object = LCDUILock;
        synchronized (object) {
            Display d;
            MIDletState ms = MIDletStateMap.getState(m);
            if (ms != null && (d = ms.getDisplay()) != null) {
                return d;
            }
            throw new IllegalStateException("No display created for given MIDlet");
        }
    }

    public int getColor(int colorSpecifier) {
        switch (colorSpecifier) {
            case 0: {
                return ERASE_COLOR;
            }
            case 1: {
                return FG_COLOR;
            }
            case 2: {
                return BG_H_COLOR;
            }
            case 3: {
                return FG_H_COLOR;
            }
            case 4: {
                return 0xAFAFAF;
            }
            case 5: {
                return 0x606060;
            }
        }
        throw new IllegalArgumentException();
    }

    public int getBorderStyle(boolean highlighted) {
        return highlighted ? 0 : 1;
    }

    public boolean isColor() {
        return DISPLAY_IS_COLOR;
    }

    public int numColors() {
        return 1 << DISPLAY_DEPTH;
    }

    public int numAlphaLevels() {
        return ALPHA_LEVELS;
    }

    public Displayable getCurrent() {
        return this.current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrent(Displayable nextDisplayable) {
        Object object = LCDUILock;
        synchronized (object) {
            if (nextDisplayable instanceof Alert) {
                ((Alert)nextDisplayable).setReturnScreen(this.current);
            }
            this.setCurrentImpl(nextDisplayable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrent(Alert alert, Displayable nextDisplayable) {
        if (alert == null || nextDisplayable == null) {
            throw new NullPointerException();
        }
        if (nextDisplayable instanceof Alert) {
            throw new IllegalArgumentException();
        }
        Object object = LCDUILock;
        synchronized (object) {
            alert.setReturnScreen(nextDisplayable);
            this.setCurrentImpl(alert);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentItem(Item item) {
        Object object = LCDUILock;
        synchronized (object) {
            Screen nextDisplayable = item.getOwner();
            if (nextDisplayable instanceof Form) {
                ((Form)nextDisplayable).setCurrentItem(item);
            }
            if (nextDisplayable instanceof Alert) {
                throw new IllegalStateException();
            }
            if (nextDisplayable == null) {
                throw new IllegalStateException();
            }
            this.setCurrentImpl(nextDisplayable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callSerially(Runnable r) {
        if (r == null) {
            throw new NullPointerException();
        }
        Object object = LCDUILock;
        synchronized (object) {
            currentQueue.addElement(r);
            eventHandler.scheduleCallSerially();
        }
    }

    public boolean flashBacklight(int duration) {
        if (!this.hasForeground) {
            return false;
        }
        return deviceAccess.flashBacklight(duration);
    }

    public boolean vibrate(int duration) {
        if (!this.hasForeground) {
            return false;
        }
        if (duration < 0) {
            throw new IllegalArgumentException();
        }
        return this.nVibrate(duration) > 0;
    }

    public int getBestImageWidth(int imageType) {
        switch (imageType) {
            case 1: 
            case 2: {
                return 12;
            }
            case 3: {
                return WIDTH;
            }
        }
        throw new IllegalArgumentException();
    }

    public int getBestImageHeight(int imageType) {
        switch (imageType) {
            case 1: 
            case 2: {
                return 12;
            }
            case 3: {
                return ADORNEDHEIGHT - 2 * Screen.CONTENT_HEIGHT - Displayable.TITLE_HEIGHT;
            }
        }
        throw new IllegalArgumentException();
    }

    void setCurrentImpl(Displayable nextDisplayable) {
        boolean previousWantsForeground = this.wantsForeground;
        boolean bl = this.wantsForeground = nextDisplayable != null;
        if (this.wantsForeground && (nextDisplayable != this.current || this.current != null && this.current instanceof Alert)) {
            if (this.hasForeground) {
                if (this.paintSuspended) {
                    eventHandler.clearSystemScreen();
                    this.paintSuspended = false;
                }
                eventHandler.scheduleScreenChange(this, nextDisplayable);
                return;
            }
            this.current = nextDisplayable;
        }
        if (this.wantsForeground != previousWantsForeground) {
            Display.displayManagerImpl.notifyWantsForeground(this.accessor, this.wantsForeground);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void screenChange(Displayable d) {
        Object object = LCDUILock;
        synchronized (object) {
            if (!(this.current != d || this.paintSuspended || d != null && d instanceof Alert)) {
                return;
            }
            if (this.paintSuspended) {
                this.current = d;
                return;
            }
        }
        this.registerNewCurrent(d, false);
    }

    void clearAlert(Displayable returnScreen) {
        eventHandler.scheduleScreenChange(this, returnScreen);
    }

    boolean playAlertSound(AlertType t) {
        if (!this.paintSuspended && this.hasForeground) {
            try {
                return this.playAlertSound(t.getType());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    void emuPlayAlertSound(AlertType t) {
        if (!this.paintSuspended && this.hasForeground) {
            try {
                this.emuPlayAlertSound(t.getType());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void invalidate(Item item) {
        eventHandler.scheduleInvalidate(item);
    }

    void itemStateChanged(Item item) {
        eventHandler.scheduleItemStateChanged(item);
    }

    MIDlet getMIDlet() {
        return this.midlet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void repaintImpl(Displayable d, int x, int y, int w, int h, Object target) {
        Object object = LCDUILock;
        synchronized (object) {
            if (this.paintSuspended || !this.hasForeground || d != this.current) {
                return;
            }
        }
        eventHandler.scheduleRepaint(x, y, w, h, target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void serviceRepaints(Displayable d) {
        Object object = LCDUILock;
        synchronized (object) {
            if (this.paintSuspended || !this.hasForeground || d != this.current) {
                return;
            }
        }
        eventHandler.serviceRepaints();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void repaint(int x1, int y1, int x2, int y2, Object target) {
        Displayable currentCopy = null;
        Object object = LCDUILock;
        synchronized (object) {
            if (this.paintSuspended || !this.hasForeground) {
                return;
            }
            currentCopy = this.current;
        }
        if (currentCopy == null) {
            return;
        }
        screenGraphics.reset(x1, y1, x2, y2);
        this.current.callPaint(screenGraphics, target);
        this.refresh(x1, y1, x2, y2);
    }

    static int getKeyCode(int gameAction) {
        return eventHandler.getKeyCode(gameAction);
    }

    int getVerticalScrollPosition() {
        if (this.current != null) {
            return this.current.getVerticalScrollPosition();
        }
        return 0;
    }

    int getVerticalScrollProportion() {
        if (this.current != null) {
            return this.current.getVerticalScrollProportion();
        }
        return 100;
    }

    static int getGameAction(int keyCode) {
        return eventHandler.getGameAction(keyCode);
    }

    static int getSystemKey(int keyCode) {
        return eventHandler.getSystemKey(keyCode);
    }

    static String getKeyName(int keyCode) {
        return eventHandler.getKeyName(keyCode);
    }

    void updateCommandSet() {
        Command[] screenCommands = this.current.getCommands();
        int screenComCount = this.current.getCommandCount();
        for (int i = 0; i < screenComCount; ++i) {
            screenCommands[i].setInternalID(i);
        }
        Item curItem = this.current.getCurrentItem();
        if (curItem == null) {
            ((EmulEventHandler)eventHandler).updateCommandSet(null, 0, screenCommands, screenComCount, this.current, null);
        } else {
            Command[] itemCommands = curItem.getCommands();
            int itemComCount = curItem.getCommandCount();
            for (int i = 0; i < itemComCount; ++i) {
                itemCommands[i].setInternalID(i + screenComCount);
            }
            ((EmulEventHandler)eventHandler).updateCommandSet(itemCommands, itemComCount, screenCommands, screenComCount, this.current, curItem);
        }
    }

    boolean isShown(Displayable d) {
        return this.hasForeground && !this.paintSuspended && this.current == d;
    }

    static void handleThrowable(Throwable t) {
        t.printStackTrace();
    }

    native void setVerticalScroll(int var1, int var2);

    native void setInputMode(int var1);

    private native void drawTrustedIcon(boolean var1);

    static boolean isGraphicsDisplay(Graphics gfx) {
        return screenGraphics == gfx;
    }

    private static EventHandler getEventHandler() {
        String n = Configuration.getProperty("com.sun.midp.lcdui.eventHandler");
        try {
            return (EventHandler)Class.forName(n).newInstance();
        }
        catch (Exception e) {
            if (Configuration.getProperty("microedition.configuration") != null) {
                try {
                    return (EventHandler)Class.forName("com.sun.midp.lcdui.AutomatedEventHandler").newInstance();
                }
                catch (Exception e2) {
                    try {
                        return (EventHandler)Class.forName("com.sun.midp.lcdui.DefaultEventHandler").newInstance();
                    }
                    catch (Exception e3) {
                        throw new Error("Unable to establish EventHandler");
                    }
                }
            }
            try {
                return (EventHandler)Class.forName("com.sun.midp.lcdui.AWTEventHandler").newInstance();
            }
            catch (Exception exception) {
                throw new Error("Unable to establish EventHandler");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerNewCurrent(Displayable newCurrent, boolean fgChange) {
        Displayable currentCopy = null;
        if (newCurrent != null) {
            newCurrent.callShowNotify(this);
        }
        Object object = LCDUILock;
        synchronized (object) {
            if (fgChange) {
                this.hasForeground = true;
                if (newCurrent == null) {
                    screenGraphics.reset(0, 0, WIDTH, HEIGHT);
                    screenGraphics.setColor(ERASE_COLOR);
                    screenGraphics.fillRect(0, 0, WIDTH, HEIGHT);
                    this.refresh(0, 0, WIDTH, HEIGHT);
                    eventHandler.updateCommandSet(null, 0, null, 0);
                    return;
                }
            }
            this.accessor.sawKeyPress = false;
            this.accessor.sawPointerPress = false;
            this.paintSuspended = false;
            currentCopy = this.current;
            this.current = newCurrent;
            if (this.current instanceof GameCanvas) {
                GameMap.register(this.current, this.accessor);
                this.currentKeyMask = 0;
                this.stickyKeyMask = 0;
            } else {
                this.currentKeyMask = -1;
                this.stickyKeyMask = -1;
            }
            this.setVerticalScroll(this.current.getVerticalScrollPosition(), this.current.getVerticalScrollProportion());
            this.updateCommandSet();
        }
        if (currentCopy != null && currentCopy != this.current) {
            currentCopy.callHideNotify(this);
        }
        this.repaint(0, 0, WIDTH, HEIGHT, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getCallSerially() {
        Vector q = null;
        Object object = LCDUILock;
        synchronized (object) {
            q = currentQueue;
            currentQueue = q == queue1 ? queue2 : queue1;
        }
        object = calloutLock;
        synchronized (object) {
            for (int i = 0; i < q.size(); ++i) {
                try {
                    Runnable r = (Runnable)q.elementAt(i);
                    r.run();
                    continue;
                }
                catch (Throwable thr) {
                    Display.handleThrowable(thr);
                }
            }
        }
        q.removeAllElements();
    }

    private void callInvalidate(Item item) {
        Displayable currentCopy = this.current;
        if (currentCopy != null) {
            currentCopy.callInvalidate(item);
        }
    }

    private void callItemStateChanged(Item item) {
        Displayable currentCopy = this.current;
        if (currentCopy != null) {
            currentCopy.callItemStateChanged(item);
        }
    }

    private static void initSecurityToken(SecurityToken token) {
        if (classSecurityToken != null) {
            return;
        }
        classSecurityToken = token;
    }

    private native void refresh(int var1, int var2, int var3, int var4);

    private native boolean playAlertSound(int var1);

    private native void emuPlayAlertSound(int var1);

    private native int nVibrate(int var1);

    static {
        queue1 = new Vector();
        queue2 = new Vector();
        currentQueue = queue1;
        DeviceCaps c = new DeviceCaps();
        WIDTH = c.width;
        HEIGHT = c.height;
        ADORNEDHEIGHT = c.adornedHeight;
        ERASE_COLOR = c.eraseColor;
        DISPLAY_DEPTH = c.displayDepth;
        DISPLAY_IS_COLOR = c.displayIsColor;
        POINTER_SUPPORTED = c.pointerSupported;
        MOTION_SUPPORTED = c.motionSupported;
        REPEAT_SUPPORTED = c.repeatSupported;
        IS_DOUBLE_BUFFERED = c.isDoubleBuffered;
        BG_H_COLOR = FG_COLOR = 0;
        FG_H_COLOR = ERASE_COLOR;
        Text.FG_COLOR = FG_COLOR;
        Text.FG_H_COLOR = FG_H_COLOR;
        ALPHA_LEVELS = c.numAlphaLevels;
        KEYCODE_UP = c.keyCodeUp;
        KEYCODE_DOWN = c.keyCodeDown;
        KEYCODE_LEFT = c.keyCodeLeft;
        KEYCODE_RIGHT = c.keyCodeRight;
        KEYCODE_SELECT = c.keyCodeSelect;
        c = null;
        displayManagerImpl = new DisplayManagerImpl();
        DisplayManagerFactory.SetDisplayManagerImpl(displayManagerImpl);
        deviceAccess = new DisplayDeviceAccess();
        eventHandler = Display.getEventHandler();
        screenGraphics = Graphics.getGraphics(null);
    }

    private static class DisplayManagerImpl
    implements DisplayManager {
        private Vector systemEventListeners = new Vector(5, 5);
        private Vector displays = new Vector(5, 5);
        private final DisplayAccess noForeground;
        private DisplayAccess foreground = this.noForeground = Display.access$1600(new Display(null));
        private DisplayAccess suspended;
        private boolean allSuspended;
        private DisplayAccess preempted;

        private DisplayManagerImpl() {
        }

        public void addSystemEventListener(SystemEventListener l) {
            this.systemEventListeners.addElement(l);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void activate(MIDletEventListener l, MIDlet m) {
            Display d = Display.getDisplay(m);
            DisplayAccessor da = d.accessor;
            Vector vector = this.displays;
            synchronized (vector) {
                if (this.displays.indexOf(da) != -1) {
                    return;
                }
                d.midletEventListener = l;
                this.displays.addElement(da);
                this.notifyWantsForeground(da, da.wantsForeground());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deactivate(MIDlet m) {
            DisplayAccessor da = Display.getDisplay(m).accessor;
            Vector vector = this.displays;
            synchronized (vector) {
                if (da == this.suspended) {
                    this.suspended = null;
                    return;
                }
                this.displays.removeElement(da);
                if (da == this.foreground) {
                    eventHandler.clearSystemScreen();
                    this.notifyWantsForeground(da, false);
                    return;
                }
                if (da == this.preempted) {
                    this.preempted = this.noForeground;
                    return;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object preemptDisplay(SecurityToken token, MIDletEventListener l, Displayable d, boolean waitForDisplay) throws InterruptedException {
            token.checkIfPermissionAllowed(0);
            Vector vector = this.displays;
            synchronized (vector) {
                if (this.preempted != null || this.allSuspended) {
                    if (!waitForDisplay) {
                        return null;
                    }
                    this.displays.wait();
                }
                Display tempDisplay = new Display(null);
                tempDisplay.setCurrent(d);
                tempDisplay.midletEventListener = l;
                this.foreground.foregroundNotify(false);
                this.preempted = this.foreground;
                this.foreground = tempDisplay.accessor;
                this.foreground.foregroundNotify(true);
                return this.displays;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void donePreempting(Object preemptToken) {
            if (preemptToken != this.displays) {
                return;
            }
            Vector vector = this.displays;
            synchronized (vector) {
                this.foreground.foregroundNotify(false);
                if (!this.allSuspended) {
                    if (this.preempted.wantsForeground()) {
                        this.foreground = this.preempted;
                        this.foreground.foregroundNotify(true);
                    } else {
                        this.foreground = this.noForeground;
                        this.notifyWantsForeground(this.noForeground, false);
                    }
                    this.displays.notify();
                }
                this.preempted = null;
            }
        }

        public void releaseSystemEventListener(SystemEventListener l) {
            this.systemEventListeners.removeElement(l);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void suspendAll() {
            Vector vector = this.displays;
            synchronized (vector) {
                if (this.allSuspended) {
                    return;
                }
                this.allSuspended = true;
                this.foreground.foregroundNotify(false);
                for (int i = 0; i < this.displays.size(); ++i) {
                    Display d = ((DisplayAccess)this.displays.elementAt(i)).getDisplay();
                    d.midletEventListener.pauseMIDlet(d.getMIDlet());
                }
                if (this.suspended != null) {
                    this.displays.addElement(this.suspended);
                    this.suspended = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resumeAll() {
            Vector vector = this.displays;
            synchronized (vector) {
                this.allSuspended = false;
                for (int i = 0; i < this.displays.size(); ++i) {
                    DisplayAccess da = (DisplayAccess)this.displays.elementAt(i);
                    Display d = da.getDisplay();
                    d.midletEventListener.startMIDlet(d.getMIDlet());
                }
                if (this.foreground.wantsForeground()) {
                    this.foreground.foregroundNotify(true);
                    return;
                }
                this.foreground = this.noForeground;
                this.notifyWantsForeground(this.foreground, false);
                this.displays.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            Vector vector = this.systemEventListeners;
            synchronized (vector) {
                for (int i = 0; i < this.systemEventListeners.size(); ++i) {
                    SystemEventListener l = (SystemEventListener)this.systemEventListeners.elementAt(i);
                    l.shutdown();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void suspendCurrent() {
            Vector vector = this.displays;
            synchronized (vector) {
                if (this.foreground == this.noForeground || this.suspended != null || this.allSuspended || this.preempted != null) {
                    return;
                }
                Display d = this.foreground.getDisplay();
                d.midletEventListener.pauseMIDlet(d.getMIDlet());
                this.suspended = this.foreground;
                this.deactivate(d.getMIDlet());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resumePrevious() {
            Vector vector = this.displays;
            synchronized (vector) {
                if (this.suspended == null) {
                    return;
                }
                Display d = this.suspended.getDisplay();
                d.midletEventListener.startMIDlet(d.getMIDlet());
                this.displays.addElement(this.suspended);
                if (this.suspended.wantsForeground()) {
                    this.foreground.foregroundNotify(false);
                    this.foreground = this.suspended;
                    this.foreground.foregroundNotify(true);
                }
                this.suspended = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void killCurrent() {
            Vector vector = this.displays;
            synchronized (vector) {
                if (this.foreground == this.noForeground) {
                    return;
                }
                Display d = this.foreground.getDisplay();
                d.midletEventListener.destroyMIDlet(d.getMIDlet());
            }
        }

        public void commandAction(int id) {
            this.foreground.commandAction(id);
        }

        public void pointerEvent(int type, int x, int y) {
            this.foreground.pointerEvent(type, x, y);
        }

        public void keyEvent(int type, int keyCode) {
            this.foreground.keyEvent(type, keyCode);
        }

        public void screenChange(Display parent, Displayable screen) {
            parent.screenChange(screen);
        }

        public void initSecurityToken(SecurityToken token) {
            Display.initSecurityToken(token);
        }

        public DisplayAccess createDisplay(SecurityToken token, MIDlet midlet) {
            token.checkIfPermissionAllowed(0);
            return new Display(midlet).accessor;
        }

        public Image getTrustedMIDletIcon() {
            MIDletSuite suite = Scheduler.getScheduler().getMIDletSuite();
            if (suite != null) {
                suite.checkIfPermissionAllowed(0);
            }
            return ImmutableImage.createIcon("trustedmidlet_icon.png");
        }

        public void repaint(int x1, int y1, int x2, int y2, Object target) {
            this.foreground.repaint(x1, y1, x2, y2, target);
        }

        public void callSerially() {
            this.foreground.callSerially();
        }

        public void callInvalidate(Item item) {
            this.foreground.callInvalidate(item);
        }

        public void callItemStateChanged(Item item) {
            this.foreground.callItemStateChanged(item);
        }

        public void suspendPainting() {
            this.foreground.suspendPainting();
        }

        public void resumePainting() {
            this.foreground.resumePainting();
        }

        public void inputMethodEvent(String str) {
            this.foreground.inputMethodEvent(str);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void notifyWantsForeground(DisplayAccess display, boolean wantsForeground) {
            Vector vector = this.displays;
            synchronized (vector) {
                if (this.allSuspended || display == this.foreground && wantsForeground || display != this.foreground && (!wantsForeground || this.foreground.wantsForeground())) {
                    return;
                }
                DisplayAccess newForeground = this.noForeground;
                for (int i = 0; i < this.displays.size(); ++i) {
                    DisplayAccess temp = (DisplayAccess)this.displays.elementAt(i);
                    if (temp.getDisplay().getCurrent() != null) {
                        newForeground = temp;
                    }
                    if (!temp.wantsForeground()) continue;
                    newForeground = temp;
                    break;
                }
                this.foreground.foregroundNotify(false);
                this.foreground = newForeground;
                this.foreground.foregroundNotify(true);
                return;
            }
        }
    }

    class DisplayAccessor
    implements DisplayAccess {
        boolean sawPointerPress;
        boolean sawKeyPress;

        DisplayAccessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void suspendPainting() {
            Displayable currentCopy = null;
            Object object = LCDUILock;
            synchronized (object) {
                Display.this.paintSuspended = true;
                currentCopy = Display.this.current;
                if (Display.this.current instanceof Screen) {
                    ((Screen)((Display)Display.this).current).resetToTop = false;
                }
            }
            if (currentCopy != null) {
                currentCopy.callHideNotify(Display.this);
            }
            Display.this.setVerticalScroll(0, 100);
        }

        public void resumePainting() {
            Display.this.registerNewCurrent(Display.this.current, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void commandAction(int id) {
            CommandListener listener;
            ItemCommandListener itemListener = null;
            Command c = null;
            Displayable currentCopy = null;
            Item curItem = null;
            Object object = LCDUILock;
            synchronized (object) {
                int i;
                int nc;
                Command[] commands;
                if (Display.this.current == null) {
                    return;
                }
                listener = Display.this.current.getCommandListener();
                if (listener != null && (commands = Display.this.current.getCommands()) != null) {
                    nc = Display.this.current.getCommandCount();
                    for (i = 0; i < nc; ++i) {
                        if (commands[i] == null || commands[i].getID() != id) continue;
                        c = commands[i];
                        currentCopy = Display.this.current;
                        break;
                    }
                }
                if (c == null && (curItem = Display.this.current.getCurrentItem()) != null && (itemListener = curItem.getItemCommandListener()) != null && (commands = curItem.getCommands()) != null) {
                    nc = curItem.getCommandCount();
                    for (i = 0; i < nc; ++i) {
                        if (commands[i] == null || commands[i].getID() != id) continue;
                        c = commands[i];
                        break;
                    }
                }
                if (c == null) {
                    return;
                }
                if (currentCopy != null) {
                    currentCopy.commitPendingInteraction();
                } else {
                    curItem.commitPendingInteraction();
                }
            }
            try {
                object = calloutLock;
                synchronized (object) {
                    if (currentCopy != null) {
                        listener.commandAction(c, currentCopy);
                    } else {
                        itemListener.commandAction(c, curItem);
                    }
                }
            }
            catch (Throwable thr) {
                Display.handleThrowable(thr);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void pointerEvent(int type, int x, int y) {
            Displayable currentCopy = null;
            int eventType = -1;
            Object object = LCDUILock;
            synchronized (object) {
                if (Display.this.current == null) {
                    return;
                }
                currentCopy = Display.this.current;
                switch (type) {
                    case 1: {
                        this.sawPointerPress = true;
                        eventType = 0;
                        break;
                    }
                    case 2: {
                        if (!this.sawPointerPress) break;
                        eventType = 1;
                        break;
                    }
                    case 3: {
                        if (!this.sawPointerPress) break;
                        eventType = 2;
                    }
                }
            }
            switch (eventType) {
                case -1: {
                    return;
                }
                case 0: {
                    currentCopy.callPointerPressed(x, y);
                    break;
                }
                case 1: {
                    currentCopy.callPointerReleased(x, y);
                    break;
                }
                case 2: {
                    currentCopy.callPointerDragged(x, y);
                    break;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void keyEvent(int type, int keyCode) {
            Displayable currentCopy = null;
            int eventType = -1;
            Object object = LCDUILock;
            synchronized (object) {
                if (Display.this.current == null) {
                    return;
                }
                currentCopy = Display.this.current;
                switch (type) {
                    case 1: {
                        this.sawKeyPress = true;
                        eventType = 0;
                        break;
                    }
                    case 2: {
                        if (!this.sawKeyPress) break;
                        eventType = 1;
                        break;
                    }
                    case 3: {
                        if (!this.sawKeyPress) break;
                        eventType = 2;
                        break;
                    }
                    case 4: {
                        eventType = 3;
                    }
                }
                if (Display.this.currentKeyMask > -1 && eventType != -1) {
                    if (eventType == 1) {
                        this.releaseKeyMask(keyCode);
                    } else {
                        this.setKeyMask(keyCode);
                    }
                }
            }
            switch (eventType) {
                case -1: {
                    return;
                }
                case 0: {
                    currentCopy.callKeyPressed(keyCode);
                    break;
                }
                case 1: {
                    currentCopy.callKeyReleased(keyCode);
                    break;
                }
                case 2: {
                    currentCopy.callKeyRepeated(keyCode);
                    break;
                }
                case 3: {
                    currentCopy.callKeyTyped((char)keyCode);
                    break;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void screenChange(Displayable d) {
            Object object = LCDUILock;
            synchronized (object) {
                if (!(Display.this.current != d || Display.this.paintSuspended || d != null && d instanceof Alert)) {
                    return;
                }
                if (Display.this.paintSuspended || !Display.this.hasForeground) {
                    Display.this.current = d;
                    return;
                }
            }
            Display.this.registerNewCurrent(d, false);
        }

        public void repaint(int x1, int y1, int x2, int y2, Object target) {
            Display.this.repaint(x1, y1, x2, y2, target);
        }

        public void callSerially() {
            Display.this.getCallSerially();
        }

        public void callInvalidate(Item src) {
            Display.this.callInvalidate(src);
        }

        public void callItemStateChanged(Item src) {
            Display.this.callItemStateChanged(src);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void inputMethodEvent(String str) {
            TextBox textBoxCopy = null;
            Object object = LCDUILock;
            synchronized (object) {
                if (Display.this.current instanceof TextBox) {
                    textBoxCopy = (TextBox)Display.this.current;
                }
            }
            if (textBoxCopy != null) {
                textBoxCopy.insert(str, textBoxCopy.getCaretPosition());
            }
        }

        public boolean wantsForeground() {
            return Display.this.wantsForeground;
        }

        public Display getDisplay() {
            return Display.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void foregroundNotify(boolean hasForeground) {
            if (hasForeground && !Display.this.hasForeground) {
                if (Scheduler.getScheduler().isDispatchThread()) {
                    eventHandler.serviceRepaints();
                }
                Display.this.registerNewCurrent(Display.this.current, true);
            } else {
                Displayable currentCopy = null;
                Object object = LCDUILock;
                synchronized (object) {
                    Display.this.hasForeground = false;
                    Display.this.paintSuspended = true;
                    currentCopy = Display.this.current;
                }
                if (currentCopy != null) {
                    currentCopy.callHideNotify(Display.this);
                }
                Display.this.setVerticalScroll(0, 100);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getKeyMask() {
            Object object = LCDUILock;
            synchronized (object) {
                int savedMaskCopy = Display.this.stickyKeyMask | Display.this.currentKeyMask;
                Display.this.stickyKeyMask = 0;
                return savedMaskCopy;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush(Displayable d, Image offscreen_buffer, int x, int y, int width, int height) {
            Object object = LCDUILock;
            synchronized (object) {
                if (Display.this.paintSuspended || !Display.this.hasForeground || d != Display.this.current) {
                    return;
                }
                int x2 = x + width;
                int y2 = y + height;
                int transX = d.viewport[0];
                int transY = d.viewport[1];
                screenGraphics.reset(0, 0, WIDTH, HEIGHT);
                screenGraphics.translate(transX, transY);
                screenGraphics.clipRect(x, y, width, height);
                screenGraphics.drawImage(offscreen_buffer, 0, 0, 20);
                Display.this.refresh(transX + x, transY + y, transX + x2, transY + y2);
            }
        }

        public void setTrustedIcon(SecurityToken token, boolean drawTrusted) {
            token.checkIfPermissionAllowed(0);
            Display.this.drawTrustedIcon(drawTrusted);
        }

        private void setKeyMask(int keyCode) {
            if (Display.this.paintSuspended || !Display.this.hasForeground) {
                return;
            }
            switch (eventHandler.getGameAction(keyCode)) {
                case 1: {
                    Display.this.stickyKeyMask = Display.this.stickyKeyMask | 2;
                    Display.this.currentKeyMask = Display.this.currentKeyMask | 2;
                    break;
                }
                case 6: {
                    Display.this.stickyKeyMask = Display.this.stickyKeyMask | 0x40;
                    Display.this.currentKeyMask = Display.this.currentKeyMask | 0x40;
                    break;
                }
                case 2: {
                    Display.this.stickyKeyMask = Display.this.stickyKeyMask | 4;
                    Display.this.currentKeyMask = Display.this.currentKeyMask | 4;
                    break;
                }
                case 5: {
                    Display.this.stickyKeyMask = Display.this.stickyKeyMask | 0x20;
                    Display.this.currentKeyMask = Display.this.currentKeyMask | 0x20;
                    break;
                }
                case 8: {
                    Display.this.stickyKeyMask = Display.this.stickyKeyMask | 0x100;
                    Display.this.currentKeyMask = Display.this.currentKeyMask | 0x100;
                    break;
                }
                case 9: {
                    Display.this.stickyKeyMask = Display.this.stickyKeyMask | 0x200;
                    Display.this.currentKeyMask = Display.this.currentKeyMask | 0x200;
                    break;
                }
                case 10: {
                    Display.this.stickyKeyMask = Display.this.stickyKeyMask | 0x400;
                    Display.this.currentKeyMask = Display.this.currentKeyMask | 0x400;
                    break;
                }
                case 11: {
                    Display.this.stickyKeyMask = Display.this.stickyKeyMask | 0x800;
                    Display.this.currentKeyMask = Display.this.currentKeyMask | 0x800;
                    break;
                }
                case 12: {
                    Display.this.stickyKeyMask = Display.this.stickyKeyMask | 0x1000;
                    Display.this.currentKeyMask = Display.this.currentKeyMask | 0x1000;
                }
            }
        }

        private void releaseKeyMask(int keyCode) {
            if (Display.this.paintSuspended || !Display.this.hasForeground) {
                Display.this.currentKeyMask = 0;
                return;
            }
            switch (eventHandler.getGameAction(keyCode)) {
                case 1: {
                    Display.this.currentKeyMask = Display.this.currentKeyMask & 0xFFFFFFFD;
                    break;
                }
                case 6: {
                    Display.this.currentKeyMask = Display.this.currentKeyMask & 0xFFFFFFBF;
                    break;
                }
                case 2: {
                    Display.this.currentKeyMask = Display.this.currentKeyMask & 0xFFFFFFFB;
                    break;
                }
                case 5: {
                    Display.this.currentKeyMask = Display.this.currentKeyMask & 0xFFFFFFDF;
                    break;
                }
                case 8: {
                    Display.this.currentKeyMask = Display.this.currentKeyMask & 0xFFFFFEFF;
                    break;
                }
                case 9: {
                    Display.this.currentKeyMask = Display.this.currentKeyMask & 0xFFFFFDFF;
                    break;
                }
                case 10: {
                    Display.this.currentKeyMask = Display.this.currentKeyMask & 0xFFFFFBFF;
                    break;
                }
                case 11: {
                    Display.this.currentKeyMask = Display.this.currentKeyMask & 0xFFFFF7FF;
                    break;
                }
                case 12: {
                    Display.this.currentKeyMask = Display.this.currentKeyMask & 0xFFFFEFFF;
                }
            }
        }
    }
}

