/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import com.sun.kvem.DeviceConfiguration;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;

public abstract class CustomItem
extends Item {
    protected static final int TRAVERSE_HORIZONTAL = 1;
    protected static final int TRAVERSE_VERTICAL = 2;
    protected static final int KEY_PRESS = 4;
    protected static final int KEY_RELEASE = 8;
    protected static final int KEY_REPEAT = 16;
    protected static final int POINTER_PRESS = 32;
    protected static final int POINTER_RELEASE = 64;
    protected static final int POINTER_DRAG = 128;
    protected static final int NONE = 0;
    private int labelHeight = 0;

    protected CustomItem(String label) {
        super(label);
    }

    public int getGameAction(int keyCode) {
        int n = Display.getGameAction(keyCode);
        if (n == -1) {
            throw new IllegalArgumentException();
        }
        return n;
    }

    protected final int getInteractionModes() {
        String touchScreen = DeviceConfiguration.getProperty("Device.TOUCH_SCREEN");
        boolean enable_pointers = touchScreen != null && touchScreen.equals("true");
        int result = 31;
        if (enable_pointers) {
            result = result | 0x20 | 0x40 | 0x80;
        }
        return result;
    }

    protected abstract int getMinContentWidth();

    protected abstract int getMinContentHeight();

    protected abstract int getPrefContentWidth(int var1);

    protected abstract int getPrefContentHeight(int var1);

    protected void sizeChanged(int w, int h) {
    }

    protected final void invalidate() {
        super.invalidate();
    }

    protected abstract void paint(Graphics var1, int var2, int var3);

    protected final void repaint() {
        if (this.bounds != null) {
            try {
                super.repaint(0, this.labelHeight, this.bounds[2], this.bounds[3] - this.labelHeight);
            }
            catch (Exception e) {
                Display.handleThrowable(e);
            }
        }
    }

    protected final void repaint(int x, int y, int w, int h) {
        if (this.bounds != null) {
            try {
                if (x > this.bounds[2]) {
                    return;
                }
                if (x < 0) {
                    x = 0;
                }
                if (y < 0) {
                    y = 0;
                }
                if ((y += this.labelHeight) > this.bounds[3]) {
                    return;
                }
                if (x + w > this.bounds[2]) {
                    w = this.bounds[2] - x;
                }
                if (y + h > this.bounds[3]) {
                    h = this.bounds[3] - y;
                }
                super.repaint(x, y, w, h);
            }
            catch (Exception e) {
                Display.handleThrowable(e);
            }
        }
    }

    protected boolean traverse(int dir, int viewportWidth, int viewportHeight, int[] visRect_inout) {
        return false;
    }

    protected void traverseOut() {
    }

    protected void keyPressed(int keyCode) {
    }

    protected void keyReleased(int keyCode) {
    }

    protected void keyRepeated(int keyCode) {
    }

    protected void pointerPressed(int x, int y) {
    }

    protected void pointerReleased(int x, int y) {
    }

    protected void pointerDragged(int x, int y) {
    }

    protected void showNotify() {
    }

    protected void hideNotify() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int callGetLayout() {
        int l = 17;
        try {
            Object object = Display.calloutLock;
            synchronized (object) {
                l = this.getLayout();
            }
        }
        catch (Throwable thr) {
            Display.handleThrowable(thr);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int callPreferredWidth(int h) {
        try {
            Object object = Display.calloutLock;
            synchronized (object) {
                return this.getPrefContentWidth(h);
            }
        }
        catch (Throwable thr) {
            Display.handleThrowable(thr);
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int callPreferredHeight(int w) {
        try {
            Object object = Display.calloutLock;
            synchronized (object) {
                return this.getPrefContentHeight(w) + this.getLabelHeight(w);
            }
        }
        catch (Throwable thr) {
            Display.handleThrowable(thr);
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int callMinimumWidth() {
        try {
            Object object = Display.calloutLock;
            synchronized (object) {
                return this.getMinContentWidth();
            }
        }
        catch (Throwable thr) {
            Display.handleThrowable(thr);
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int callMinimumHeight() {
        try {
            Object object = Display.calloutLock;
            synchronized (object) {
                return this.getMinContentHeight() + this.getLabelHeight(-1);
            }
        }
        catch (Throwable thr) {
            Display.handleThrowable(thr);
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callSizeChanged(int w, int h) {
        this.labelHeight = this.getLabelHeight(w);
        try {
            Object object = Display.calloutLock;
            synchronized (object) {
                this.sizeChanged(w, h - this.labelHeight);
            }
        }
        catch (Throwable thr) {
            Display.handleThrowable(thr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callPaint(Graphics g, int w, int h) {
        super.paintLabel(g, w);
        g.clipRect(0, this.labelHeight, w, h - this.labelHeight);
        g.translate(0, this.labelHeight);
        try {
            Object object = Display.calloutLock;
            synchronized (object) {
                this.paint(g, w, h - this.labelHeight);
            }
        }
        catch (Throwable thr) {
            Display.handleThrowable(thr);
        }
        g.translate(0, -this.labelHeight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean callTraverse(int dir, int viewportWidth, int viewportHeight, int[] visRect_inout) {
        super.callTraverse(dir, viewportWidth, viewportHeight, visRect_inout);
        try {
            Object object = Display.calloutLock;
            synchronized (object) {
                visRect_inout[3] = visRect_inout[3] - this.labelHeight;
                boolean t = this.traverse(dir, viewportWidth, viewportHeight - this.labelHeight, visRect_inout);
                visRect_inout[1] = visRect_inout[1] + this.labelHeight;
                return t;
            }
        }
        catch (Throwable thr) {
            Display.handleThrowable(thr);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callTraverseOut() {
        super.callTraverseOut();
        try {
            Object object = Display.calloutLock;
            synchronized (object) {
                this.traverseOut();
            }
        }
        catch (Throwable thr) {
            Display.handleThrowable(thr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callKeyPressed(int keyCode) {
        ItemCommandListener cl = null;
        Command defaultCmd = null;
        Object object = Display.LCDUILock;
        synchronized (object) {
            cl = this.commandListener;
            defaultCmd = this.defaultCommand;
        }
        try {
            object = Display.calloutLock;
            synchronized (object) {
                if (cl != null && defaultCmd != null && keyCode == Display.KEYCODE_SELECT) {
                    cl.commandAction(defaultCmd, this);
                } else {
                    this.keyPressed(keyCode);
                }
            }
        }
        catch (Throwable thr) {
            Display.handleThrowable(thr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callKeyReleased(int keyCode) {
        try {
            Object object = Display.calloutLock;
            synchronized (object) {
                this.keyReleased(keyCode);
            }
        }
        catch (Throwable thr) {
            Display.handleThrowable(thr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callKeyRepeated(int keyCode) {
        try {
            Object object = Display.calloutLock;
            synchronized (object) {
                this.keyRepeated(keyCode);
            }
        }
        catch (Throwable thr) {
            Display.handleThrowable(thr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callPointerPressed(int x, int y) {
        try {
            Object object = Display.calloutLock;
            synchronized (object) {
                this.pointerPressed(x, y - this.labelHeight);
            }
        }
        catch (Throwable thr) {
            Display.handleThrowable(thr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callPointerReleased(int x, int y) {
        try {
            Object object = Display.calloutLock;
            synchronized (object) {
                this.pointerReleased(x, y - this.labelHeight);
            }
        }
        catch (Throwable thr) {
            Display.handleThrowable(thr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callPointerDragged(int x, int y) {
        try {
            Object object = Display.calloutLock;
            synchronized (object) {
                this.pointerDragged(x, y - this.labelHeight);
            }
        }
        catch (Throwable thr) {
            Display.handleThrowable(thr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callShowNotify() {
        super.callShowNotify();
        try {
            Object object = Display.calloutLock;
            synchronized (object) {
                this.showNotify();
            }
        }
        catch (Throwable thr) {
            Display.handleThrowable(thr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callHideNotify() {
        super.callHideNotify();
        try {
            Object object = Display.calloutLock;
            synchronized (object) {
                this.hideNotify();
            }
        }
        catch (Throwable thr) {
            Display.handleThrowable(thr);
        }
    }
}

