/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mmedia.protocol;

import com.sun.mmedia.Mime;
import com.sun.mmedia.protocol.BasicDS;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.io.file.FileConnection;
import javax.microedition.media.MediaException;
import javax.microedition.media.protocol.ContentDescriptor;
import javax.microedition.media.protocol.SourceStream;

public class CommonDS
extends BasicDS
implements SourceStream {
    private InputStream inputStream;
    private byte[] buffer = null;
    private static final int BUFFER_SIZE = 2048;
    private long location;

    public void setInputStream(InputStream is) {
        this.connected = true;
        try {
            super.setLocator(null);
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
        this.inputStream = is;
        this.contentLength = -1L;
    }

    void getConnection() throws IOException {
        boolean goodurl = false;
        if (this.locator == null) {
            throw new IOException(this + ": connect() failed");
        }
        this.contentType = null;
        String fileName = CommonDS.getRemainder(this.locator);
        if (fileName == null) {
            throw new IOException("bad url");
        }
        this.contentType = Mime.ext2Mime(fileName);
        if (this.contentType == null) {
            this.contentType = "unknown";
        }
        try {
            if (this.locator.startsWith("http:")) {
                HttpConnection httpCon = (HttpConnection)Connector.open((String)this.locator);
                int rescode = httpCon.getResponseCode();
                if (rescode >= 400) {
                    httpCon.close();
                    goodurl = false;
                } else {
                    this.inputStream = httpCon.openInputStream();
                    this.contentLength = httpCon.getLength();
                    String ct = httpCon.getType().toLowerCase();
                    httpCon.close();
                    goodurl = true;
                }
            } else if (this.locator.startsWith("file:")) {
                FileConnection fileCon = (FileConnection)Connector.open((String)this.locator);
                if (fileCon.exists() && !fileCon.isDirectory() && fileCon.canRead()) {
                    this.inputStream = fileCon.openInputStream();
                    this.contentLength = fileCon.fileSize();
                    fileCon.close();
                    goodurl = true;
                } else {
                    fileCon.close();
                    goodurl = false;
                }
            } else if (this.locator.startsWith("rtp:")) {
                this.contentType = "content.rtp";
                goodurl = true;
            } else if (this.locator.startsWith("rtsp:")) {
                this.contentType = "content.rtsp";
                goodurl = true;
            } else if (this.locator.equals("device://tone") || this.locator.equals("device://midi")) {
                this.inputStream = null;
                this.contentLength = -1L;
                goodurl = true;
            }
        }
        catch (Exception ex) {
            throw new IOException("failed to connect" + ex.getMessage());
        }
        if (!goodurl) {
            throw new IOException("bad url");
        }
    }

    public SourceStream[] getStreams() {
        return new SourceStream[]{this};
    }

    public ContentDescriptor getContentDescriptor() {
        return null;
    }

    public int getTransferSize() {
        return -1;
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        int len = length;
        int off = offset;
        do {
            int bytesRead;
            if ((bytesRead = this.inputStream.read(buffer, off, len)) == -1) {
                int totalBytesRead = length - len;
                return totalBytesRead > 0 ? totalBytesRead : -1;
            }
            this.location += (long)bytesRead;
            off += bytesRead;
            if ((len -= bytesRead) == 0) continue;
            Thread.yield();
        } while (len != 0);
        return length;
    }

    public long seek(long where) throws IOException {
        int seekable = this.getSeekType();
        if (seekable == 0) {
            throw new IOException("can't seek");
        }
        if (where < 0L) {
            where = 0L;
        }
        if (seekable == 1 && where != 0L) {
            throw new IOException("can't seek");
        }
        if (this.contentLength > 0L && where > this.contentLength) {
            where = this.contentLength;
        }
        long oldLocation = this.location;
        long skipped = 0L;
        if (where < oldLocation) {
            this.reopenStream();
            this.location = this.skip(this.inputStream, where);
        } else {
            skipped = this.skip(this.inputStream, where - oldLocation);
            this.location = oldLocation + skipped;
        }
        return this.location;
    }

    public void reopenStream() throws IOException {
        if (this.getLocator() == null) {
            this.inputStream.reset();
            return;
        }
        if (this.inputStream != null) {
            this.inputStream.close();
            this.inputStream = null;
        }
        this.getConnection();
    }

    public long tell() {
        return this.location;
    }

    public synchronized void close() {
        if (this.inputStream == null) {
            return;
        }
        try {
            this.inputStream.close();
            this.inputStream = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.buffer = null;
    }

    private long skip(InputStream istream, long amount) throws IOException {
        int toread;
        long remaining;
        long actualRead;
        if (this.buffer == null) {
            this.buffer = new byte[2048];
        }
        for (remaining = amount; remaining > 0L && (actualRead = (long)this.read(this.buffer, 0, toread = remaining > 2048L ? 2048 : (int)remaining)) != -1L; remaining -= actualRead) {
        }
        return amount - remaining;
    }
}

