/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mmedia.protocol;

import java.io.IOException;
import javax.microedition.media.Control;
import javax.microedition.media.MediaException;
import javax.microedition.media.protocol.DataSource;

public abstract class BasicDS
extends DataSource {
    protected long contentLength = -1L;
    protected String locator = null;
    protected boolean connected = false;
    protected String contentType = null;

    public BasicDS() {
        super(null);
    }

    public void setLocator(String ml) throws MediaException {
        this.locator = ml != null ? BasicDS.urlCvrt(ml) : ml;
    }

    public String getLocator() {
        return this.locator;
    }

    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        this.getConnection();
        this.connected = true;
    }

    abstract void getConnection() throws IOException;

    public synchronized void disconnect() {
        if (!this.connected) {
            return;
        }
        this.close();
        this.connected = false;
    }

    public void close() {
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String type) {
        this.contentType = type;
    }

    public Control[] getControls() {
        return new Control[0];
    }

    public Control getControl(String controlType) {
        return null;
    }

    public void start() throws IOException {
    }

    public void stop() {
    }

    public long getDuration() {
        return -1L;
    }

    public static String getProtocol(String loc) {
        String proto = "";
        int idx = loc.indexOf(58);
        if (idx != -1) {
            proto = loc.substring(0, idx);
        }
        return proto;
    }

    protected static final String getRemainder(String loc) {
        String proto = "";
        int idx = loc.indexOf(58);
        if (idx != -1) {
            proto = loc.substring(idx + 1);
        }
        return proto;
    }

    private static String urlCvrt(String theml) {
        String proto = BasicDS.getProtocol(theml);
        String ret = theml;
        if (proto != null && proto.equals("file")) {
            String file = BasicDS.getRemainder(theml);
            boolean changed = false;
            if (file == null) {
                return theml;
            }
            try {
                int idx = 0;
                while ((idx = file.indexOf("%", idx)) >= 0) {
                    if (file.length() > idx + 2) {
                        byte[] bytes = new byte[1];
                        try {
                            bytes[0] = (byte)Integer.valueOf(file.substring(idx + 1, idx + 3), 16).intValue();
                            file = file.substring(0, idx) + new String(bytes) + file.substring(idx + 3);
                            changed = true;
                        }
                        catch (NumberFormatException ne) {
                            // empty catch block
                        }
                    }
                    ++idx;
                }
                if (changed) {
                    ret = proto + ":" + file;
                }
            }
            catch (Exception e) {
                ret = theml;
            }
        }
        return ret;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public int getSeekType() {
        return 2;
    }
}

