/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mmedia;

import com.sun.mmedia.BasicPlayer;
import com.sun.mmedia.Buffer;
import com.sun.mmedia.MetaCtrl;
import com.sun.mmedia.RecordCtrl;
import com.sun.mmedia.VolCtrl;
import com.sun.mmedia.WavRC;
import com.sun.mmedia.WaveOut;
import java.io.IOException;
import java.util.Hashtable;
import javax.microedition.media.Control;
import javax.microedition.media.MediaException;
import javax.microedition.media.control.RateControl;

public class WavPlayer
extends BasicPlayer
implements Runnable {
    long duration = -1L;
    int sampleRate;
    int channels;
    int sampleSizeInBits;
    boolean isBigEndian = false;
    boolean isSigned;
    private int encoding;
    private int samplesPerBlock;
    private int bytesPerSecond;
    private int blockAlign;
    WaveOut waveOut = new WaveOut();
    private Object waveLock = new Object();
    private Thread playThread;
    private boolean started;
    private boolean interrupted;
    private Object playLock = new Object();
    long startpt;
    private long endpt = Long.MAX_VALUE;
    long mediaTimeCache;
    private int bufLen;
    Buffer bufferObject;
    int sleepTime;
    final Object pauseLock = new Object();
    final Object readLock = new Object();
    private boolean canPause = true;
    private VolCtrl vc;
    private long contentLength;
    private boolean fmtSeen;
    private boolean dataSeen;
    private static Hashtable mapHash;
    private MetaCtrl meta;
    private RecordCtrl recordControl;
    private WavRate rateControl;
    private boolean isCapturePlayer = false;
    static String parseErr;
    private String runErr = null;
    byte[] intArray = new byte[4];

    public String getContentType() {
        this.chkClosed(true);
        return "audio/x-wav";
    }

    protected void doRealize() throws MediaException {
        this.contentLength = this.stream.getContentLength();
        if (this.contentLength == -1L) {
            this.contentLength = Long.MAX_VALUE;
        }
        if (this.source != null && this.source.getLocator() != null) {
            this.isCapturePlayer = this.source.getLocator().startsWith("capture:");
        }
        try {
            this.source.start();
            this.readHeader();
            this.bufferObject = new Buffer();
            int bufferSize = this.getBufferSize();
            if (bufferSize > 0) {
                this.bufferObject.data = new byte[bufferSize];
                this.bufferObject.length = bufferSize;
            }
            this.bufferObject.offset = 0;
            this.sleepTime = 16;
        }
        catch (IOException e) {
            throw new MediaException(e.getMessage());
        }
        this.vc = new VolCtrl(this);
    }

    int getBufferSize() {
        return this.bytesPerSecond / 32 & 0xFFFFFFFC;
    }

    public long doGetDuration() {
        return this.duration;
    }

    void readHeader() throws IOException {
        block14: {
            if (this.readInt() != 1179011410) {
                throw new IOException(parseErr);
            }
            int length = this.readInt();
            if (this.readInt() != 1163280727) {
                throw new IOException(parseErr);
            }
            length += 8;
            try {
                long currentPos;
                while ((currentPos = this.stream.tell()) < this.contentLength) {
                    int fourcc = this.readInt();
                    int size = this.readInt();
                    if (fourcc == 544501094) {
                        this.handleFMT(size);
                        continue;
                    }
                    if (fourcc == 1635017060) {
                        if (!this.fmtSeen) {
                            throw new IOException(parseErr + ": data chunk before fmt chunk");
                        }
                        this.startpt = this.stream.tell();
                        this.dataSeen = true;
                        if (size > 0) {
                            this.endpt = this.startpt + (long)size;
                            this.duration = (long)size * 1000000L / (long)this.bytesPerSecond;
                            if (this.endpt == this.contentLength || this.getSeekType() == this.NOT_SEEKABLE || this.endpt == (long)length) {
                                return;
                            }
                            this.skipFully(size);
                            if ((size & 1) <= 0) continue;
                            this.skipFully(1);
                            continue;
                        }
                        return;
                    }
                    if (fourcc == 1414744396) {
                        this.handleLIST(size);
                        continue;
                    }
                    this.skipFully(size);
                }
            }
            catch (IOException e) {
                if (this.fmtSeen && this.dataSeen) break block14;
                throw new IOException(parseErr);
            }
        }
        if (this.getSeekType() == this.RANDOM_ACCESSIBLE) {
            this.seekStrm(this.startpt);
        } else {
            this.seekStrm(0L);
            this.skipFully((int)this.startpt);
        }
        if (!this.fmtSeen || !this.dataSeen) {
            throw new IOException(parseErr);
        }
    }

    private void handleFMT(int formatSize) throws IOException {
        int remFormatSize = formatSize;
        this.encoding = this.readShort();
        this.channels = this.readShort();
        this.sampleRate = this.readInt();
        this.bytesPerSecond = this.readInt();
        this.blockAlign = this.readShort();
        this.sampleSizeInBits = this.readShort();
        if (this.encoding != 1 || this.sampleSizeInBits != 8 && this.sampleSizeInBits != 16 || this.channels != 1 && this.channels != 2) {
            throw new IOException("only supports PCM 8/16-bit mono/stereo");
        }
        if (this.sampleRate > 48000 || this.sampleRate < 500) {
            throw new IOException("unsupported sample rate");
        }
        this.isSigned = this.sampleSizeInBits == 16;
        this.samplesPerBlock = -1;
        if ((remFormatSize -= 16) > 0) {
            this.skipFully(remFormatSize);
        }
        this.bytesPerSecond = this.sampleRate * this.channels * this.sampleSizeInBits / 8;
        this.blockAlign = this.sampleSizeInBits / 8 * this.channels;
        this.fmtSeen = true;
    }

    private void handleLIST(int size) throws IOException {
        int listtype = this.readInt();
        if (listtype != 1330007625) {
            this.skipFully(size - 4);
            return;
        }
        size -= 4;
        if (this.meta == null) {
            if (mapHash == null) {
                mapHash = new Hashtable(4);
                mapHash.put("IART", "author");
                mapHash.put("ICOP", "copyright");
                mapHash.put("ICRD", "date");
                mapHash.put("INAM", "title");
            }
            this.meta = new MetaCtrl(mapHash);
        }
        int remainingSize = size;
        byte[] metabuffer = null;
        while (remainingSize > 0) {
            this.readFully(this.intArray, 0, 4);
            String key = new String(this.intArray);
            int length = this.readInt();
            if (metabuffer == null || metabuffer.length < length) {
                metabuffer = new byte[length];
            }
            this.readFully(metabuffer, 0, length);
            this.meta.put(key, new String(metabuffer, 0, length));
            remainingSize -= 8 + length;
            if ((length & 1) <= 0) continue;
            this.skipFully(1);
            --remainingSize;
        }
        metabuffer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPrefetch() throws MediaException {
        Object object = this.waveLock;
        synchronized (object) {
            if (!this.waveOut.isOpen()) {
                if (!this.waveOut.open(this.sampleRate, this.sampleSizeInBits, this.channels, this.isSigned, this.isBigEndian)) {
                    throw new MediaException("audio device");
                }
                if (this.vc.getLevel() == -1) {
                    this.vc.setLevel(this.waveOut.getVolume());
                } else {
                    this.waveOut.setVolume(this.vc.getLevel());
                }
                this.waveOut.setMediaTime(this.mediaTimeCache / 1000L);
                if (this.rateControl != null) {
                    this.rateControl.setRate(this.rateControl.getRate());
                }
            }
        }
        if (this.vc.isMuted()) {
            this.doSetLevel(0);
        } else {
            this.doSetLevel(this.vc.getLevel());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doStart() {
        if (this.started) {
            return true;
        }
        this.started = true;
        try {
            this.source.start();
        }
        catch (Exception ex) {
            return false;
        }
        Object object = this.playLock;
        synchronized (object) {
            if (this.playThread == null) {
                this.playThread = new Thread(this);
                this.playThread.setPriority(9);
                this.playThread.start();
            } else {
                this.playLock.notifyAll();
            }
        }
        if (this.recordControl != null) {
            this.recordControl.playerStart();
        }
        this.waveOut.resume();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws MediaException {
        if (!this.started) {
            return;
        }
        try {
            this.source.stop();
        }
        catch (IOException e) {
            throw new MediaException(e.getMessage());
        }
        this.started = false;
        Object object = this.pauseLock;
        synchronized (object) {
            while (!this.canPause) {
                try {
                    this.pauseLock.wait();
                }
                catch (Exception exception) {}
            }
            this.waveOut.pause();
            this.pauseLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeDevice() {
        Object object = this.waveLock;
        synchronized (object) {
            if (this.waveOut != null) {
                this.waveOut.flush();
                this.mediaTimeCache = this.waveOut.getMediaTime() * 1000L;
                this.waveOut.close();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDeallocate() {
        this.closeDevice();
        Object object = this.playLock;
        synchronized (object) {
            this.interrupted = true;
            this.playLock.notifyAll();
            if (this.playThread != null) {
                try {
                    this.playLock.wait(5000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    protected void doClose() {
        if (this.bufferObject != null) {
            this.bufferObject.data = null;
            this.bufferObject = null;
        }
        if (this.recordControl != null) {
            this.recordControl.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long doSetMediaTime(long now) throws MediaException {
        long ret = now;
        try {
            long pp = (long)this.bytesPerSecond * now / 1000000L / (long)this.blockAlign * (long)this.blockAlign + this.startpt;
            if (this.getState() == 400) {
                this.doStop();
            }
            Object object = this.readLock;
            synchronized (object) {
                if (this.getSeekType() == this.RANDOM_ACCESSIBLE) {
                    pp = this.seekStrm(pp);
                } else if (this.getSeekType() == this.SEEKABLE_TO_START && pp == this.startpt) {
                    this.seekStrm(0L);
                    this.skipFully((int)pp);
                } else {
                    throw new MediaException("stream is not seekable");
                }
            }
            ret = (pp - this.startpt) * 1000000L / (long)this.bytesPerSecond;
            if (this.getState() >= 300) {
                this.waveOut.flush();
                this.waveOut.setMediaTime(ret / 1000L);
            }
            if (this.getState() == 400) {
                this.doStart();
            }
        }
        catch (Exception e) {
            throw new MediaException(e.getMessage());
        }
        this.mediaTimeCache = ret;
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long doGetMediaTime() {
        long mt = 0L;
        Object object = this.waveLock;
        synchronized (object) {
            if (this.sampleRate == 0) {
                return 0L;
            }
            mt = this.state >= 300 ? this.waveOut.getMediaTime() * 1000L : this.mediaTimeCache;
        }
        return mt;
    }

    protected Control doGetControl(String type) {
        if (this.getState() >= 200 && type.startsWith("javax.microedition.media.control.")) {
            if (type.endsWith("VolumeControl")) {
                return this.vc;
            }
            if (!this.isCapturePlayer && type.endsWith("RateControl")) {
                if (this.rateControl == null) {
                    this.rateControl = new WavRate();
                }
                return this.rateControl;
            }
            if (type.endsWith("StopTimeControl")) {
                return this;
            }
            if (type.endsWith("MetaDataControl")) {
                return this.meta;
            }
            if (type.endsWith("RecordControl")) {
                if (this.recordControl == null) {
                    this.recordControl = new WavRC(this);
                }
                return this.recordControl;
            }
        }
        return null;
    }

    int readDecodedBytes(Buffer b) throws IOException {
        return this.readBytes(b.data, b.offset, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doProcess() {
        int len = 0;
        int wlen = 0;
        Object object = this.readLock;
        synchronized (object) {
            try {
                len = this.readDecodedBytes(this.bufferObject);
            }
            catch (IOException ioe) {
                this.runErr = ioe.getMessage();
                return false;
            }
        }
        if (len < 1) {
            object = this.pauseLock;
            synchronized (object) {
                this.canPause = false;
                while (this.waveOut.drain() == 0) {
                    if (this.stopTime != Long.MAX_VALUE && this.stopTime < this.doGetMediaTime()) {
                        this.canPause = true;
                        try {
                            this.doStop();
                        }
                        catch (MediaException e) {
                            // empty catch block
                        }
                        this.satev();
                        this.pauseLock.notifyAll();
                        return true;
                    }
                    try {
                        this.pauseLock.wait(20L);
                    }
                    catch (Exception ex) {}
                }
                this.canPause = true;
                this.pauseLock.notifyAll();
            }
            Thread.yield();
            this.started = false;
            long time = this.getMediaTime();
            if (this.duration == -1L) {
                this.duration = time;
                this.sendEvent("durationUpdated", new Long(this.duration));
            }
            this.sendEvent("endOfMedia", new Long(time));
            return true;
        }
        Object time = this.pauseLock;
        synchronized (time) {
            this.canPause = false;
            while ((wlen = this.waveOut.write(this.bufferObject.data, this.bufferObject.offset, len)) == 0) {
                try {
                    this.pauseLock.wait(this.sleepTime);
                }
                catch (Exception ex) {}
            }
            this.canPause = true;
            this.pauseLock.notifyAll();
        }
        if (wlen == -1) {
            return false;
        }
        Thread.yield();
        if (this.recordControl != null) {
            this.recordControl.record(this.bufferObject.data, this.bufferObject.offset, len);
        }
        if (this.stopTime != Long.MAX_VALUE && this.stopTime < this.doGetMediaTime()) {
            try {
                this.doStop();
            }
            catch (MediaException mediaException) {
                // empty catch block
            }
            this.satev();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object;
        boolean statusOK = true;
        while (true) {
            if (!this.interrupted && this.started && statusOK) {
                statusOK = this.doProcess();
                Thread.yield();
                continue;
            }
            object = this.playLock;
            synchronized (object) {
                if (this.interrupted || !statusOK) {
                    break;
                }
                try {
                    this.playLock.wait();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (!statusOK) {
            try {
                this.doStop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.closeDevice();
            this.doClose();
            this.state = 0;
        }
        this.started = false;
        this.interrupted = false;
        object = this.playLock;
        synchronized (object) {
            this.playThread = null;
            this.playLock.notifyAll();
        }
        if (!statusOK) {
            if (this.source != null) {
                this.source.disconnect();
            }
            this.sendEvent("error", this.runErr);
        }
    }

    byte readByte() throws IOException {
        this.stream.read(this.intArray, 0, 1);
        return this.intArray[0];
    }

    int readBytes(byte[] array, int offset, int num) throws IOException {
        long available = this.endpt - this.stream.tell();
        if (available <= 0L) {
            return -1;
        }
        if ((long)num > available) {
            num = (int)available;
        }
        return this.stream.read(array, offset, num);
    }

    private int readInt() throws IOException {
        if (this.readFully(this.intArray, 0, 4) < 4) {
            throw new IOException("malformed wave data");
        }
        return (this.intArray[3] & 0xFF) << 24 | (this.intArray[2] & 0xFF) << 16 | (this.intArray[1] & 0xFF) << 8 | this.intArray[0] & 0xFF;
    }

    private short readShort() throws IOException {
        if (this.readFully(this.intArray, 0, 2) < 2) {
            throw new IOException("malformed wave data");
        }
        return (short)((this.intArray[1] & 0xFF) << 8 | this.intArray[0] & 0xFF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doSetLevel(int vol) {
        Object object = this.waveLock;
        synchronized (object) {
            if (this.state >= 300) {
                this.waveOut.setVolume(vol);
            }
        }
        return vol;
    }

    static {
        parseErr = "Malformed wave media";
    }

    class WavRate
    implements RateControl {
        private int playRateMP = 100000;
        private int minRate = 10000;
        private int maxRate = 200000;

        WavRate() {
        }

        public int getRate() {
            return this.playRateMP;
        }

        public int setRate(int milliRate) {
            int state = WavPlayer.this.getState();
            if (milliRate < this.minRate) {
                milliRate = this.minRate;
            }
            if (milliRate > this.maxRate) {
                milliRate = this.maxRate;
            }
            this.playRateMP = milliRate;
            WavPlayer.this.waveOut.setRate(this.playRateMP);
            return this.playRateMP;
        }

        public int getMinRate() {
            return this.minRate;
        }

        public int getMaxRate() {
            return this.maxRate;
        }
    }
}

