/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mmedia;

import javax.microedition.media.control.PitchControl;
import javax.microedition.media.control.TempoControl;

class MIDIOut
implements PitchControl,
TempoControl {
    private int midiInst;
    private int seqInst;
    private int isTone;
    int mSMFTempo = 500000;
    private int mPitch;
    private int mRate = 100000;
    private int cachedTickPos;

    MIDIOut() {
    }

    private native int nWrite(int var1, int var2, int[] var3, int var4, int var5);

    private native int nLongMsg(int var1, byte[] var2, int var3, int var4);

    private native int nCommon(int var1, int var2, int var3);

    boolean midiOpen() {
        return this.midiOpen(-1);
    }

    boolean midiOpen(int device) {
        return this.midiOpen(device, this.isTone);
    }

    synchronized boolean midiOpen(int device, int toneFlag) {
        this.midiInst = this.nCommon(toneFlag, 0, device);
        return this.midiInst != 0;
    }

    void setTone() {
        this.isTone = 1;
    }

    int getToneChnl() {
        return this.nCommon(this.midiInst, 3, 0);
    }

    int getPolyphony() {
        return this.nCommon(1, 12, 0);
    }

    int getSoundSet() {
        return this.nCommon(1, 13, 0);
    }

    synchronized boolean midiIsOpen() {
        return this.midiInst != 0;
    }

    synchronized boolean shortMsg(int status, int data1, int data2) {
        return this.nCommon(this.midiInst, 1, status & 0xFF | (data1 & 0xFF) << 8 | (data2 & 0xFF) << 16) != 0;
    }

    synchronized int longMsg(byte[] data, int offset, int count) {
        return this.nLongMsg(this.midiInst, data, offset, count);
    }

    synchronized boolean midiClose() {
        boolean ret = this.nCommon(this.midiInst, 2, this.isTone) != 0;
        this.midiInst = 0;
        return ret;
    }

    synchronized int getVolume() {
        return this.nCommon(this.midiInst, 10, 0);
    }

    synchronized int setVolume(int level) {
        return this.nCommon(this.midiInst, 11, level);
    }

    synchronized int getChannelVolume(int channel) {
        return this.nCommon(this.midiInst, 14, channel);
    }

    synchronized boolean seqOpen(int resolution) {
        this.seqInst = this.nCommon(this.midiInst, 100, resolution);
        if (this.seqInst != 0) {
            this.nCommon(this.seqInst, 105, this.midiInst);
            this.nCommon(this.seqInst, 121, this.mSMFTempo);
            this.setPitch(this.mPitch);
            this.setRate(this.mRate);
            this.setTickPosition(this.cachedTickPos);
            return true;
        }
        return false;
    }

    synchronized boolean pause() {
        return this.nCommon(this.seqInst, 101, 0) != 0;
    }

    synchronized boolean resume() {
        return this.nCommon(this.seqInst, 102, 0) != 0;
    }

    synchronized void flush() {
        this.nCommon(this.seqInst, 103, 0);
    }

    synchronized boolean seqClose() {
        if (this.seqInst != 0) {
            this.mSMFTempo = this.nCommon(this.seqInst, 120, 0);
            this.mPitch = this.getPitch();
            this.mRate = this.getRate();
            this.cachedTickPos = (int)this.getTickPosition();
            boolean ret = this.nCommon(this.seqInst, 104, this.isTone) != 0;
            this.seqInst = 0;
            return ret;
        }
        return false;
    }

    synchronized int write(int[] data, int offset, int len) {
        return this.nWrite(this.seqInst, 1, data, offset, len);
    }

    boolean sort(int[] data, int offset, int len) {
        return this.nWrite(0, 2, data, offset, len) != 0;
    }

    synchronized long getTickPosition() {
        if (this.seqInst != 0) {
            return this.nCommon(this.seqInst, 110, 0);
        }
        return this.cachedTickPos;
    }

    synchronized long setTickPosition(long tickPos) {
        if (tickPos < 0L) {
            tickPos = 0L;
        }
        if (this.seqInst != 0) {
            return this.nCommon(this.seqInst, 111, (int)tickPos);
        }
        this.cachedTickPos = (int)tickPos;
        return tickPos;
    }

    synchronized long getCallback() {
        if (this.seqInst == 0) {
            return -1L;
        }
        return this.nCommon(this.seqInst, 150, 0);
    }

    public synchronized int setPitch(int mst) {
        if (mst > 36000) {
            mst = 36000;
        }
        if (mst < -36000) {
            mst = -36000;
        }
        this.mPitch = this.seqInst != 0 ? this.nCommon(this.seqInst, 141, mst) : mst;
        return this.mPitch;
    }

    public synchronized int getPitch() {
        if (this.seqInst != 0) {
            this.mPitch = this.nCommon(this.seqInst, 140, 0);
        }
        return this.mPitch;
    }

    public int getMaxPitch() {
        return 36000;
    }

    public int getMinPitch() {
        return -36000;
    }

    public synchronized int setRate(int milliRate) {
        if (milliRate < 1000) {
            milliRate = 1000;
        } else if (milliRate > 10005496) {
            milliRate = 10005496;
        }
        this.mRate = this.seqInst != 0 ? this.nCommon(this.seqInst, 131, milliRate) : milliRate;
        return this.mRate;
    }

    public synchronized int getRate() {
        if (this.seqInst != 0) {
            this.mRate = this.nCommon(this.seqInst, 130, 0);
        }
        return this.mRate;
    }

    public int getMaxRate() {
        return 10005496;
    }

    public int getMinRate() {
        return 1000;
    }

    static int convertTempo(int value) {
        long ret;
        if (value <= 0) {
            value = 1;
        }
        if ((ret = 60000000000L / (long)value) > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)ret;
    }

    public synchronized int setTempo(int milliTempo) {
        this.mSMFTempo = MIDIOut.convertTempo(milliTempo);
        if (this.mSMFTempo <= 0) {
            this.mSMFTempo = 1;
        }
        if (this.seqInst != 0) {
            this.mSMFTempo = this.nCommon(this.seqInst, 121, this.mSMFTempo);
        }
        return MIDIOut.convertTempo(this.mSMFTempo);
    }

    public synchronized int getTempo() {
        if (this.seqInst != 0) {
            this.mSMFTempo = this.nCommon(this.seqInst, 120, 0);
        }
        return MIDIOut.convertTempo(this.mSMFTempo);
    }
}

