/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mmedia;

class FileIO {
    static final int READ = 0;
    static final int WRITE = 1;
    static final String PREFIX = "/mmatemp_";
    private static byte[] tempDirArray = new byte[256];
    private static boolean cleanupDone = false;
    private static String tempDir = null;

    FileIO() {
    }

    static final native int nOpen(byte[] var0, int var1);

    static final native int nRead(int var0, byte[] var1, int var2, int var3);

    static final native int nWrite(int var0, byte[] var1, int var2, int var3);

    static final native boolean nSeek(int var0, int var1);

    static final native boolean nDelete(byte[] var0);

    static final String getTempFileName() {
        return FileIO.getTempDirectory() + PREFIX + System.currentTimeMillis();
    }

    private static final String getTempDirectory() {
        if (tempDir != null) {
            return tempDir;
        }
        int length = FileIO.nGetTempDirectory(tempDirArray);
        tempDir = length == 0 ? "/tmp" : new String(tempDirArray, 0, length);
        FileIO.removeTempFiles();
        return tempDir;
    }

    static final native boolean nClose(int var0);

    static final synchronized void removeTempFiles() {
        if (!cleanupDone) {
            cleanupDone = true;
            FileIO.nRemoveTempFiles((tempDir + PREFIX + "*").getBytes());
        }
    }

    private static native int nGetTempDirectory(byte[] var0);

    private static native void nRemoveTempFiles(byte[] var0);
}

