/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mmedia;

import com.sun.mmedia.BasicPlayer;
import com.sun.mmedia.VidCtrl;
import com.sun.mmedia.ZCamera;
import com.sun.mmedia.protocol.LocatorParser;
import java.io.IOException;
import javax.microedition.media.Control;
import javax.microedition.media.MediaException;

public final class CameraPlayer
extends BasicPlayer
implements Runnable {
    private ZCamera zcam;
    private Thread processThread;
    private boolean pause = true;
    private boolean paused;
    private boolean done;
    private byte[] rgb16Bit;
    private int[] rgb32Bit;
    private int sourceWidth = 160;
    private int sourceHeight = 120;
    private VidCtrl vidCtrl;
    private long timeAtStart;
    private long startTime;
    private int fpsX100;
    private Object pauseLock = new Object();
    private int frameCount;

    public CameraPlayer() {
    }

    public CameraPlayer(String locator, boolean con) throws MediaException, IOException {
        this();
        this.setLocator(locator, con);
    }

    public String getContentType() {
        this.chkClosed(true);
        return "video/vnd.sun.rgb565";
    }

    public void setLocator(String locator, boolean con) throws MediaException, IOException {
        String key;
        String enc = "rgb565";
        String fpsString = "5.00";
        LocatorParser lp = new LocatorParser(locator.toLowerCase());
        lp.getProtocol();
        if (!lp.getDevice().equals("video")) {
            throw new MediaException("Illegal parameters");
        }
        while ((key = lp.getParameter()) != null) {
            String value = lp.getValue();
            try {
                if (key.equals("encoding")) {
                    enc = value;
                    continue;
                }
                if (key.equals("width")) {
                    this.sourceWidth = Integer.parseInt(value);
                    continue;
                }
                if (key.equals("height")) {
                    this.sourceHeight = Integer.parseInt(value);
                    continue;
                }
                if (key.equals("fps")) {
                    fpsString = value;
                    continue;
                }
                if (key.equals("fps")) continue;
                if (key.equals("colors")) continue;
                throw new MediaException("Illegal option");
            }
            catch (NumberFormatException nfe) {
                throw new MediaException("Number format error");
            }
        }
        String sz = this.sourceWidth + "x" + this.sourceHeight;
        int dotIndex = fpsString.indexOf(".");
        this.fpsX100 = 500;
        try {
            if (dotIndex < 0) {
                this.fpsX100 = Integer.parseInt(fpsString) * 100;
            } else {
                String p1 = "0" + fpsString.substring(0, dotIndex);
                String p2 = fpsString.substring(dotIndex + 1);
                this.fpsX100 = Integer.parseInt(p1) * 100;
                this.fpsX100 += Integer.parseInt((p2 + "00").substring(0, 2));
            }
        }
        catch (NumberFormatException nfe) {
            throw new MediaException("Number format error");
        }
        if (!(!lp.hasMore() && enc.equals("rgb565") && (sz.equals("160x120") || sz.equals("320x240") || sz.equals("120x160") || sz.equals("240x320") || sz.equals("480x640") || sz.equals("480x320")) && this.fpsX100 >= 1 && this.fpsX100 <= 6000)) {
            throw new MediaException("Unsupported parameters");
        }
    }

    protected void doRealize() throws MediaException {
        this.zcam = new ZCamera();
        this.vidCtrl = new VidCtrl(this, this.sourceWidth, this.sourceHeight);
        this.vidCtrl.initRendering(4, this.sourceWidth, this.sourceHeight);
    }

    protected void doPrefetch() throws MediaException {
        if (!this.zcam.open()) {
            throw new MediaException("Camera not available");
        }
        if (this.processThread == null) {
            this.processThread = new Thread(this);
            this.processThread.start();
        }
        this.zcam.start(this.sourceWidth, this.sourceHeight);
        this.oneFrame();
        this.zcam.stop();
    }

    protected boolean doStart() {
        this.zcam.start(this.sourceWidth, this.sourceHeight);
        this.timeAtStart = System.currentTimeMillis();
        this.frameCount = 0;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPostStart() {
        Object object = this.pauseLock;
        synchronized (object) {
            this.pause = false;
            this.pauseLock.notifyAll();
            while (this.paused) {
                try {
                    this.pauseLock.wait(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() {
        this.startTime += System.currentTimeMillis() - this.timeAtStart;
        Object object = this.pauseLock;
        synchronized (object) {
            this.pause = true;
            this.pauseLock.notifyAll();
            while (!this.paused) {
                try {
                    this.pauseLock.wait(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    protected void doDeallocate() {
        this.zcam.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doClose() {
        if (this.vidCtrl != null) {
            this.vidCtrl.close();
            this.vidCtrl = null;
        }
        this.done = true;
        Object object = this.pauseLock;
        synchronized (object) {
            this.pauseLock.notifyAll();
        }
        this.zcam = null;
    }

    protected long doSetMediaTime(long time) throws MediaException {
        throw new MediaException("Cannot set media time");
    }

    protected long doGetMediaTime() {
        if (this.timeAtStart == 0L) {
            return 0L;
        }
        if (this.state > 300) {
            return (this.startTime + (System.currentTimeMillis() - this.timeAtStart)) * 1000L;
        }
        return this.startTime * 1000L;
    }

    protected long doGetDuration() {
        return -1L;
    }

    protected Control doGetControl(String cname) {
        if (cname.equals("javax.microedition.media.control.VideoControl") || cname.equals("javax.microedition.media.control.GUIControl")) {
            return this.vidCtrl;
        }
        if (cname.equals("javax.microedition.media.control.StopTimeControl")) {
            return this;
        }
        return null;
    }

    private void oneFrame() {
        int size;
        if (this.rgb16Bit == null) {
            this.rgb16Bit = new byte[this.sourceHeight * this.sourceWidth * 2];
        }
        if ((size = this.zcam.getImage(this.rgb16Bit, 0, this.rgb16Bit.length)) != 0) {
            this.convertTo32Bit(size < 0);
            this.vidCtrl.render(this.rgb32Bit);
        }
    }

    private void convertTo32Bit(boolean flip) {
        int j = 0;
        int y = 0;
        int yInc = 1;
        int yEnd = this.sourceHeight;
        int area = this.sourceWidth * this.sourceHeight;
        if (this.rgb32Bit == null) {
            this.rgb32Bit = new int[area];
        }
        if (flip) {
            yInc = -1;
            yEnd = -1;
            y = this.sourceHeight - 1;
        }
        while (y != yEnd) {
            int yOffset = y * this.sourceWidth;
            for (int x = 0; x < this.sourceWidth; ++x) {
                this.rgb32Bit[yOffset + x] = (this.rgb16Bit[j + 1] & 0xF8) << 16 | (this.rgb16Bit[j + 1] & 7) << 13 | (this.rgb16Bit[j] & 0xE0) << 5 | (this.rgb16Bit[j] & 0x1F) << 3;
                j += 2;
            }
            y += yInc;
        }
    }

    public void run() {
        while (!this.done) {
            if (this.pause) {
                this.pauseHere();
            }
            if (this.done) break;
            if (this.stopTime != Long.MAX_VALUE && this.stopTime < this.doGetMediaTime()) {
                Thread t = new Thread(){

                    public void run() {
                        CameraPlayer.this.doStop();
                        CameraPlayer.this.satev();
                    }
                };
                t.start();
            }
            long frameTime = 1000L * (long)this.frameCount / (long)this.fpsX100 * 100L;
            long now = System.currentTimeMillis() - this.timeAtStart;
            if (now < frameTime) {
                try {
                    Thread.sleep(frameTime - now);
                }
                catch (InterruptedException ie) {}
            } else {
                Thread.yield();
            }
            if (this.done) continue;
            this.oneFrame();
            ++this.frameCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pauseHere() {
        Object object = this.pauseLock;
        synchronized (object) {
            if (this.pause) {
                this.paused = true;
                this.pauseLock.notifyAll();
                while (this.pause && !this.done) {
                    try {
                        this.pauseLock.wait(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.paused = false;
                this.pauseLock.notifyAll();
            }
        }
    }
}

