/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.ssl;

import com.sun.midp.ssl.Cipher;
import com.sun.midp.ssl.CryptoException;
import com.sun.midp.ssl.Key;
import com.sun.midp.ssl.MessageDigest;
import com.sun.midp.ssl.Signature;

final class RSASig
extends Signature {
    byte alg;
    MessageDigest md = null;
    byte mode = 0;
    Key k = null;
    private static final byte[] PREFIX_MD5 = new byte[]{48, 32, 48, 12, 6, 8, 42, -122, 72, -122, -9, 13, 2, 5, 5, 0, 4, 16};
    private static final byte[] PREFIX_SHA1 = new byte[]{48, 33, 48, 9, 6, 5, 43, 14, 3, 2, 26, 5, 0, 4, 20};

    RSASig(byte by) {
        this.alg = by;
        try {
            if (this.alg == 1) {
                this.md = MessageDigest.getInstance((byte)1, false);
            } else if (this.alg == 2) {
                this.md = MessageDigest.getInstance((byte)2, false);
            }
        }
        catch (Exception exception) {
            this.md = null;
        }
    }

    public byte getAlgorithm() {
        return this.alg;
    }

    public short getLength() {
        if (this.k == null) {
            return 0;
        }
        return (short)(this.k.getSize() >>> 3);
    }

    public void init(Key key, byte by) throws CryptoException {
        if (!(by == 1 && key.getType() == 2 || by == 2 && key.getType() == 1)) {
            throw new CryptoException(2);
        }
        this.k = key;
        this.mode = by;
    }

    public void init(Key key, byte by, byte[] byArray, int n, int n2) throws CryptoException {
        throw new CryptoException(2);
    }

    public void update(byte[] byArray, int n, int n2) throws CryptoException {
        if (this.k == null) {
            throw new CryptoException(5);
        }
        if (this.md == null || this.mode != 1 && this.mode != 2) {
            throw new CryptoException(3);
        }
        this.md.update(byArray, n, n2);
    }

    public short sign(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws CryptoException {
        if (this.k == null) {
            throw new CryptoException(5);
        }
        if (this.md == null || this.mode != 1) {
            throw new CryptoException(3);
        }
        byte[] byArray3 = null;
        byArray3 = this.alg == 1 ? PREFIX_MD5 : PREFIX_SHA1;
        byte[] byArray4 = new byte[byArray3.length + this.md.getLength()];
        System.arraycopy(byArray3, 0, byArray4, 0, byArray3.length);
        this.md.doFinal(byArray, n, n2, byArray4, byArray3.length);
        Cipher cipher = Cipher.getInstance((byte)2, (boolean)false);
        cipher.init(this.k, (byte)1);
        return (short)cipher.doFinal(byArray4, 0, byArray4.length, byArray2, n3);
    }

    public boolean verify(byte[] byArray, int n, int n2, byte[] byArray2, int n3, short s) throws CryptoException {
        int n4;
        Object object;
        if (this.k == null) {
            throw new CryptoException(5);
        }
        if (this.md == null || this.mode != 2) {
            throw new CryptoException(3);
        }
        byte[] byArray3 = null;
        byte[] byArray4 = new byte[this.md.getLength()];
        this.md.doFinal(byArray, n, n2, byArray4, 0);
        try {
            object = Cipher.getInstance((byte)2, (boolean)false);
            object.init(this.k, (byte)2);
            byArray3 = new byte[this.k.getSize() >>> 3];
            n4 = object.doFinal(byArray2, n3, (int)s, byArray3, 0);
        }
        catch (Exception exception) {
            return false;
        }
        object = null;
        int n5 = 0;
        if (this.alg == 1) {
            object = PREFIX_MD5;
            n5 = ((Cipher)object).length + 16;
        } else {
            object = PREFIX_SHA1;
            n5 = ((Cipher)object).length + 20;
        }
        if (n4 != n5) {
            return false;
        }
        int n6 = 0;
        while (n6 < ((Cipher)object).length) {
            if (byArray3[n6] != object[n6]) {
                return false;
            }
            ++n6;
        }
        int n7 = ((Cipher)object).length;
        while (n7 < n5) {
            if (byArray3[n7] != byArray4[n7 - ((Cipher)object).length]) {
                return false;
            }
            ++n7;
        }
        return true;
    }
}

