/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.security;

import com.sun.midp.io.Util;
import com.sun.midp.io.j2me.storage.File;
import com.sun.midp.io.j2me.storage.RandomAccessStream;
import com.sun.midp.midletsuite.InvalidJadException;
import com.sun.midp.security.PermissionProperties;
import com.sun.midp.security.SecurityToken;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class Permissions {
    public static final String POLICY_FILENAME = "_policy.txt";
    public static final String INTERNAL_DOMAIN_NAME = "internal";
    public static final String UNTRUSTED_DOMAIN_NAME = "untrusted";
    private static final String[] names = new String[]{"com.sun.midp", "com.sun.midp.midletsuite.ams", "javax.microedition.io.Connector.http", "javax.microedition.io.Connector.socket", "javax.microedition.io.Connector.https", "javax.microedition.io.Connector.ssl", "javax.microedition.io.Connector.serversocket", "javax.microedition.io.Connector.datagram", "javax.microedition.io.Connector.datagramreceiver", "javax.microedition.io.Connector.comm", "javax.microedition.io.PushRegistry", "javax.microedition.io.Connector.sms", "javax.microedition.io.Connector.cbs", "javax.wireless.messaging.sms.send", "javax.wireless.messaging.sms.receive", "javax.wireless.messaging.cbs.receive", "javax.microedition.media.control.RecordControl", "javax.microedition.media.control.VideoControl.getSnapshot", "javax.microedition.io.Connector.mms", "javax.wireless.messaging.mms.send", "javax.wireless.messaging.mms.receive", "javax.microedition.io.Connector.obex.client", "javax.microedition.io.Connector.obex.server", "javax.microedition.io.Connector.obex.client.tcp", "javax.microedition.io.Connector.obex.server.tcp", "javax.microedition.pim.ContactList.read", "javax.microedition.pim.ContactList.write", "javax.microedition.pim.EventList.read", "javax.microedition.pim.EventList.write", "javax.microedition.pim.ToDoList.read", "javax.microedition.pim.ToDoList.write", "javax.microedition.io.Connector.file.read", "javax.microedition.io.Connector.file.write", "javax.microedition.io.Connector.bluetooth.client", "javax.microedition.io.Connector.bluetooth.server", "javax.bluetooth.RemoteDevice.authorize", "javax.microedition.location.Location", "javax.microedition.location.Orientation", "javax.microedition.location.ProximityListener", "javax.microedition.location.LandmarkStore.read", "javax.microedition.location.LandmarkStore.write", "javax.microedition.location.LandmarkStore.category", "javax.microedition.location.LandmarkStore.management", "javax.microedition.apdu.aid", "javax.microedition.jcrmi", "javax.microedition.securityservice.CMSMessageSignatureService", "javax.microedition.apdu.sat", "javax.microedition.content.ContentHandler"};
    static final String NET_ACCESS_DIALOG_TITLE = "Is it OK to Use Airtime ?";
    static final String NET_ACCESS_PERMISSION_QUESTION = "%1 wants to send and receive data using the network. This will use airtime and may result in charges. \n\nIs it OK to use airtime?";
    static final String OPEN_MESSAGE_DIALOG_TITLE = "Is it OK to Communicate via Messages?";
    static final String OPEN_MESSAGE_PERMISSION_QUESTION = "%1 wants to communicate using text message functionality.\n\nIs it OK to communicate?";
    static final String RECEIVE_MESSAGE_DIALOG_TITLE = "Is it OK to Receive Messages?";
    static final String RECEIVE_MESSAGE_PERMISSION_QUESTION = "%1 wants to receive text message(s).\n\nIs it OK to receive messages?";
    static final String SEND_MESSAGE_DIALOG_TITLE = "Is it OK to Send Messages?";
    static final String SEND_MESSAGE_PERMISSION_QUESTION = "%1 wants to send text message(s). This could result in charges.%3 message(s) will be sent to %2.\n\nIs it OK to send messages?";
    static final String MULTIMEDIA_DIALOG_TITLE = "Is it OK to Record?";
    static final String MULTIMEDIA_PERMISSION_QUESTION = "%1 wants to record an image or audio clip.\n\nIs it OK to record?";
    static final String RECEIVE_MMS_PERMISSION_QUESTION = "%1 wants to receive multimedia message(s).\n\nIs it OK to receive messages?";
    static final String SEND_MMS_PERMISSION_QUESTION = "%1 wants to send multimedia message(s). This could result in charges.%3 message(s) will be sent to %2.\n\nIs it OK to send messages?";
    static final String OBEX_CLIENT_PERMISSION_QUESTION = "%1 wants to create client OBEX connection.\n\n Is it OK to make the connection?";
    static final String OBEX_SERVER_PERMISSION_QUESTION = "%1 wants to open server OBEX connection. This means other devices can connect to yours\n\n Is it OK to make the connection?";
    static final String USER_DATA_PIM_READ_TITLE = "Is it OK to read user data?";
    static final String USER_DATA_PIM_WRITE_TITLE = "Is it OK to write user data?";
    static final String USER_DATA_FILE_READ_TITLE = "Is it OK to read local files?";
    static final String USER_DATA_FILE_WRITE_TITLE = "Is it OK to write local files?";
    static final String BLUETOOTH_AUTHORIZE_CONNECTION_TITLE = "Authorize connection?";
    static final String USER_DATA_PIM_CONTACT_READ_QUESTION = "%1 wants to read data from the address book.\n\nIs it OK to read from your address book?";
    static final String USER_DATA_PIM_CONTACT_WRITE_QUESTION = "%1 wants to write data to the address book.\n\nIs it OK to update your address book?";
    static final String USER_DATA_PIM_EVENT_READ_QUESTION = "%1 wants to read data from the calendar.\n\nIs it OK to read from your calendar?";
    static final String USER_DATA_PIM_EVENT_WRITE_QUESTION = "%1 wants to write data to the calendar.\n\nIs it OK to update your calendar?";
    static final String USER_DATA_PIM_TODO_READ_QUESTION = "%1 wants to read data from the to-do list.\n\nIs it OK to read from your to-do list?";
    static final String USER_DATA_PIM_TODO_WRITE_QUESTION = "%1 wants to write data to the to-do list.\n\nIs it OK to update your to-do list?";
    static final String USER_DATA_FILE_READ_QUESTION = "%1 wants to read from the local file system.\n\nIs it OK to read your files?";
    static final String USER_DATA_FILE_WRITE_QUESTION = "%1 wants to write the local file system.\n\nIs it OK to update your files?";
    static final String BLUETOOTH_CLIENT_PERMISSION_QUESTION = "%1 wants to create client Bluetooth connection.\n\n Is it OK to make the connection?";
    static final String BLUETOOTH_SERVER_PERMISSION_QUESTION = "%1 wants to open server Bluetooth connection. This means other Bluetooth devices can connect to yours\n\n Is it OK to make the connection?";
    static final String BLUETOOTH_AUTHORIZE_CONNECTION_QUESTION = "Application %1 received unauthorized bluetooth connection from %2.\n\nAuthorize this connection?";
    static final String LOCATION_QUESTION = "Application %1 wants to use the location services.\n\nAuthorize this connection?";
    static final String LOCATION_TITLE = "Location services";
    static final String CLIENT_DIALOG_TITLE = "OK to Send Information?";
    static final String CLIENT_PERMISSION_QUESTION = "%1 wants to send information. This will require the use of airtime which may cost you money. Is this OK? (%3)";
    static final String SERVER_DIALOG_TITLE = "OK to Receive Information?";
    static final String SERVER_PERMISSION_QUESTION = "%1 wants to receive information. This will require the use of airtime which may cost you money. Is this OK? (%3)";
    static final String APDU_DIALOG_TITLE = "OK to Access SmartCard?";
    static final String APDU_PERMISSION_QUESTION = "%1 wants to use the smart card. Is this OK? (%3)";
    static final String SIGN_PERMISSION_QUESTION = "%1 wants to use the signature service. Is this OK? (%3)";
    static final String SIGN_DIALOG_TITLE = "OK to sign message?";
    static final String CONTENT_HANDLER_PERMISSION_TITLE = "OK to update content handler?";
    static final String CONTENT_HANDLER_PERMISSION_QUESTION = "%1 wants to %3 as a content handler. Is this OK?";
    private static final String[] questions = new String[]{"com.sun.midp", "com.sun.midp.midletsuite.ams", "%1 wants to send and receive data using the network. This will use airtime and may result in charges. \n\nIs it OK to use airtime?", "%1 wants to send and receive data using the network. This will use airtime and may result in charges. \n\nIs it OK to use airtime?", "%1 wants to send and receive data using the network. This will use airtime and may result in charges. \n\nIs it OK to use airtime?", "%1 wants to send and receive data using the network. This will use airtime and may result in charges. \n\nIs it OK to use airtime?", "%1 wants to send and receive data using the network. This will use airtime and may result in charges. \n\nIs it OK to use airtime?", "%1 wants to send and receive data using the network. This will use airtime and may result in charges. \n\nIs it OK to use airtime?", "%1 wants to send and receive data using the network. This will use airtime and may result in charges. \n\nIs it OK to use airtime?", "%1 wants to connect to a computer. This may require a data cable.\n\nIs it OK to make a connection?", "%1 wants to receive automatic updates from the network. Receiving updates may result in charges.\n\nIs it OK to receive automatic updates?", "Is it OK to Communicate via Messages?", "Is it OK to Communicate via Messages?", "%1 wants to send text message(s). This could result in charges.%3 message(s) will be sent to %2.\n\nIs it OK to send messages?", "%1 wants to receive text message(s).\n\nIs it OK to receive messages?", "%1 wants to receive text message(s).\n\nIs it OK to receive messages?", "%1 wants to record an image or audio clip.\n\nIs it OK to record?", "%1 wants to record an image or audio clip.\n\nIs it OK to record?", "Is it OK to Communicate via Messages?", "%1 wants to send multimedia message(s). This could result in charges.%3 message(s) will be sent to %2.\n\nIs it OK to send messages?", "%1 wants to receive text message(s).\n\nIs it OK to receive messages?", "%1 wants to create client OBEX connection.\n\n Is it OK to make the connection?", "%1 wants to open server OBEX connection. This means other devices can connect to yours\n\n Is it OK to make the connection?", "%1 wants to send and receive data using the network. This will use airtime and may result in charges. \n\nIs it OK to use airtime?", "%1 wants to send and receive data using the network. This will use airtime and may result in charges. \n\nIs it OK to use airtime?", "%1 wants to read data from the address book.\n\nIs it OK to read from your address book?", "%1 wants to write data to the address book.\n\nIs it OK to update your address book?", "%1 wants to read data from the calendar.\n\nIs it OK to read from your calendar?", "%1 wants to write data to the calendar.\n\nIs it OK to update your calendar?", "%1 wants to read data from the to-do list.\n\nIs it OK to read from your to-do list?", "%1 wants to write data to the to-do list.\n\nIs it OK to update your to-do list?", "%1 wants to read from the local file system.\n\nIs it OK to read your files?", "%1 wants to write the local file system.\n\nIs it OK to update your files?", "%1 wants to create client Bluetooth connection.\n\n Is it OK to make the connection?", "%1 wants to open server Bluetooth connection. This means other Bluetooth devices can connect to yours\n\n Is it OK to make the connection?", "Application %1 received unauthorized bluetooth connection from %2.\n\nAuthorize this connection?", "Application %1 wants to use the location services.\n\nAuthorize this connection?", "Application %1 wants to use the location services.\n\nAuthorize this connection?", "Application %1 wants to use the location services.\n\nAuthorize this connection?", "Application %1 wants to use the location services.\n\nAuthorize this connection?", "Application %1 wants to use the location services.\n\nAuthorize this connection?", "Application %1 wants to use the location services.\n\nAuthorize this connection?", "Application %1 wants to use the location services.\n\nAuthorize this connection?", "%1 wants to use the smart card. Is this OK? (%3)", "%1 wants to use the smart card. Is this OK? (%3)", "%1 wants to use the signature service. Is this OK? (%3)", "%1 wants to use the smart card. Is this OK? (%3)", "%1 wants to %3 as a content handler. Is this OK?"};
    private static final String[] titles = new String[]{"com.sun.midp", "com.sun.midp.midletsuite.ams", "Is it OK to Use Airtime ?", "Is it OK to Use Airtime ?", "Is it OK to Use Airtime ?", "Is it OK to Use Airtime ?", "Is it OK to Use Airtime ?", "Is it OK to Use Airtime ?", "Is it OK to Use Airtime ?", "Is it OK to Connect?", "Is it OK to Receive Updates?", "Is it OK to Communicate via Messages?", "Is it OK to Communicate via Messages?", "Is it OK to Send Messages?", "Is it OK to Receive Messages?", "Is it OK to Receive Messages?", "Is it OK to Record?", "Is it OK to Record?", "Is it OK to Communicate via Messages?", "Is it OK to Send Messages?", "Is it OK to Receive Messages?", "Is it OK to Connect?", "Is it OK to Connect?", "Is it OK to Use Airtime ?", "Is it OK to Use Airtime ?", "Is it OK to read user data?", "Is it OK to write user data?", "Is it OK to read user data?", "Is it OK to write user data?", "Is it OK to read user data?", "Is it OK to write user data?", "Is it OK to read local files?", "Is it OK to write local files?", "Is it OK to Connect?", "Is it OK to Connect?", "Authorize connection?", "Location services", "Location services", "Location services", "Location services", "Location services", "Location services", "Location services", "OK to Access SmartCard?", "OK to Access SmartCard?", "OK to sign message?", "OK to Access SmartCard?", "OK to update content handler?"};
    public static final int MAX_LEVELS = 0;
    public static final int CUR_LEVELS = 1;
    public static final int MIDP = 0;
    public static final int AMS = 1;
    public static final int HTTP = 2;
    public static final int TCP = 3;
    public static final int HTTPS = 4;
    public static final int SSL = 5;
    public static final int TCP_SERVER = 6;
    public static final int UDP = 7;
    public static final int UDP_SERVER = 8;
    public static final int COMM = 9;
    public static final int PUSH = 10;
    public static final int SMS_SERVER = 11;
    public static final int CBS_SERVER = 12;
    public static final int SMS_SEND = 13;
    public static final int SMS_RECEIVE = 14;
    public static final int CBS_RECEIVE = 15;
    public static final int MM_RECORD = 16;
    public static final int MM_IMAGE_CAPTURING = 17;
    public static final int MMS_SERVER = 18;
    public static final int MMS_SEND = 19;
    public static final int MMS_RECEIVE = 20;
    public static final int OBEX_CLIENT = 21;
    public static final int OBEX_SERVER = 22;
    public static final int TCP_OBEX_CLIENT = 23;
    public static final int TCP_OBEX_SERVER = 24;
    public static final int PIM_CONTACT_READ = 25;
    public static final int PIM_CONTACT_WRITE = 26;
    public static final int PIM_EVENT_READ = 27;
    public static final int PIM_EVENT_WRITE = 28;
    public static final int PIM_TODO_READ = 29;
    public static final int PIM_TODO_WRITE = 30;
    public static final int FILE_CONNECTION_READ = 31;
    public static final int FILE_CONNECTION_WRITE = 32;
    public static final int BLUETOOTH_CLIENT = 33;
    public static final int BLUETOOTH_SERVER = 34;
    public static final int BT_AUTHORIZE = 35;
    public static final int LOCATION = 36;
    public static final int ORIENTATION = 37;
    public static final int LOCATION_PROXIMITY = 38;
    public static final int LANDMARK_READ = 39;
    public static final int LANDMARK_WRITE = 40;
    public static final int LANDMARK_CATEGORY = 41;
    public static final int LANDMARK_MANAGE = 42;
    public static final int APDU_CONNECTION = 43;
    public static final int JCRMI_CONNECTION = 44;
    public static final int SIGN_SERVICE = 45;
    public static final int APDU_CHANNEL0 = 46;
    public static final int CHAPI_REGISTER = 47;
    public static final int NUMBER_OF_PERMISSIONS = 48;
    public static final byte NEVER = 0;
    public static final byte ALLOW = 1;
    public static final byte BLANKET_GRANTED = 2;
    public static final byte BLANKET = 4;
    public static final byte SESSION = 8;
    public static final byte ONE_SHOT = 16;
    public static final byte DENY_SESSION = 32;
    public static final byte DENY = 64;
    public static final byte USER_DENIED = -128;
    private static Hashtable permissionsTable = null;
    public static final int[] autoInvokeGroup = new int[]{10, 47};
    public static final int[] netAccessGroup = new int[]{2, 3, 4, 5, 6, 7, 8, 23, 24};
    public static final int[] messagingGroup = new int[]{11, 12, 18, 13, 19, 14, 15, 14};
    public static final int[] multimediaRecordingGroup = new int[]{16, 17};
    public static final int[] localConnGroup = new int[]{9, 21, 22, 33, 34};
    public static final int[] readUserDataGroup = new int[]{25, 27, 29, 31};
    public static final int[] writeUserDataGroup = new int[]{26, 28, 30, 32};
    public static final int[] locationGroup = new int[]{36, 37, 38, 39, 40, 41, 42};
    public static final int[] satsaGroup = new int[]{43, 44, 45, 46};

    public static String getName(int permission) {
        if (permission < 0 || permission >= names.length) {
            throw new SecurityException("Application not authorized to access the restricted API");
        }
        return names[permission];
    }

    public static String getTitle(int permission) {
        if (permission < 0 || permission >= titles.length) {
            throw new SecurityException("Application not authorized to access the restricted API");
        }
        return titles[permission];
    }

    public static String getQuestion(int permission) {
        if (permission < 0 || permission >= questions.length) {
            throw new SecurityException("Application not authorized to access the restricted API");
        }
        return questions[permission];
    }

    public static byte[][] forDomain(SecurityToken token, String name) {
        byte[] maximums = new byte[48];
        byte[] defaults = new byte[48];
        byte[][] permissions = new byte[][]{maximums, defaults};
        if (INTERNAL_DOMAIN_NAME.equals(name)) {
            for (int i = 0; i < maximums.length; ++i) {
                maximums[i] = 1;
                defaults[i] = 1;
            }
            return permissions;
        }
        if (Permissions.getPermissions(token, name, maximums, defaults)) {
            return permissions;
        }
        if (Permissions.getPermissions(token, UNTRUSTED_DOMAIN_NAME, maximums, defaults)) {
            return permissions;
        }
        throw new SecurityException("untrusted domain is not configured");
    }

    public static byte[] getEmptySet() {
        byte[] permissions = new byte[48];
        Permissions.clearPerms(permissions);
        return permissions;
    }

    private static Vector expandAlias(Vector apiList, Hashtable aliasTable) {
        boolean aliasMatch = false;
        if (aliasTable == null || apiList == null) {
            return apiList;
        }
        Vector returnList = new Vector(apiList.size());
        for (int apiIdx = 0; apiIdx < apiList.size(); ++apiIdx) {
            String apiName = (String)apiList.elementAt(apiIdx);
            if (apiName.indexOf(46) == -1) {
                Enumeration e = aliasTable.keys();
                while (e.hasMoreElements()) {
                    String aliasName = (String)e.nextElement();
                    if (!apiName.equals(aliasName)) continue;
                    Vector aliasVector = (Vector)aliasTable.get(aliasName);
                    for (int i = 0; i < aliasVector.size(); ++i) {
                        returnList.addElement(aliasVector.elementAt(i));
                    }
                    aliasMatch = true;
                    break;
                }
            }
            if (aliasMatch) {
                aliasMatch = false;
                continue;
            }
            returnList.addElement(apiName);
        }
        return returnList;
    }

    private static void clearPerms(byte[] perms) {
        for (int i = 0; i < perms.length; ++i) {
            perms[i] = 0;
        }
    }

    private static int getPermIndex(String apiName) {
        for (int nameIdx = 0; nameIdx < names.length; ++nameIdx) {
            if (!names[nameIdx].equals(apiName)) continue;
            return nameIdx;
        }
        throw new IllegalArgumentException("bad API name: " + apiName);
    }

    private static void setPerms(byte[] perms, Vector apiList, byte highestLevel, byte defaultLevel) {
        for (int apiIdx = 0; apiIdx < apiList.size(); ++apiIdx) {
            int permIdx = Permissions.getPermIndex((String)apiList.elementAt(apiIdx)) * 2;
            perms[permIdx] = highestLevel;
            perms[permIdx + 1] = defaultLevel;
        }
    }

    private static byte getPermFromString(String permString) {
        if ("allow".equals(permString)) {
            return 1;
        }
        if ("blanket".equals(permString)) {
            return 4;
        }
        if ("session".equals(permString)) {
            return 8;
        }
        if ("oneshot".equals(permString)) {
            return 16;
        }
        throw new IllegalArgumentException("bad perm level: " + permString);
    }

    private static void readPermissionsTable(SecurityToken token) throws InvalidJadException {
        InputStream permIS;
        RandomAccessStream storage;
        try {
            storage = new RandomAccessStream(token);
            storage.connect(File.getStorageRootFor(POLICY_FILENAME), 1);
            permIS = storage.openInputStream();
        }
        catch (Exception e) {
            throw new InvalidJadException(2);
        }
        try {
            PermissionProperties pp = new PermissionProperties();
            byte[] newPerms = new byte[96];
            String currentDomain = null;
            Hashtable<String, Vector> aliasTable = null;
            pp.load(permIS);
            Permissions.clearPerms(newPerms);
            for (int i = 0; i < pp.size(); ++i) {
                byte defaultPerm;
                byte perm;
                String propertyKey = pp.getKeyAt(i);
                String propertyValue = pp.getValueAt(i);
                if ("alias".equals(propertyKey)) {
                    int nameIdx = propertyValue.indexOf(32);
                    String aliasName = propertyValue.substring(0, nameIdx);
                    String aliasValue = propertyValue.substring(nameIdx + 1, propertyValue.length());
                    if (aliasTable == null) {
                        aliasTable = new Hashtable<String, Vector>();
                    }
                    aliasTable.put(aliasName, Util.getCommaSeparatedValues(aliasValue));
                    continue;
                }
                if ("domain".equals(propertyKey)) {
                    if (permissionsTable == null) {
                        permissionsTable = new Hashtable();
                    }
                    if (currentDomain != null) {
                        permissionsTable.put(currentDomain, newPerms);
                        newPerms = new byte[96];
                        Permissions.clearPerms(newPerms);
                    }
                    currentDomain = propertyValue;
                    continue;
                }
                if ("allow".equals(propertyKey)) {
                    Vector apiNames = Util.getCommaSeparatedValues(propertyValue);
                    apiNames = Permissions.expandAlias(apiNames, aliasTable);
                    Permissions.setPerms(newPerms, apiNames, (byte)1, (byte)1);
                    continue;
                }
                int defaultPermIdx = propertyKey.indexOf(40);
                if (defaultPermIdx != -1) {
                    String permString = propertyKey.substring(0, defaultPermIdx);
                    String defaultPermString = propertyKey.substring(defaultPermIdx + 1, propertyKey.indexOf(41));
                    perm = Permissions.getPermFromString(permString);
                    defaultPerm = Permissions.getPermFromString(defaultPermString);
                } else {
                    perm = Permissions.getPermFromString(propertyKey);
                    defaultPerm = 64;
                }
                Vector apiNames = Util.getCommaSeparatedValues(propertyValue);
                apiNames = Permissions.expandAlias(apiNames, aliasTable);
                Permissions.setPerms(newPerms, apiNames, perm, defaultPerm);
            }
            if (permissionsTable == null) {
                permissionsTable = new Hashtable();
            }
            if (currentDomain != null) {
                permissionsTable.put(currentDomain, newPerms);
            }
        }
        catch (Exception e) {
            System.out.println("Corrupt policy file");
            e.printStackTrace();
            permissionsTable = null;
            throw new InvalidJadException(28);
        }
        finally {
            try {
                storage.disconnect();
            }
            catch (Exception e) {}
        }
    }

    public static boolean isValidDomainName(SecurityToken token, String domain) {
        byte[] permList;
        if (INTERNAL_DOMAIN_NAME.equals(domain)) {
            return true;
        }
        if (permissionsTable == null) {
            try {
                Permissions.readPermissionsTable(token);
            }
            catch (InvalidJadException ije) {
                return false;
            }
        }
        return (permList = (byte[])permissionsTable.get(domain)) != null;
    }

    private static boolean getPermissions(SecurityToken token, String domain, byte[] permissions, byte[] defaults) {
        byte[] permList;
        if (permissionsTable == null) {
            try {
                Permissions.readPermissionsTable(token);
            }
            catch (InvalidJadException ije) {
                return false;
            }
        }
        if ((permList = (byte[])permissionsTable.get(domain)) != null) {
            for (int idx = 0; idx < 48; ++idx) {
                int permIdx = idx * 2;
                permissions[idx] = permList[permIdx];
                defaults[idx] = permList[permIdx + 1];
            }
            return true;
        }
        return false;
    }

    public static void setPermissionGroup(byte[] current, int permission, byte level) {
        switch (permission) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 23: 
            case 24: {
                if (current[2] != 0) {
                    current[2] = level;
                }
                if (current[3] != 0) {
                    current[3] = level;
                }
                if (current[4] != 0) {
                    current[4] = level;
                }
                if (current[5] != 0) {
                    current[5] = level;
                }
                if (current[6] != 0) {
                    current[6] = level;
                }
                if (current[7] != 0) {
                    current[7] = level;
                }
                if (current[8] != 0) {
                    current[8] = level;
                }
                if (current[23] != 0) {
                    current[23] = level;
                }
                if (current[24] != 0) {
                    current[24] = level;
                }
                return;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: {
                if (level == 16 || level == 8 || level == 2) {
                    if (current[11] != 0) {
                        current[11] = 2;
                    }
                    if (current[12] != 0) {
                        current[12] = 2;
                    }
                    if (current[18] != 0) {
                        current[18] = 2;
                    }
                    if (current[14] != 0) {
                        current[14] = 2;
                    }
                    if (current[15] != 0) {
                        current[15] = 2;
                    }
                    if (current[20] != 0) {
                        current[20] = 2;
                    }
                } else {
                    if (current[11] != 0) {
                        current[11] = level;
                    }
                    if (current[12] != 0) {
                        current[12] = level;
                    }
                    if (current[18] != 0) {
                        current[18] = 2;
                    }
                    if (current[14] != 0) {
                        current[14] = level;
                    }
                    if (current[15] != 0) {
                        current[15] = level;
                    }
                    if (current[20] != 0) {
                        current[20] = 2;
                    }
                }
                if (current[13] != 0) {
                    current[13] = level;
                }
                if (current[19] != 0) {
                    current[19] = level;
                }
                return;
            }
            case 16: 
            case 17: {
                if (current[16] != 0) {
                    current[16] = level;
                }
                if (current[17] != 0) {
                    current[17] = level;
                }
                return;
            }
            case 10: 
            case 47: {
                if (current[10] != 0) {
                    current[10] = level;
                }
                if (current[47] != 0) {
                    current[47] = level;
                }
                return;
            }
            case 9: 
            case 21: 
            case 22: 
            case 33: 
            case 34: {
                if (current[9] != 0) {
                    current[9] = level;
                }
                if (current[21] != 0) {
                    current[21] = level;
                }
                if (current[22] != 0) {
                    current[22] = level;
                }
                if (current[33] != 0) {
                    current[33] = level;
                }
                if (current[34] != 0) {
                    current[34] = level;
                }
                return;
            }
            case 25: 
            case 27: 
            case 29: 
            case 31: {
                if (current[25] != 0) {
                    current[25] = level;
                }
                if (current[27] != 0) {
                    current[27] = level;
                }
                if (current[29] != 0) {
                    current[29] = level;
                }
                if (current[31] != 0) {
                    current[31] = level;
                }
                return;
            }
            case 26: 
            case 28: 
            case 30: 
            case 32: {
                if (current[26] != 0) {
                    current[26] = level;
                }
                if (current[28] != 0) {
                    current[28] = level;
                }
                if (current[30] != 0) {
                    current[30] = level;
                }
                if (current[32] != 0) {
                    current[32] = level;
                }
                return;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                if (current[36] != 0) {
                    current[36] = level;
                }
                if (current[37] != 0) {
                    current[37] = level;
                }
                if (current[38] != 0) {
                    current[38] = level;
                }
                if (current[39] != 0) {
                    current[39] = level;
                }
                if (current[40] != 0) {
                    current[40] = level;
                }
                if (current[41] != 0) {
                    current[41] = level;
                }
                if (current[42] != 0) {
                    current[42] = level;
                }
                return;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                if (current[43] != 0) {
                    current[43] = level;
                }
                if (current[44] != 0) {
                    current[44] = level;
                }
                if (current[45] != 0) {
                    current[45] = level;
                }
                if (current[46] != 0) {
                    current[46] = level;
                }
                return;
            }
        }
        if (current[permission] != 0) {
            current[permission] = level;
        }
    }

    public static void setPermissionAsked(byte[] current, int permission, byte level) {
        switch (permission) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 23: 
            case 24: {
                current[2] = level;
                current[3] = level;
                current[4] = level;
                current[5] = level;
                current[6] = level;
                current[7] = level;
                current[8] = level;
                current[23] = level;
                current[24] = level;
                return;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: {
                if (level == 16 || level == 8 || level == 2) {
                    current[11] = 2;
                    current[12] = 2;
                    current[18] = 2;
                    current[14] = 2;
                    current[15] = 2;
                    current[20] = 2;
                } else {
                    current[11] = level;
                    current[12] = level;
                    current[18] = 2;
                    current[14] = level;
                    current[15] = level;
                    current[20] = 2;
                }
                current[13] = level;
                current[19] = level;
                return;
            }
            case 16: 
            case 17: {
                current[16] = level;
                current[17] = level;
                return;
            }
            case 10: 
            case 47: {
                current[10] = level;
                current[47] = level;
                return;
            }
            case 9: 
            case 21: 
            case 22: 
            case 33: 
            case 34: {
                current[9] = level;
                current[21] = level;
                current[22] = level;
                current[33] = level;
                current[34] = level;
                return;
            }
            case 25: 
            case 27: 
            case 29: 
            case 31: {
                current[25] = level;
                current[27] = level;
                current[29] = level;
                current[31] = level;
                return;
            }
            case 26: 
            case 28: 
            case 30: 
            case 32: {
                current[26] = level;
                current[28] = level;
                current[30] = level;
                current[32] = level;
                return;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                current[36] = level;
                current[37] = level;
                current[38] = level;
                current[39] = level;
                current[40] = level;
                current[41] = level;
                current[42] = level;
                return;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                current[36] = level;
                current[37] = level;
                current[38] = level;
                current[39] = level;
                return;
            }
        }
        current[permission] = level;
    }
}

