/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.midlet;

import com.sun.midp.content.AppMonitor;
import com.sun.midp.lcdui.DisplayManager;
import com.sun.midp.lcdui.DisplayManagerFactory;
import com.sun.midp.lcdui.MIDletEventListener;
import com.sun.midp.lcdui.SystemEventListener;
import com.sun.midp.main.Configuration;
import com.sun.midp.midlet.MIDletState;
import com.sun.midp.midlet.MIDletStateMap;
import com.sun.midp.midlet.MIDletSuite;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

public class Scheduler
implements SystemEventListener,
MIDletEventListener {
    private MIDletSuite midletSuite;
    private MIDletState[] midlets;
    private int nmidlets;
    private int scanIndex;
    private DisplayManager displayManager;
    private boolean systemShutdown;
    private static Object mutex;
    private static Scheduler scheduler;
    private Thread schedulerThread;

    protected Scheduler() {
        if (scheduler != null) {
            throw new Error("Only one scheduler instance allowed");
        }
        mutex = new Object();
        this.nmidlets = 0;
        this.midlets = new MIDletState[5];
    }

    public static synchronized Scheduler getScheduler() {
        if (scheduler == null) {
            String prop = Configuration.getProperty("com.sun.midp.midlet.scheduler");
            if (prop != null) {
                Class<?> c;
                try {
                    c = Class.forName(prop);
                }
                catch (Throwable ex) {
                    throw new Error("A scheduler class cannot be loaded from the value of property com.sun.midp.midlet.scheduler");
                }
                try {
                    scheduler = (Scheduler)c.newInstance();
                }
                catch (Throwable ex) {
                    throw new Error("The construction of " + prop + " instance failed");
                }
            }
            scheduler = new Scheduler();
        }
        return scheduler;
    }

    private DisplayManager getDisplayManager() {
        if (this.displayManager == null) {
            this.displayManager = DisplayManagerFactory.getDisplayManager();
        }
        return this.displayManager;
    }

    public void scheduleMIDlet(MIDlet midlet) {
        this.midletSuite.checkIfPermissionAllowed(1);
        this.register(midlet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void register(MIDlet midlet) {
        Object object = mutex;
        synchronized (object) {
            MIDletState state = MIDletStateMap.getState(midlet);
            int i = this.findMIDletByClass(state);
            if (i >= 0) {
                state.setState(5);
            }
            if (this.nmidlets >= this.midlets.length) {
                MIDletState[] n = new MIDletState[this.nmidlets + 5];
                System.arraycopy(this.midlets, 0, n, 0, this.nmidlets);
                this.midlets = n;
            }
            this.midlets[this.nmidlets++] = state;
            mutex.notify();
        }
    }

    protected Object getMutex() {
        return mutex;
    }

    public MIDletSuite getMIDletSuite() {
        return this.midletSuite;
    }

    public boolean isDispatchThread() {
        return Thread.currentThread() == this.schedulerThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean schedule(MIDletSuite aMidletSuite) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (this.midletSuite != null) {
            throw new RuntimeException("There is already a MIDlet Suite scheduled.");
        }
        this.schedulerThread = Thread.currentThread();
        this.getDisplayManager().addSystemEventListener(this);
        this.midletSuite = aMidletSuite;
        this.register(MIDletState.createMIDlet(this.midletSuite.getInitialMIDletClassname()));
        block28: while (this.nmidlets > 0) {
            try {
                int state;
                MIDletState curr;
                Object object = mutex;
                synchronized (object) {
                    curr = this.selectByPriority();
                    state = curr.getState();
                    switch (state) {
                        case 0: 
                        case 1: {
                            try {
                                mutex.wait();
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                            continue block28;
                        }
                        case 2: 
                        case 3: {
                            curr.setStateWithoutNotify(1);
                            break;
                        }
                        case 4: {
                            curr.setStateWithoutNotify(0);
                            break;
                        }
                        case 5: {
                            curr.setStateWithoutNotify(6);
                            break;
                        }
                        case 6: {
                            this.unregister(curr);
                            break;
                        }
                        default: {
                            throw new Error("Illegal MIDletState state " + curr.getState());
                        }
                    }
                }
                switch (state) {
                    case 2: {
                        this.getDisplayManager().activate(this, curr.getMIDlet());
                    }
                    case 3: {
                        try {
                            curr.startApp();
                        }
                        catch (Exception ex) {
                            Scheduler.printException("startApp threw an Exception", ex);
                            curr.setState(5);
                        }
                        break;
                    }
                    case 4: {
                        try {
                            curr.pauseApp();
                            curr.notifyMIDletPaused(true);
                        }
                        catch (Exception ex) {
                            Scheduler.printException("pauseApp threw an Exception", ex);
                            curr.setState(5);
                        }
                        break;
                    }
                    case 5: {
                        try {
                            curr.destroyApp(true);
                        }
                        catch (MIDletStateChangeException ex) {
                        }
                        catch (Exception ex) {
                            Scheduler.printException("destroyApp threw an Exception", ex);
                        }
                        break;
                    }
                    case 6: {
                        this.getDisplayManager().deactivate(curr.getMIDlet());
                    }
                }
            }
            catch (Exception ex) {
                System.out.println("Exception in schedule");
                ex.printStackTrace();
            }
        }
        this.midletSuite.saveSettings();
        this.midletSuite = null;
        this.getDisplayManager().releaseSystemEventListener(this);
        return !this.systemShutdown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = mutex;
        synchronized (object) {
            this.systemShutdown = true;
            for (int i = 0; i < this.nmidlets; ++i) {
                if (this.midlets[i].getState() == 6) continue;
                this.midlets[i].setStateWithoutNotify(5);
            }
            mutex.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isScheduled(String name) {
        boolean found = false;
        Object object = mutex;
        synchronized (object) {
            for (int i = 0; i < this.nmidlets; ++i) {
                if (!this.midlets[i].getMIDlet().getClass().getName().equals(name)) continue;
                found = true;
                break;
            }
        }
        return found;
    }

    public void pauseMIDlet(MIDlet midlet) {
        MIDletState state = MIDletStateMap.getState(midlet);
        state.setState(4);
    }

    public void startMIDlet(MIDlet midlet) {
        MIDletState state = MIDletStateMap.getState(midlet);
        state.setState(3);
    }

    public void destroyMIDlet(MIDlet midlet) {
        MIDletState state = MIDletStateMap.getState(midlet);
        state.setState(5);
    }

    private MIDletState selectByPriority() {
        MIDletState found = null;
        int state = -1;
        for (int i = this.nmidlets - 1; i >= 0; --i) {
            int s;
            if (this.scanIndex < 0 || this.scanIndex >= this.nmidlets) {
                this.scanIndex = this.nmidlets - 1;
            }
            if ((s = this.midlets[this.scanIndex].getState()) > state) {
                found = this.midlets[this.scanIndex];
                state = s;
            }
            --this.scanIndex;
        }
        return found;
    }

    private void unregister(MIDletState m) {
        for (int i = 0; i < this.nmidlets; ++i) {
            if (m != this.midlets[i]) continue;
            this.midlets[i] = this.midlets[this.nmidlets - 1];
            this.midlets[--this.nmidlets] = null;
            AppMonitor.midletRemoved(this.midletSuite.getStorageName(), m.getMIDlet().getClass().getName());
            break;
        }
    }

    private int findMIDletByClass(MIDletState m) {
        for (int i = 0; i < this.nmidlets; ++i) {
            if (m.getMIDlet().getClass() != this.midlets[i].getMIDlet().getClass()) continue;
            return i;
        }
        return -1;
    }

    private static void printException(String msg, Exception ex) {
        try {
            System.out.println(msg);
            if (ex.getMessage() == null) {
                System.out.println(ex);
            }
            ex.printStackTrace();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

